/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.FilenameUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.FileUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.main.application.FreeplaneSecurityManager;
import org.freeplane.plugin.script.CompileTimeStrategy;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptSecurity;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.ScriptingSecurityManager;
import org.freeplane.plugin.script.proxy.ProxyFactory;

public class GenericScript
implements IScript {
    private final String script;
    private final ScriptingPermissions specificPermissions;
    private CompiledScript compiledScript;
    private Throwable errorsInScript;
    private IFreeplaneScriptErrorHandler errorHandler;
    private PrintStream outStream;
    private ScriptContext scriptContext;
    private static final Object scriptEngineManagerMutex = new Object();
    private static ScriptEngineManager scriptEngineManager;
    private static URLClassLoader classLoader;
    private final ScriptEngine engine;
    private boolean compilationEnabled = true;
    private CompileTimeStrategy compileTimeStrategy;

    public GenericScript(String script, ScriptEngine engine, ScriptingPermissions permissions) {
        this.script = script;
        this.specificPermissions = permissions;
        this.engine = engine;
        this.compiledScript = null;
        this.errorsInScript = null;
        this.errorHandler = ScriptResources.IGNORING_SCRIPT_ERROR_HANDLER;
        this.outStream = System.out;
        this.scriptContext = null;
        this.compileTimeStrategy = new CompileTimeStrategy(null);
    }

    public GenericScript(String script, String scriptEngineName, ScriptingPermissions permissions) {
        this(script, GenericScript.findScriptEngine(scriptEngineName), permissions);
    }

    public GenericScript(File scriptFile, ScriptingPermissions permissions) {
        this(GenericScript.slurpFile(scriptFile), GenericScript.findScriptEngine(scriptFile), permissions);
        this.engine.put("javax.script.filename", scriptFile.toString());
        this.compilationEnabled = !this.disableScriptCompilation(scriptFile);
        this.compileTimeStrategy = new CompileTimeStrategy(scriptFile);
    }

    private static String slurpFile(File scriptFile) {
        try {
            return FileUtils.slurpFile((File)scriptFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IScript setErrorHandler(IFreeplaneScriptErrorHandler pErrorHandler) {
        this.errorHandler = pErrorHandler;
        return this;
    }

    public IScript setOutStream(PrintStream outStream) {
        this.outStream = outStream;
        return this;
    }

    public IScript setScriptContext(ScriptContext scriptContext) {
        this.scriptContext = scriptContext;
        return this;
    }

    public Object getScript() {
        return this.script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(NodeModel node) {
        try {
            if (this.errorsInScript != null) {
                throw new ExecuteScriptException(this.errorsInScript.getMessage(), this.errorsInScript);
            }
            ScriptingPermissions originalScriptingPermissions = new ScriptingPermissions(ResourceController.getResourceController().getProperties());
            ScriptingSecurityManager scriptingSecurityManager = this.createScriptingSecurityManager();
            FreeplaneSecurityManager securityManager = (FreeplaneSecurityManager)System.getSecurityManager();
            boolean needToSetFinalSecurityManager = securityManager.needToSetFinalSecurityManager();
            try {
                SimpleScriptContext context = this.createScriptContext(node);
                if (this.compilationEnabled && this.engine instanceof Compilable) {
                    this.compileAndCache((Compilable)((Object)this.engine));
                    if (needToSetFinalSecurityManager) {
                        securityManager.setFinalSecurityManager((SecurityManager)scriptingSecurityManager);
                    }
                    Object object = this.compiledScript.eval(context);
                    return object;
                }
                if (needToSetFinalSecurityManager) {
                    securityManager.setFinalSecurityManager((SecurityManager)scriptingSecurityManager);
                }
                Object object = this.engine.eval(this.script, (javax.script.ScriptContext)context);
                return object;
            }
            finally {
                if (needToSetFinalSecurityManager && securityManager.hasFinalSecurityManager()) {
                    securityManager.removeFinalSecurityManager((SecurityManager)scriptingSecurityManager);
                }
                originalScriptingPermissions.restorePermissions();
            }
        }
        catch (ScriptException e) {
            this.handleScriptRuntimeException(e);
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            if (Controller.getCurrentController().getSelection() == null) throw new ExecuteScriptException(e.getMessage(), e);
            Controller.getCurrentModeController().getMapController().select(node);
            throw new ExecuteScriptException(e.getMessage(), e);
        }
    }

    private ScriptingSecurityManager createScriptingSecurityManager() {
        return new ScriptSecurity(this.script, this.specificPermissions, this.outStream).getScriptingSecurityManager();
    }

    private boolean disableScriptCompilation(File scriptFile) {
        return FilenameUtils.isExtension((String)scriptFile.getName(), (String[])ScriptResources.SCRIPT_COMPILATION_DISABLED_EXTENSIONS);
    }

    private SimpleScriptContext createScriptContext(NodeModel node) {
        SimpleScriptContext context = new SimpleScriptContext();
        context.setWriter(new OutputStreamWriter(this.outStream));
        context.setErrorWriter(new OutputStreamWriter(this.outStream));
        context.setBindings(this.createBinding(node), 100);
        return context;
    }

    private Bindings createBinding(NodeModel node) {
        Bindings binding = this.engine.createBindings();
        binding.put("c", (Object)ProxyFactory.createController(this.scriptContext));
        binding.put("node", (Object)ProxyFactory.createNode(node, this.scriptContext));
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScriptEngineManager getScriptEngineManager() {
        Object object = scriptEngineManagerMutex;
        synchronized (object) {
            if (scriptEngineManager == null) {
                ClassLoader classLoader = GenericScript.createClassLoader();
                scriptEngineManager = new ScriptEngineManager(classLoader);
            }
            return scriptEngineManager;
        }
    }

    private static ClassLoader createClassLoader() {
        if (classLoader == null) {
            List<String> classpath = ScriptResources.getClasspath();
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String path : classpath) {
                urls.add(GenericScript.pathToUrl(path));
            }
            classLoader = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]), GenericScript.class.getClassLoader());
        }
        return classLoader;
    }

    private static URL pathToUrl(String path) {
        try {
            return new File(path).toURI().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void compileAndCache(Compilable engine) throws Throwable {
        if (this.compileTimeStrategy.canUseOldCompiledScript()) {
            return;
        }
        this.compiledScript = null;
        if (this.errorsInScript != null) {
            throw this.errorsInScript;
        }
        try {
            this.compiledScript = engine.compile(this.script);
            this.compileTimeStrategy.scriptCompiled();
        }
        catch (Throwable e) {
            this.errorsInScript = e;
            throw e;
        }
    }

    private static ScriptEngine findScriptEngine(String scriptEngineName) {
        ScriptEngineManager manager = GenericScript.getScriptEngineManager();
        return GenericScript.checkNotNull(manager.getEngineByName(scriptEngineName), "name", scriptEngineName);
    }

    private static ScriptEngine findScriptEngine(File scriptFile) {
        ScriptEngineManager manager = GenericScript.getScriptEngineManager();
        String extension = FilenameUtils.getExtension((String)scriptFile.getName());
        return GenericScript.checkNotNull(manager.getEngineByExtension(extension), "extension", extension);
    }

    private static ScriptEngine checkNotNull(ScriptEngine motor, String what, String detail) {
        if (motor == null) {
            throw new RuntimeException("can't load script engine by " + what + ": " + detail);
        }
        return motor;
    }

    private void handleScriptRuntimeException(ScriptException e) {
        this.outStream.print("message: " + e.getMessage());
        int lineNumber = e.getLineNumber();
        this.outStream.print("Line number: " + lineNumber);
        this.errorHandler.gotoLine(lineNumber);
        throw new ExecuteScriptException(e.getMessage() + " at line " + lineNumber, e.getCause() == null ? e : e.getCause());
    }
}

