/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import groovy.lang.Binding;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.MenuUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.link.LinkController;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.NodeArithmeticsCategory;
import org.freeplane.plugin.script.proxy.Convertible;
import org.freeplane.plugin.script.proxy.Proxy;

public abstract class FreeplaneScriptBaseClass
extends Script {
    private final Pattern nodeIdPattern = Pattern.compile("ID_\\d+");
    private final MetaClass nodeMetaClass = InvokerHelper.getMetaClass(Proxy.NodeRO.class);
    private Map<Object, Object> boundVariables;
    private Proxy.NodeRO node;
    private Proxy.ControllerRO controller;

    public FreeplaneScriptBaseClass() {
        DefaultGroovyMethods.mixin(Number.class, NodeArithmeticsCategory.class);
        this.initBinding();
    }

    public void initBinding() {
        this.boundVariables = super.getBinding().getVariables();
        this.node = (Proxy.NodeRO)this.boundVariables.get("node");
        this.controller = (Proxy.ControllerRO)this.boundVariables.get("c");
    }

    public void setBinding(Binding binding) {
        super.setBinding(this.addStaticBindings(binding));
        this.initBinding();
    }

    private Binding addStaticBindings(Binding binding) {
        binding.setProperty("logger", (Object)new LogUtils());
        binding.setProperty("ui", (Object)new UITools());
        binding.setProperty("htmlUtils", (Object)HtmlUtils.getInstance());
        binding.setProperty("textUtils", (Object)new TextUtils());
        binding.setProperty("menuUtils", (Object)new MenuUtils());
        binding.setProperty("config", (Object)new ConfigProperties());
        return binding;
    }

    public Object getProperty(String property) {
        if (property.equals("node")) {
            return this.node;
        }
        if (property.equals("c")) {
            return this.controller;
        }
        if (this.nodeIdPattern.matcher(property).matches()) {
            return this.N(property);
        }
        Object boundValue = this.boundVariables.get(property);
        if (boundValue != null) {
            return boundValue;
        }
        try {
            return this.nodeMetaClass.getProperty((Object)this.node, property);
        }
        catch (MissingPropertyException e) {
            return super.getProperty(property);
        }
    }

    public Object invokeMethod(String methodName, Object args) {
        try {
            return super.invokeMethod(methodName, args);
        }
        catch (MissingMethodException mme) {
            return this.nodeMetaClass.invokeMethod((Object)this.node, methodName, args);
        }
    }

    public Proxy.NodeRO N(String id) {
        Proxy.NodeRO node = (Proxy.NodeRO)this.getBinding().getVariable("node");
        return node.getMap().node(id);
    }

    public String T(String id) {
        Proxy.NodeRO n = this.N(id);
        return n == null ? null : n.getText();
    }

    public Object V(String id) {
        Proxy.NodeRO n = this.N(id);
        try {
            return n == null ? null : n.getValue();
        }
        catch (ExecuteScriptException e) {
            return null;
        }
    }

    public Object ifNull(Object value, Object valueIfNull) {
        return value == null ? valueIfNull : value;
    }

    public Long round(Double d) {
        if (d == null) {
            return null;
        }
        return Math.round(d);
    }

    public Double round(Double d, int precision) {
        if (d == null) {
            return d;
        }
        double factor = 1.0;
        for (int i = 0; i < precision; ++i) {
            factor *= 10.0;
        }
        return (double)Math.round(d * factor) / factor;
    }

    public Object parse(String text) {
        return ScannerController.getController().parse(text);
    }

    public Object format(Object object, String formatString) {
        return FormatController.format((Object)object, (String)formatString);
    }

    public Object format(Object object) {
        return FormatController.formatUsingDefault((Object)object);
    }

    public Object formatDate(Date date) {
        String format = FormatController.getController().getDefaultDateFormat().toPattern();
        return FormatController.format((Object)date, (String)format);
    }

    public String toString(Object o) {
        return Convertible.toString(o);
    }

    public void loadUri(URI uri) {
        LinkController.getController().loadURI(uri);
    }

    public static class ConfigProperties {
        public boolean getBooleanProperty(String name) {
            return ResourceController.getResourceController().getBooleanProperty(name);
        }

        public double getDoubleProperty(String name, double defaultValue) {
            return ResourceController.getResourceController().getDoubleProperty(name, defaultValue);
        }

        public int getIntProperty(String name) {
            return ResourceController.getResourceController().getIntProperty(name);
        }

        public int getIntProperty(String name, int defaultValue) {
            return ResourceController.getResourceController().getIntProperty(name, defaultValue);
        }

        public long getLongProperty(String name, int defaultValue) {
            return ResourceController.getResourceController().getLongProperty(name, defaultValue);
        }

        public String getProperty(String name) {
            return ResourceController.getResourceController().getProperty(name);
        }

        public String getProperty(String name, String defaultValue) {
            return ResourceController.getResourceController().getProperty(name, defaultValue);
        }

        public Properties getProperties() {
            return ResourceController.getResourceController().getProperties();
        }

        public String getAt(String name) {
            return this.getProperty(name);
        }

        public ResourceBundle getResources() {
            return ResourceController.getResourceController().getResources();
        }

        public String getFreeplaneUserDirectory() {
            return ResourceController.getResourceController().getFreeplaneUserDirectory();
        }
    }
}

