/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.script.EvaluationDependencies;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.ScriptingEngine;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.proxy.FormulaCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaUtils {
    private static final boolean ENABLE_CACHING = !Controller.getCurrentController().getResourceController().getBooleanProperty("formula_disable_caching");
    static final boolean DEBUG_FORMULA_EVALUATION = false;
    private static Pattern FIRST_CHARACTER_IN_HTML = Pattern.compile("(?m)>\\s*[^<\\s]");

    public static Object evalIfScript(NodeModel nodeModel, ScriptContext scriptContext, String text) {
        if (FormulaUtils.containsFormula(text)) {
            scriptContext = scriptContext == null ? new ScriptContext() : scriptContext;
            return FormulaUtils.eval(nodeModel, scriptContext, text.substring(1));
        }
        return text;
    }

    public static boolean containsFormula(String text) {
        return text != null && text.length() > 1 && text.charAt(0) == '=';
    }

    public static boolean containsFormulaCheckHTML(String text) {
        if (HtmlUtils.isHtmlNode((String)text)) {
            return FormulaUtils.htmlContainsFormula(text);
        }
        return FormulaUtils.containsFormula(text);
    }

    private static boolean htmlContainsFormula(String text) {
        Matcher matcher = FIRST_CHARACTER_IN_HTML.matcher(text);
        return matcher.find() && text.charAt(matcher.end() - 1) == '=';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object eval(NodeModel nodeModel, ScriptContext scriptContext, String text) {
        if (!scriptContext.push(nodeModel, text)) {
            throw new StackOverflowError(TextUtils.format((String)"formula.error.circularReference", (Object[])new Object[]{HtmlUtils.htmlToPlain((String)scriptContext.getStackFront().getText())}));
        }
        ScriptingPermissions restrictedPermissions = ScriptingPermissions.getFormulaPermissions();
        try {
            if (ENABLE_CACHING) {
                FormulaCache formulaCache = FormulaUtils.getFormulaCache(nodeModel.getMap());
                Object value = formulaCache.get(nodeModel, text);
                if (value == null) {
                    try {
                        value = ScriptingEngine.executeScript(nodeModel, text, scriptContext, restrictedPermissions);
                        formulaCache.put(nodeModel, text, value);
                    }
                    catch (ExecuteScriptException e) {
                        formulaCache.put(nodeModel, text, e);
                        throw e;
                    }
                } else {
                    scriptContext.accessNode(nodeModel);
                }
                Object object = value;
                return object;
            }
            Object object = ScriptingEngine.executeScript(nodeModel, text, scriptContext, restrictedPermissions);
            return object;
        }
        finally {
            scriptContext.pop();
        }
    }

    public static List<NodeModel> manageChangeAndReturnDependencies(boolean includeChanged, NodeModel ... nodes) {
        ArrayList<NodeModel> dependencies = new ArrayList<NodeModel>();
        for (int i = 0; i < nodes.length; ++i) {
            LinkedHashSet<NodeModel> nodeDependencies = new LinkedHashSet<NodeModel>(0);
            FormulaUtils.getEvaluationDependencies(nodes[i].getMap()).getDependencies(nodeDependencies, nodes[i]);
            if (nodeDependencies != null) {
                dependencies.addAll(nodeDependencies);
            }
            if (!includeChanged) continue;
            dependencies.add(nodes[i]);
        }
        if (ENABLE_CACHING) {
            for (NodeModel nodeModel : dependencies) {
                FormulaUtils.getFormulaCache(nodeModel.getMap()).markAsDirtyIfFormulaNode(nodeModel);
            }
        }
        return dependencies;
    }

    private static FormulaCache getFormulaCache(MapModel map) {
        FormulaCache formulaCache = (FormulaCache)map.getExtension(FormulaCache.class);
        if (formulaCache == null) {
            formulaCache = new FormulaCache();
            map.addExtension((IExtension)formulaCache);
        }
        return formulaCache;
    }

    private static EvaluationDependencies getEvaluationDependencies(MapModel map) {
        EvaluationDependencies dependencies = (EvaluationDependencies)map.getExtension(EvaluationDependencies.class);
        if (dependencies == null) {
            dependencies = new EvaluationDependencies();
            map.addExtension((IExtension)dependencies);
        }
        return dependencies;
    }

    public static void accessNode(NodeModel accessingNode, NodeModel accessedNode) {
        FormulaUtils.getEvaluationDependencies(accessingNode.getMap()).accessNode(accessingNode, accessedNode);
    }

    public static void accessBranch(NodeModel accessingNode, NodeModel accessedNode) {
        FormulaUtils.getEvaluationDependencies(accessingNode.getMap()).accessBranch(accessingNode, accessingNode);
    }

    public static void accessAll(NodeModel accessingNode) {
        FormulaUtils.getEvaluationDependencies(accessingNode.getMap()).accessAll(accessingNode);
    }

    public static void clearCache(MapModel map) {
        map.removeExtension(FormulaCache.class);
        map.removeExtension(EvaluationDependencies.class);
    }
}

