/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptingEngine;
import org.freeplane.plugin.script.ScriptingPermissions;

public class ExecuteScriptAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final File scriptFile;
    private final ExecutionMode mode;
    private final IScript script;

    public ExecuteScriptAction(String scriptName, String menuItemName, String scriptFile, ExecutionMode mode, boolean cacheContent, ScriptingPermissions permissions) {
        super(ExecuteScriptAction.makeMenuItemKey(scriptName, mode), menuItemName, null);
        this.scriptFile = new File(scriptFile);
        this.mode = mode;
        this.script = ScriptingEngine.createScriptForFile(this.scriptFile, permissions);
    }

    public static String makeMenuItemKey(String scriptName, ExecutionMode mode) {
        return scriptName + "_" + mode.toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        Controller.getCurrentController().getViewController().setWaitingCursor(true);
        try {
            ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
            if (this.mode == ExecutionMode.ON_SINGLE_NODE) {
                nodes.add(Controller.getCurrentController().getSelection().getSelected());
            } else {
                nodes.addAll(Controller.getCurrentController().getSelection().getSelection());
            }
            MModeController modeController = (MModeController)Controller.getCurrentModeController();
            modeController.startTransaction();
            for (NodeModel node : nodes) {
                try {
                    if (this.mode == ExecutionMode.ON_SELECTED_NODE_RECURSIVELY) {
                        this.executeScriptRecursive(node);
                        continue;
                    }
                    this.script.execute(node);
                }
                catch (ExecuteScriptException ex) {
                    String cause = ex.getCause() != null ? ex.getCause().toString() : ex.toString();
                    LogUtils.warn((String)("error executing script " + this.scriptFile + " - giving up\n" + cause));
                    modeController.delayedRollback();
                    ScriptingEngine.showScriptExceptionErrorMessage(ex);
                    Controller.getCurrentController().getViewController().setWaitingCursor(false);
                    return;
                }
            }
            modeController.delayedCommit();
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    private void executeScriptRecursive(NodeModel node) {
        NodeModel[] children;
        ModeController modeController = Controller.getCurrentModeController();
        for (NodeModel child : children = modeController.getMapController().childrenUnfolded(node).toArray(new NodeModel[0])) {
            this.executeScriptRecursive(child);
        }
        this.script.execute(node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExecutionMode {
        ON_SINGLE_NODE,
        ON_SELECTED_NODE,
        ON_SELECTED_NODE_RECURSIVELY;

    }
}

