/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.util.Date;

public class CompileTimeStrategy {
    private static final long FILE_CHECK_PERIOD = 100L;
    private static final long NEVER = 0L;
    private final File scriptFile;
    private long compileTime;
    private long fileModificationTime;
    private long lastFileStampCheckTime;

    public CompileTimeStrategy(File scriptFile) {
        this.scriptFile = scriptFile;
        this.compileTime = 0L;
        this.fileModificationTime = 0L;
        this.lastFileStampCheckTime = 0L;
    }

    public void scriptCompiled() {
        this.compileTime = this.now();
    }

    private long now() {
        return new Date().getTime();
    }

    public boolean canUseOldCompiledScript() {
        if (this.compileTime == 0L) {
            return false;
        }
        if (this.scriptFile == null) {
            return true;
        }
        long now = this.now();
        if (now - this.lastFileStampCheckTime < 100L) {
            return true;
        }
        this.lastFileStampCheckTime = now;
        if (!this.scriptFile.canRead()) {
            return false;
        }
        this.fileModificationTime = this.scriptFile.lastModified();
        boolean canUseOldCompiledScript = this.compileTime >= this.fileModificationTime;
        return canUseOldCompiledScript;
    }
}

