/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.Component;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelListener;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.core.ui.IMouseWheelEventHandler;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.ui.DefaultMapMouseListener;
import org.freeplane.view.swing.ui.DefaultMouseWheelListener;
import org.freeplane.view.swing.ui.DefaultNodeKeyListener;
import org.freeplane.view.swing.ui.DefaultNodeMouseMotionListener;
import org.freeplane.view.swing.ui.MapsMenuActionListener;
import org.freeplane.view.swing.ui.MenuXmlCreator;
import org.freeplane.view.swing.ui.ModesMenuActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInputListenerFactory
implements IUserInputListenerFactory {
    public static final String NODE_POPUP = "/node_popup";
    private static final String MENU_MM2XML = "/xslt/mm2menu.xsl";
    private IMouseListener mapMouseListener;
    private MouseWheelListener mapMouseWheelListener;
    private final ActionListener mapsMenuActionListener;
    private JPopupMenu mapsPopupMenu;
    private FreeplaneMenuBar menuBar;
    private final MenuBuilder menuBuilder;
    private final HashSet<IMouseWheelEventHandler> mRegisteredMouseWheelEventHandler = new HashSet();
    private DragGestureListener nodeDragListener;
    private DropTargetListener nodeDropTargetListener;
    private KeyListener nodeKeyListener;
    private IMouseListener nodeMotionListener;
    private IMouseListener nodeMouseMotionListener;
    private JPopupMenu nodePopupMenu;
    private final Map<String, JComponent> toolBars;
    private final List<JComponent>[] toolbarLists;
    private final MenuXmlCreator menuXmlCreator = new MenuXmlCreator("/xslt/mm2menu.xsl");

    public UserInputListenerFactory(final ModeController modeController) {
        Controller controller = Controller.getCurrentController();
        this.mapsMenuActionListener = new MapsMenuActionListener(controller);
        this.menuBuilder = new MenuBuilder(modeController);
        controller.getMapViewManager().addMapSelectionListener(new IMapSelectionListener(){

            public void afterMapChange(MapModel oldMap, MapModel newMap) {
                if (modeController.equals(Controller.getCurrentModeController())) {
                    UserInputListenerFactory.this.menuBuilder.afterMapChange(newMap);
                }
            }

            public void beforeMapChange(MapModel oldMap, MapModel newMap) {
            }
        });
        this.toolBars = new LinkedHashMap<String, JComponent>();
        this.toolbarLists = this.newListArray();
        for (int j = 0; j < 4; ++j) {
            this.toolbarLists[j] = new LinkedList<JComponent>();
        }
    }

    private List<JComponent>[] newListArray() {
        return new List[4];
    }

    @Override
    public void addToolBar(String name, int position, JComponent toolBar) {
        this.toolBars.put(name, toolBar);
        this.toolbarLists[position].add(toolBar);
    }

    @Override
    public void addMouseWheelEventHandler(IMouseWheelEventHandler handler) {
        this.mRegisteredMouseWheelEventHandler.add(handler);
    }

    @Override
    public IMouseListener getMapMouseListener() {
        if (this.mapMouseListener == null) {
            this.mapMouseListener = new DefaultMapMouseListener();
        }
        return this.mapMouseListener;
    }

    @Override
    public MouseWheelListener getMapMouseWheelListener() {
        if (this.mapMouseWheelListener == null) {
            this.mapMouseWheelListener = new DefaultMouseWheelListener();
        }
        return this.mapMouseWheelListener;
    }

    @Override
    public JPopupMenu getMapPopup() {
        return this.mapsPopupMenu;
    }

    @Override
    public FreeplaneMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new FreeplaneMenuBar();
        }
        return this.menuBar;
    }

    @Override
    public MenuBuilder getMenuBuilder() {
        return this.menuBuilder;
    }

    @Override
    public Set<IMouseWheelEventHandler> getMouseWheelEventHandlers() {
        return Collections.unmodifiableSet(this.mRegisteredMouseWheelEventHandler);
    }

    @Override
    public DragGestureListener getNodeDragListener() {
        return this.nodeDragListener;
    }

    @Override
    public DropTargetListener getNodeDropTargetListener() {
        return this.nodeDropTargetListener;
    }

    @Override
    public KeyListener getNodeKeyListener() {
        if (this.nodeKeyListener == null) {
            this.nodeKeyListener = new DefaultNodeKeyListener(null);
        }
        return this.nodeKeyListener;
    }

    public IMouseListener getNodeMotionListener() {
        return this.nodeMotionListener;
    }

    @Override
    public IMouseListener getNodeMouseMotionListener() {
        if (this.nodeMouseMotionListener == null) {
            this.nodeMouseMotionListener = new DefaultNodeMouseMotionListener();
        }
        return this.nodeMouseMotionListener;
    }

    @Override
    public JPopupMenu getNodePopupMenu() {
        return this.nodePopupMenu;
    }

    @Override
    public JComponent getToolBar(String name) {
        return this.toolBars.get(name);
    }

    @Override
    public Iterable<JComponent> getToolBars(int position) {
        return this.toolbarLists[position];
    }

    @Override
    public void removeMouseWheelEventHandler(IMouseWheelEventHandler handler) {
        this.mRegisteredMouseWheelEventHandler.remove(handler);
    }

    public void setMapMouseListener(IMouseListener mapMouseMotionListener) {
        if (this.mapMouseListener != null) {
            throw new RuntimeException("already set");
        }
        this.mapMouseListener = mapMouseMotionListener;
    }

    public void setMapMouseWheelListener(MouseWheelListener mouseWheelListener) {
        if (this.mapMouseWheelListener != null) {
            throw new RuntimeException("already set");
        }
        this.mapMouseWheelListener = mouseWheelListener;
    }

    public void setMenuBar(FreeplaneMenuBar menuBar) {
        if (this.mapMouseWheelListener != null) {
            throw new RuntimeException("already set");
        }
        this.menuBar = menuBar;
    }

    public void setNodeDragListener(DragGestureListener nodeDragListener) {
        if (this.nodeDragListener != null) {
            throw new RuntimeException("already set");
        }
        this.nodeDragListener = nodeDragListener;
    }

    public void setNodeDropTargetListener(DropTargetListener nodeDropTargetListener) {
        if (this.nodeDropTargetListener != null) {
            throw new RuntimeException("already set");
        }
        this.nodeDropTargetListener = nodeDropTargetListener;
    }

    public void setNodeKeyListener(KeyListener nodeKeyListener) {
        if (this.nodeKeyListener != null) {
            throw new RuntimeException("already set");
        }
        this.nodeKeyListener = nodeKeyListener;
    }

    public void setNodeMotionListener(IMouseListener nodeMotionListener) {
        if (this.nodeMotionListener != null) {
            throw new RuntimeException("already set");
        }
        this.nodeMotionListener = nodeMotionListener;
    }

    public void setNodeMouseMotionListener(IMouseListener nodeMouseMotionListener) {
        if (this.nodeMouseMotionListener != null) {
            throw new RuntimeException("already set");
        }
        this.nodeMouseMotionListener = nodeMouseMotionListener;
    }

    public void setNodePopupMenu(JPopupMenu nodePopupMenu) {
        if (this.nodePopupMenu != null) {
            throw new RuntimeException("already set");
        }
        this.nodePopupMenu = nodePopupMenu;
    }

    @Override
    public void updateMapList() {
        this.updateModeMenu();
        this.updateMapList("main_menu_mindmaps");
        this.updateMapList("popup_menu_mindmaps");
    }

    private void updateMapList(String mapsMenuPosition) {
        if (!this.menuBuilder.contains(mapsMenuPosition)) {
            return;
        }
        this.menuBuilder.removeChildElements(mapsMenuPosition);
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        List<? extends Component> mapViewVector = mapViewManager.getMapViewVector();
        if (mapViewVector == null) {
            return;
        }
        ButtonGroup group = new ButtonGroup();
        int i = 0;
        for (Component component : mapViewVector) {
            MapView currentMapView;
            String displayName = component.getName();
            JRadioButtonMenuItem newItem = new JRadioButtonMenuItem(displayName);
            newItem.setSelected(false);
            group.add(newItem);
            newItem.addActionListener(this.mapsMenuActionListener);
            if (displayName.length() > 0) {
                newItem.setMnemonic(displayName.charAt(0));
            }
            if ((currentMapView = (MapView)mapViewManager.getMapViewComponent()) != null && component == currentMapView) {
                newItem.setSelected(true);
            }
            this.menuBuilder.addMenuItem(mapsMenuPosition, newItem, mapsMenuPosition + '-' + i++, 0);
        }
    }

    @Override
    public void updateMenus(String menuStructureResource, Set<String> plugins) {
        FreeplaneMenuBar menuBar = this.getMenuBar();
        this.menuBuilder.addMenuBar(menuBar, "/menu_bar");
        this.mapsPopupMenu = new JPopupMenu();
        this.menuBuilder.addPopupMenu(this.mapsPopupMenu, "/map_popup");
        this.menuBuilder.addPopupMenu(this.getNodePopupMenu(), NODE_POPUP);
        this.menuBuilder.addToolbar((JToolBar)this.getToolBar("/main_toolbar"), "/main_toolbar");
        this.mapsPopupMenu.setName(TextUtils.getText("mindmaps"));
        URL menuStructure = this.menuXmlCreator.menuResource(menuStructureResource);
        if (menuStructure != null) {
            boolean isUserDefined = menuStructure.getProtocol().equalsIgnoreCase("file");
            try {
                this.menuBuilder.processMenuCategory(menuStructure, plugins);
            }
            catch (RuntimeException e) {
                if (isUserDefined) {
                    LogUtils.warn(e);
                    String myMessage = TextUtils.format("menu_error", menuStructure.getPath(), e.getMessage());
                    UITools.backOtherWindows();
                    JOptionPane.showMessageDialog(UITools.getFrame(), myMessage, "Freeplane", 0);
                    System.exit(-1);
                }
                throw e;
            }
        }
        IMapViewManager viewController = Controller.getCurrentController().getMapViewManager();
        viewController.updateMenus(this.menuBuilder);
    }

    private void updateModeMenu() {
        this.menuBuilder.removeChildElements("main_menu_modes");
        Controller controller = Controller.getCurrentController();
        for (String key : new LinkedList<String>(controller.getModes())) {
            ModesMenuActionListener modesMenuActionListener = new ModesMenuActionListener(key, controller);
            ModeController modeController = controller.getModeController();
            boolean isSelected = modeController != null ? modeController.getModeName().equals(key) : false;
            this.menuBuilder.addRadioItem("main_menu_modes", modesMenuActionListener, isSelected);
            ResourceController.getResourceController().getProperty("keystroke_mode_" + key);
        }
    }
}

