/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.SysUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.MovedMouseEventFilter;

public class NodeSelector {
    private static final String SELECTION_METHOD_DIRECT = "selection_method_direct";
    private static final String SELECTION_METHOD_BY_CLICK = "selection_method_by_click";
    private static final String TIME_FOR_DELAYED_SELECTION = "time_for_delayed_selection";
    private static final String SELECTION_METHOD = "selection_method";
    private final MovedMouseEventFilter windowMouseTracker = new MovedMouseEventFilter();
    private Rectangle controlRegionForDelayedSelection;
    private Timer timerForDelayedSelection;

    public void createTimer(MouseEvent e) {
        if (this.controlRegionForDelayedSelection != null && this.controlRegionForDelayedSelection.contains(e.getPoint())) {
            return;
        }
        if (!this.isInside(e)) {
            return;
        }
        this.stopTimerForDelayedSelection();
        Window focusedWindow = FocusManager.getCurrentManager().getFocusedWindow();
        if (focusedWindow == null) {
            return;
        }
        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() instanceof JTextComponent) {
            return;
        }
        this.controlRegionForDelayedSelection = this.getControlRegion(e.getPoint());
        String selectionMethod = ResourceController.getResourceController().getProperty(SELECTION_METHOD);
        if (selectionMethod.equals(SELECTION_METHOD_BY_CLICK)) {
            return;
        }
        if (selectionMethod.equals(SELECTION_METHOD_DIRECT)) {
            new TimeDelayedSelection(e).run();
            return;
        }
        int timeForDelayedSelection = ResourceController.getResourceController().getIntProperty(TIME_FOR_DELAYED_SELECTION, 0);
        this.timerForDelayedSelection = SysUtils.createTimer(this.getClass().getSimpleName());
        this.timerForDelayedSelection.schedule((TimerTask)new TimeDelayedSelection(e), timeForDelayedSelection);
    }

    protected boolean isInside(MouseEvent e) {
        return new Rectangle(0, 0, e.getComponent().getWidth(), e.getComponent().getHeight()).contains(e.getPoint());
    }

    public void stopTimerForDelayedSelection() {
        if (this.timerForDelayedSelection != null) {
            this.timerForDelayedSelection.cancel();
        }
        this.timerForDelayedSelection = null;
        this.controlRegionForDelayedSelection = null;
    }

    protected Rectangle getControlRegion(Point2D p) {
        int side = 8;
        return new Rectangle((int)(p.getX() - 4.0), (int)(p.getY() - 4.0), 8, 8);
    }

    public boolean shouldSelectOnClick(MouseEvent e) {
        if (this.isInside(e)) {
            NodeView nodeView = this.getRelatedNodeView(e);
            return !nodeView.isSelected() || Controller.getCurrentController().getSelection().size() != 1;
        }
        return false;
    }

    public void extendSelection(MouseEvent e) {
        Controller controller = Controller.getCurrentController();
        NodeView nodeView = this.getRelatedNodeView(e);
        NodeModel newlySelectedNode = nodeView.getModel();
        boolean extend = Compat.isMacOsX() ? e.isMetaDown() : e.isControlDown();
        boolean range = e.isShiftDown();
        IMapSelection selection = controller.getSelection();
        if (range && !extend) {
            selection.selectContinuous(newlySelectedNode);
        } else if (extend && !range) {
            selection.toggleSelected(newlySelectedNode);
        }
        if (extend == range) {
            if (selection.isSelected(newlySelectedNode) && selection.size() == 1 && FocusManager.getCurrentManager().getFocusOwner() instanceof MainView) {
                return;
            }
            selection.selectAsTheOnlyOneSelected(newlySelectedNode);
            e.consume();
        }
    }

    public void selectSingleNode(MouseEvent e) {
        NodeView nodeV = this.getRelatedNodeView(e);
        Controller controller = Controller.getCurrentController();
        if (!((MapView)controller.getMapViewManager().getMapViewComponent()).isSelected(nodeV)) {
            controller.getSelection().selectAsTheOnlyOneSelected(nodeV.getModel());
        }
    }

    public NodeView getRelatedNodeView(MouseEvent e) {
        return (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, e.getComponent());
    }

    public boolean isRelevant(MouseEvent e) {
        return this.windowMouseTracker.isRelevant(e);
    }

    public void trackWindowForComponent(Component c) {
        this.windowMouseTracker.trackWindowForComponent(c);
    }

    protected class TimeDelayedSelection
    extends TimerTask {
        private final MouseEvent e;

        TimeDelayedSelection(MouseEvent e) {
            this.e = e;
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (TimeDelayedSelection.this.e.getModifiers() != 0) {
                        return;
                    }
                    try {
                        NodeView nodeV;
                        Controller controller = Controller.getCurrentController();
                        if (!controller.getModeController().isBlocked() && controller.getSelection().size() <= 1 && (nodeV = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, TimeDelayedSelection.this.e.getComponent())).isDisplayable() && nodeV.getModel().isVisible()) {
                            nodeV.getMap().select();
                            controller.getSelection().selectAsTheOnlyOneSelected(nodeV.getModel());
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

