/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.XsltPipeReaderFactory;

public class MenuXmlCreator {
    private static final String MM = "mm";
    private static final String XML = "xml";
    private final String xslt;

    public MenuXmlCreator(String xslt) {
        this.xslt = xslt;
    }

    public URL menuResource(String menuStructureXmlPath) {
        try {
            this.updateXml(menuStructureXmlPath);
        }
        catch (IOException e) {
            LogUtils.warn(e);
        }
        URL xmlResource = ResourceController.getResourceController().getResource(menuStructureXmlPath);
        return xmlResource;
    }

    private void updateXml(String menuStructureXmlPath) throws IOException {
        ResourceController resourceController = ResourceController.getResourceController();
        URL xmlResource = resourceController.getResource(menuStructureXmlPath);
        String menuStructureMapPath = menuStructureXmlPath.subSequence(0, menuStructureXmlPath.length() - XML.length()) + MM;
        URL mmResource = resourceController.getResource(menuStructureMapPath);
        if (this.isFile(mmResource)) {
            File mmFile = this.toFile(mmResource);
            if (!this.isFile(xmlResource) || this.toFile(xmlResource).lastModified() <= mmFile.lastModified()) {
                this.transformMindMapToXml(mmFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformMindMapToXml(File mmFile) throws IOException {
        Writer out = null;
        try {
            String xml = new XsltPipeReaderFactory().transform(mmFile, this.xslt);
            String mmPath = mmFile.getPath();
            String xmlPath = mmPath.substring(0, mmPath.length() - MM.length()) + XML;
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlPath), "UTF-8"));
            out.write(xml);
        }
        catch (Exception ex) {
            LogUtils.warn(ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private File toFile(URL url) {
        return new File(url.getFile());
    }

    private boolean isFile(URL url) {
        return url != null && "file".equals(url.getProtocol());
    }
}

