/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.net.URI;
import org.freeplane.core.ui.AMouseListener;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.url.UrlManager;
import org.freeplane.view.swing.map.ZoomableLabel;

public class LinkNavigatorMouseListener
extends AMouseListener {
    public void mouseMoved(MouseEvent e) {
        int requiredCursor;
        ZoomableLabel node = (ZoomableLabel)e.getComponent();
        String link = node.getLink(e.getPoint());
        boolean followLink = link != null;
        Controller currentController = Controller.getCurrentController();
        if (followLink) {
            currentController.getViewController().out(link);
            requiredCursor = 12;
        } else {
            requiredCursor = 0;
        }
        if (node.getCursor().getType() != requiredCursor) {
            node.setCursor(requiredCursor != 0 ? new Cursor(requiredCursor) : null);
        }
    }

    public void mouseClicked(MouseEvent e) {
        String link;
        ZoomableLabel component = (ZoomableLabel)e.getComponent();
        if (e.getClickCount() == 1 && e.getButton() == 1 && Compat.isPlainEvent(e) && (link = component.getLink(e.getPoint())) != null) {
            if (link != null) {
                try {
                    UrlManager.getController().loadURL(new URI(link));
                }
                catch (Exception ex) {
                    LogUtils.warn(ex);
                }
            }
            return;
        }
    }
}

