/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.freeplane.core.util.Compat;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.DetailTextModel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.ui.LinkNavigatorMouseListener;
import org.freeplane.view.swing.ui.NodePopupMenuDisplayer;
import org.freeplane.view.swing.ui.NodeSelector;

public class DetailsViewMouseListener
extends LinkNavigatorMouseListener {
    protected final NodeSelector nodeSelector = new NodeSelector();

    public void mouseClicked(MouseEvent e) {
        JPopupMenu popupmenu;
        ModeController mc = Controller.getCurrentController().getModeController();
        if (Compat.isMacOsX() && (popupmenu = mc.getUserInputListenerFactory().getNodePopupMenu()).isShowing()) {
            return;
        }
        NodeView nodeView = this.nodeSelector.getRelatedNodeView(e);
        if (nodeView == null) {
            return;
        }
        NodeModel model = nodeView.getModel();
        TextController controller = TextController.getController();
        if (this.eventFromHideDisplayArea(e)) {
            controller.setDetailsHidden(model, !DetailTextModel.getDetailText(model).isHidden());
        } else {
            this.nodeSelector.extendSelection(e);
            if (this.canEdit(controller) && this.isEditingStartEvent(e)) {
                ((MTextController)controller).editDetails(model, (InputEvent)e, e.isAltDown());
            } else {
                super.mouseClicked(e);
            }
        }
    }

    protected boolean eventFromHideDisplayArea(MouseEvent e) {
        ZoomableLabel component = (ZoomableLabel)e.getComponent();
        return e.getX() < component.getIconWidth();
    }

    private boolean canEdit(TextController controller) {
        try {
            return controller instanceof MTextController;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean isEditingStartEvent(MouseEvent e) {
        return e.getClickCount() == 2;
    }

    public void mousePressed(MouseEvent e) {
        new NodePopupMenuDisplayer().showNodePopupMenu(e);
    }

    public void mouseReleased(MouseEvent e) {
        new NodePopupMenuDisplayer().showNodePopupMenu(e);
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        if (!this.eventFromHideDisplayArea(e) && this.nodeSelector.isRelevant(e)) {
            this.nodeSelector.createTimer(e);
        } else {
            this.nodeSelector.stopTimerForDelayedSelection();
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.nodeSelector.stopTimerForDelayedSelection();
        this.nodeSelector.selectSingleNode(e);
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.eventFromHideDisplayArea(e) && this.nodeSelector.isRelevant(e)) {
            this.mouseMoved(e);
        } else {
            this.nodeSelector.stopTimerForDelayedSelection();
        }
    }

    public void mouseExited(MouseEvent e) {
        this.nodeSelector.stopTimerForDelayedSelection();
        this.nodeSelector.trackWindowForComponent(e.getComponent());
    }
}

