/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.link;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.EdgeView;
import org.freeplane.view.swing.map.link.CollisionDetector;

public class OutlineLinkView
extends EdgeView {
    private int[] xs;
    private int[] ys;

    public OutlineLinkView(NodeView source, NodeView target, Component paintedComponent) {
        super(source, target, paintedComponent);
    }

    public boolean detectCollision(Point p) {
        CollisionDetector collisionDetector = new CollisionDetector();
        for (int i = 1; i < this.xs.length; ++i) {
            if (!collisionDetector.detectCollision(p, new Line2D.Float(this.xs[i - 1], this.ys[i - 1], this.xs[i], this.ys[i]))) continue;
            return true;
        }
        return false;
    }

    protected void createStart() {
        MainView startMainView = this.getSource().getMainView();
        this.start = new Point(startMainView.getWidth(), startMainView.getHeight() / 2);
        MainView targetMainView = this.getTarget().getMainView();
        this.end = new Point(targetMainView.getWidth(), targetMainView.getHeight() / 2);
    }

    protected void draw(Graphics2D g) {
        Color color = this.getColor();
        g.setColor(color);
        Stroke stroke = this.getStroke();
        g.setStroke(stroke);
        int xMiddle = Math.max(this.start.x, this.end.x) + this.getSource().getMap().getZoomed(10);
        this.xs = new int[]{this.start.x, xMiddle, xMiddle, this.end.x};
        this.ys = new int[]{this.start.y, this.start.y, this.end.y, this.end.y};
        g.drawPolyline(this.xs, this.ys, 4);
    }

    protected Stroke getStroke() {
        return new BasicStroke(this.getWidth());
    }
}

