/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.EdgeView;
import org.freeplane.view.swing.map.link.CollisionDetector;

public class SummaryEdgeView
extends EdgeView {
    private static final int CHILD_XCTRL = 20;
    private static final int XCTRL = 6;

    public SummaryEdgeView(NodeView source, NodeView target, Component paintedComponent) {
        super(source, target, paintedComponent);
    }

    protected void draw(Graphics2D g) {
        Shape graph = this.update();
        Color color = this.getColor();
        g.setColor(color);
        Stroke stroke = this.getStroke();
        g.setStroke(stroke);
        g.draw(graph);
    }

    private Shape update() {
        boolean isLeft = this.getTarget().isLeft();
        int sign = isLeft ? -1 : 1;
        int xctrl = this.getMap().getZoomed(sign * 6);
        int childXctrl = this.getMap().getZoomed(sign * 20);
        GeneralPath path = new GeneralPath(0, 5);
        int startX = isLeft ? Math.min(this.start.x, this.end.x - childXctrl) : Math.max(this.start.x, this.end.x - childXctrl);
        path.moveTo(startX + xctrl, this.start.y);
        path.lineTo(startX + 2 * xctrl, this.start.y);
        path.curveTo(startX + 3 * xctrl, this.start.y, startX, this.end.y, this.end.x, this.end.y);
        return path;
    }

    public boolean detectCollision(Point p) {
        Shape graph = this.update();
        return new CollisionDetector().detectCollision(p, graph);
    }
}

