/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.Component;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.EdgeView;

public abstract class SharpEdgeView
extends EdgeView {
    private int deltaY;
    private int deltaX;

    protected int getDeltaY() {
        return this.deltaY;
    }

    protected int getDeltaX() {
        return this.deltaX;
    }

    public SharpEdgeView(NodeView source, NodeView target, Component paintedComponent) {
        super(source, target, paintedComponent);
    }

    protected void createStart() {
        super.createStart();
        int delta = this.getMap().getZoomed(this.getWidth() + 1);
        if (this.getSource().isRoot()) {
            double x0;
            double x02;
            MainView mainView = this.getSource().getMainView();
            double w = mainView.getWidth() / 2;
            double w2 = w * w;
            if (Double.compare(w2, x02 = (x0 = (double)this.start.x - w) * x0) == 0) {
                this.deltaX = 0;
                this.deltaY = delta;
            } else {
                int h = mainView.getHeight() / 2;
                int y0 = this.start.y - h;
                double k = (double)h / w * x0 / Math.sqrt(w2 - x02);
                double dx = (double)delta / Math.sqrt(1.0 + k * k);
                this.deltaX = (int)dx;
                this.deltaY = (int)(k * dx);
                if (y0 > 0) {
                    this.deltaY = -this.deltaY;
                }
            }
        } else {
            this.deltaX = 0;
            this.deltaY = delta;
        }
    }
}

