/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.EdgeView;
import org.freeplane.view.swing.map.link.CollisionDetector;

public class HorizontalEdgeView
extends EdgeView {
    private int[] xs;
    private int[] ys;

    public HorizontalEdgeView(NodeView source, NodeView target, Component paintedComponent) {
        super(source, target, paintedComponent);
    }

    protected void createStart() {
        if (this.getSource().isRoot() && !MainView.USE_COMMON_OUT_POINT_FOR_ROOT_NODE) {
            super.createStart();
        } else {
            this.start = this.getTarget().isLeft() ? this.getSource().getMainView().getLeftPoint() : this.getSource().getMainView().getRightPoint();
        }
        this.end = this.getTarget().isLeft() ? this.getTarget().getMainView().getRightPoint() : this.getTarget().getMainView().getLeftPoint();
    }

    protected void draw(Graphics2D g) {
        boolean left;
        Color color = this.getColor();
        g.setColor(color);
        Stroke stroke = this.getStroke();
        g.setStroke(stroke);
        this.getWidth();
        int xMiddle = this.getTarget().getMap().getZoomed(20) / 2;
        boolean bl = left = this.getTarget().isLeft() || !MainView.USE_COMMON_OUT_POINT_FOR_ROOT_NODE && this.getSource().isRoot() && this.start.x > this.end.x;
        if (left) {
            xMiddle = -xMiddle;
        }
        this.xs = new int[]{this.start.x, xMiddle += this.start.x, xMiddle, this.end.x};
        this.ys = new int[]{this.start.y, this.start.y, this.end.y, this.end.y};
        g.drawPolyline(this.xs, this.ys, 4);
        if (this.isTargetEclipsed()) {
            g.setColor(g.getBackground());
            g.setStroke(EdgeView.getEclipsedStroke());
            g.drawPolyline(this.xs, this.ys, 4);
            g.setColor(color);
            g.setStroke(stroke);
        }
    }

    public boolean detectCollision(Point p) {
        CollisionDetector collisionDetector = new CollisionDetector();
        for (int i = 1; i < this.xs.length; ++i) {
            if (!collisionDetector.detectCollision(p, new Line2D.Float(this.xs[i - 1], this.ys[i - 1], this.xs[i], this.ys[i]))) continue;
            return true;
        }
        return false;
    }
}

