/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.mindmapmode.MAttributeController;
import org.freeplane.view.swing.map.attribute.AttributeTableModelDecoratorAdapter;
import org.freeplane.view.swing.map.attribute.AttributeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReducedAttributeTableModelDecorator
extends AttributeTableModelDecoratorAdapter {
    private static final long serialVersionUID = 1L;
    private Vector<Integer> index = null;
    private int visibleRowCount;

    ReducedAttributeTableModelDecorator(AttributeView attrView) {
        super(attrView);
        this.rebuildTableModel();
    }

    public void addRow(Attribute newAttribute) {
        throw new Error();
    }

    @Override
    public boolean areAttributesVisible() {
        return this.getRowCount() != 0;
    }

    private int calcRow(int row) {
        return this.index.get(row);
    }

    private Vector<Integer> getIndex() {
        if (this.index == null && this.getAttributeRegistry().getVisibleElementsNumber() > 0) {
            this.index = new Vector(this.getNodeAttributeModel().getRowCount(), 10);
        }
        return this.index;
    }

    @Override
    public int getRowCount() {
        return this.visibleRowCount;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.index == null) {
            return null;
        }
        return this.getNodeAttributeModel().getValueAt(this.calcRow(row), col);
    }

    public void insertRow(int index, Attribute newAttribute) {
        throw new Error();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.getAttributeController() instanceof MAttributeController) {
            return col == 1;
        }
        return false;
    }

    private void rebuildTableModel() {
        this.getIndex();
        if (this.index != null) {
            this.visibleRowCount = 0;
            this.index.clear();
            for (int i = 0; i < this.getNodeAttributeModel().getRowCount(); ++i) {
                String name = (String)this.getNodeAttributeModel().getValueAt(i, 0);
                if (!this.getAttributeRegistry().getElement((Comparable<?>)((Object)name)).isVisible()) continue;
                this.index.add(new Integer(i));
                ++this.visibleRowCount;
            }
        }
    }

    public Object removeRow(int index) {
        throw new Error();
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
        this.getAttributeController().performSetValueAt(this.getNodeAttributeModel(), o, this.calcRow(row), col);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.rebuildTableModel();
        if (this.index != null) {
            this.fireTableDataChanged();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e.getType() != 0 || e.getColumn() != 0) {
            this.rebuildTableModel();
        }
        this.fireTableDataChanged();
    }
}

