/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URI;
import javax.swing.Icon;
import org.freeplane.view.swing.map.attribute.AttributeTable;

class CursorUpdater
extends MouseAdapter
implements MouseMotionListener {
    CursorUpdater() {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.updateCursor(e);
    }

    public void mouseEntered(MouseEvent e) {
        this.updateCursor(e);
    }

    public void mouseExited(MouseEvent e) {
        this.updateCursor(e.getComponent(), 0);
    }

    private void updateCursor(MouseEvent e) {
        int cursor = this.getCursor(e);
        this.updateCursor(e.getComponent(), cursor);
    }

    private int getCursor(MouseEvent e) {
        Point point;
        AttributeTable table = (AttributeTable)e.getComponent();
        int col = table.columnAtPoint(point = e.getPoint());
        if (col != 1) {
            return 0;
        }
        int row = table.rowAtPoint(e.getPoint());
        if (row == -1 || row >= table.getRowCount()) {
            return 0;
        }
        Object value = table.getValueAt(row, col);
        if (!(value instanceof URI)) {
            return 0;
        }
        Icon linkIcon = table.getLinkIcon((URI)value);
        if (linkIcon == null) {
            return 0;
        }
        int leftColumnWidth = table.getColumnModel().getColumn(0).getWidth();
        if (point.x < leftColumnWidth + linkIcon.getIconWidth()) {
            return 12;
        }
        return 0;
    }

    private void updateCursor(Component component, int cursor) {
        Cursor newCursor = Cursor.getPredefinedCursor(cursor);
        if (component.getCursor().equals(newCursor)) {
            return;
        }
        component.setCursor(cursor == 0 ? null : newCursor);
    }
}

