/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import org.freeplane.core.ui.components.html.ScaledHTML;
import org.freeplane.core.util.TextUtils;
import org.freeplane.view.swing.map.GlyphPainterMetricResetter;
import org.freeplane.view.swing.map.ZoomableLabel;

public class ZoomableLabelUI
extends BasicLabelUI {
    private boolean isPainting = false;
    static ZoomableLabelUI labelUI = new ZoomableLabelUI();
    private Rectangle iconR = new Rectangle();
    private Rectangle textR = new Rectangle();
    private Rectangle viewR = new Rectangle();
    private int maximumWidth = Integer.MAX_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize(ZoomableLabel c, int maximumWidth) {
        try {
            Dimension preferredSize;
            this.maximumWidth = maximumWidth;
            Dimension dimension = preferredSize = this.getPreferredSize(c);
            return dimension;
        }
        finally {
            this.maximumWidth = Integer.MAX_VALUE;
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension preferredSize = super.getPreferredSize(c);
        int fontHeight = ((ZoomableLabel)c).getFontMetrics().getHeight();
        Insets insets = c.getInsets();
        preferredSize.width = Math.max(preferredSize.width, fontHeight / 2 + insets.left + insets.right);
        preferredSize.height = Math.max(preferredSize.height, fontHeight + insets.top + insets.bottom);
        float zoom = ((ZoomableLabel)c).getZoom();
        if (zoom != 1.0f) {
            preferredSize.width = (int)Math.ceil(zoom * (float)preferredSize.width);
            preferredSize.height = (int)Math.ceil(zoom * (float)preferredSize.height);
        }
        return preferredSize;
    }

    public static ComponentUI createUI(JComponent c) {
        return labelUI;
    }

    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        Icon textRenderingIcon;
        Insets insets;
        ZoomableLabel zLabel = (ZoomableLabel)label;
        if (this.isPainting) {
            ScaledHTML.Renderer v;
            insets = zLabel.getInsets();
            int width = zLabel.getWidth();
            int height = zLabel.getHeight();
            float zoom = zLabel.getZoom();
            viewR.x = insets.left;
            viewR.y = insets.top;
            viewR.width = (int)((float)width / zoom) - (insets.left + insets.right);
            viewR.height = (int)((float)height / zoom) - (insets.top + insets.bottom);
            if (viewR.width < 0) {
                viewR.width = 0;
            }
            if ((v = (ScaledHTML.Renderer)label.getClientProperty("html")) != null) {
                float preferredWidth = v.getPreferredSpan(0);
                int textWidth = viewR.width;
                if (icon != null) {
                    textWidth -= icon.getIconWidth() + label.getIconTextGap();
                }
                if (preferredWidth < (float)textWidth) {
                    v.setSize(textWidth, 1.0f);
                    super.layoutCL(zLabel, zLabel.getFontMetrics(), text, icon, viewR, iconR, textR);
                    v.setSize(textR.width, textR.height);
                    return text;
                }
            }
        } else if (this.maximumWidth != Integer.MAX_VALUE) {
            ScaledHTML.Renderer v;
            insets = label.getInsets();
            viewR.width = this.maximumWidth - insets.left - insets.right;
            if (viewR.width < 0) {
                viewR.width = 0;
            }
            if ((v = (ScaledHTML.Renderer)label.getClientProperty("html")) != null) {
                v.resetSize();
                float preferredWidth = v.getPreferredSpan(0);
                float minimumWidth = v.getMinimumSpan(0);
                int textWidth = viewR.width;
                if (icon != null) {
                    textWidth -= icon.getIconWidth() + label.getIconTextGap();
                }
                if (preferredWidth > (float)textWidth) {
                    if (minimumWidth > (float)textWidth) {
                        viewR.width = (int)((float)viewR.width + (minimumWidth - (float)textWidth));
                        textWidth = (int)minimumWidth;
                    }
                    v.setSize(textWidth, 1.0f);
                    super.layoutCL(zLabel, zLabel.getFontMetrics(), text, icon, viewR, iconR, textR);
                    v.setSize(textR.width, textR.height);
                    return text;
                }
            }
        }
        if ((textRenderingIcon = this.getTextRenderingIcon(zLabel)) != null) {
            ZoomableLabelUI.layoutLabelWithTextIcon(textRenderingIcon, icon, viewR, iconR, textR, zLabel);
        } else {
            super.layoutCL(zLabel, zLabel.getFontMetrics(), text, icon, viewR, iconR, textR);
        }
        return text;
    }

    private static void layoutLabelWithTextIcon(Icon textRenderingIcon, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR, ZoomableLabel zLabel) {
        ZoomableLabel c = zLabel;
        int horizontalAlignment = zLabel.getHorizontalAlignment();
        int horizontalTextPosition = zLabel.getHorizontalTextPosition();
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        int verticalAlignment = zLabel.getVerticalAlignment();
        int verticalTextPosition = zLabel.getVerticalTextPosition();
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        int lsb = 0;
        int rsb = 0;
        int gap = icon == null ? 0 : zLabel.getIconTextGap();
        int availTextWidth = hTextPos == 0 ? viewR.width : viewR.width - (iconR.width + gap);
        textR.width = Math.min(availTextWidth, textRenderingIcon.getIconWidth());
        textR.height = textRenderingIcon.getIconHeight();
        textR.y = verticalTextPosition == 1 ? (hTextPos != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (hTextPos != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = hTextPos == 2 ? -(textR.width + gap) : (hTextPos == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = hAlign == 2 ? viewR.x - labelR_x : (hAlign == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        if (lsb < 0) {
            textR.x -= lsb;
            textR.width += lsb;
        }
        if (rsb > 0) {
            textR.width -= rsb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, JComponent label) {
        Object newRenderingHintFM;
        ZoomableLabel mainView = (ZoomableLabel)label;
        if (!mainView.useFractionalMetrics()) {
            try {
                this.isPainting = true;
                this.superPaintSafe(g, mainView);
            }
            finally {
                this.isPainting = false;
            }
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Object oldRenderingHintFM = g2.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
        if (oldRenderingHintFM != (newRenderingHintFM = RenderingHints.VALUE_FRACTIONALMETRICS_ON)) {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, newRenderingHintFM);
        }
        AffineTransform transform = g2.getTransform();
        float zoom = mainView.getZoom() * 0.97f;
        g2.scale(zoom, zoom);
        boolean htmlViewSet = null != label.getClientProperty("html");
        try {
            this.isPainting = true;
            if (htmlViewSet) {
                GlyphPainterMetricResetter.resetPainter();
            }
            this.superPaintSafe(g, mainView);
        }
        finally {
            this.isPainting = false;
            if (htmlViewSet) {
                GlyphPainterMetricResetter.resetPainter();
            }
        }
        g2.setTransform(transform);
        if (oldRenderingHintFM != newRenderingHintFM) {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, oldRenderingHintFM != null ? oldRenderingHintFM : RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
        }
    }

    private void superPaintSafe(Graphics g, final ZoomableLabel label) {
        try {
            Icon textRenderingIcon = this.getTextRenderingIcon(label);
            if (textRenderingIcon != null) {
                this.paintIcons(g, label, textRenderingIcon);
            } else {
                super.paint(g, label);
            }
        }
        catch (ClassCastException e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    label.setText(TextUtils.format("html_problem", label.getText()));
                }
            });
        }
    }

    private void paintIcons(Graphics g, ZoomableLabel label, Icon textRenderingIcon) {
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        Rectangle paintViewR = new Rectangle();
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        this.layoutCL(label, null, null, icon, paintViewR, paintIconR, paintTextR);
        if (icon != null) {
            icon.paintIcon(label, g, paintIconR.x, paintIconR.y);
        }
        textRenderingIcon.paintIcon(label, g, paintTextR.x, paintTextR.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name == "text" || "font" == name || "foreground" == name) {
            JLabel lbl = (JLabel)e.getSource();
            if (this.getTextRenderingIcon(lbl) != null) {
                ScaledHTML.updateRenderer(lbl, "");
            } else {
                String text = lbl.getText();
                GlyphPainterMetricResetter.resetPainter();
                try {
                    ScaledHTML.updateRenderer(lbl, text);
                }
                finally {
                    GlyphPainterMetricResetter.resetPainter();
                }
                View v = (View)lbl.getClientProperty("html");
                if (v != null) {
                    lbl.putClientProperty("preferredWidth", Float.valueOf(v.getPreferredSpan(0)));
                }
            }
        } else {
            super.propertyChange(e);
        }
    }

    private Icon getTextRenderingIcon(JLabel lbl) {
        return (Icon)lbl.getClientProperty("TextRenderingIcon");
    }

    protected void installComponents(JLabel c) {
        ScaledHTML.updateRenderer(c, c.getText());
        c.setInheritsPopupMenu(true);
    }

    public Rectangle getIconR(ZoomableLabel label) {
        this.layout(label);
        return this.iconR;
    }

    public Rectangle getTextR(ZoomableLabel label) {
        this.layout(label);
        return this.textR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layout(ZoomableLabel label) {
        String text = label.getText();
        if (text == null || text.equals("")) {
            text = "!";
        }
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        boolean wasPainting = this.isPainting;
        try {
            this.isPainting = true;
            this.iconR.height = 0;
            this.iconR.width = 0;
            this.iconR.y = 0;
            this.iconR.x = 0;
            this.textR.height = 0;
            this.textR.width = 0;
            this.textR.y = 0;
            this.textR.x = 0;
            this.layoutCL(label, label.getFontMetrics(), text, icon, this.viewR, this.iconR, this.textR);
            float zoom = label.getZoom();
            this.iconR.x = (int)((float)this.iconR.x * zoom);
            this.iconR.y = (int)((float)this.iconR.y * zoom);
            this.iconR.width = (int)((float)this.iconR.width * zoom);
            this.iconR.height = (int)((float)this.iconR.height * zoom);
            this.textR.x = (int)((float)this.textR.x * zoom);
            this.textR.y = (int)((float)this.textR.y * zoom);
            this.textR.width = (int)((float)this.textR.width * zoom);
            this.textR.height = (int)((float)this.textR.height * zoom);
        }
        finally {
            this.isPainting = wasPainting;
        }
    }
}

