/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;

class RootMainView
extends MainView {
    private static final long serialVersionUID = 1L;
    private String shape;
    private static Insets insets = new Insets(4, 4, 4, 4);

    public RootMainView(String shape) {
        this.setHorizontalAlignment(0);
        this.shape = shape;
    }

    public boolean dropAsSibling(double xCoord) {
        return false;
    }

    public boolean dropLeft(double xCoord) {
        return xCoord < (double)(this.getSize().width * 1 / 2);
    }

    public Point getLeftPoint() {
        Point in = new Point(0, this.getHeight() / 2);
        return in;
    }

    public Dimension getPreferredSize(int width) {
        Dimension prefSize = super.getPreferredSize(width);
        if (this.isPreferredSizeSet()) {
            return prefSize;
        }
        prefSize.width = (int)((double)prefSize.width * 1.1);
        prefSize.height *= 2;
        return prefSize;
    }

    public Point getRightPoint() {
        Point in = this.getLeftPoint();
        in.x = this.getWidth() - 1;
        return in;
    }

    public String getShape() {
        return this.shape;
    }

    void setShape(String shape) {
        this.shape = shape;
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        if (this.getNodeView().getModel() == null) {
            return;
        }
        ModeController modeController = this.getNodeView().getMap().getModeController();
        Object renderingHint = modeController.getController().getMapViewManager().setEdgesRenderingHint(g);
        this.paintBackgound(g);
        this.paintDragOver(g);
        g.setColor(Color.gray);
        g.setStroke(new BasicStroke(1.0f));
        g.drawOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
        super.paintComponent(g);
    }

    protected void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fillOval(1, 1, this.getWidth() - 2, this.getHeight() - 2);
    }

    public void paintDragOver(Graphics2D graphics) {
        int draggedOver = this.getDraggedOver();
        if (draggedOver == 1) {
            graphics.setPaint(new GradientPaint(this.getWidth() / 4, 0.0f, this.getNodeView().getMap().getBackground(), this.getWidth() * 3 / 4, 0.0f, NodeView.dragColor));
            graphics.fillRect(this.getWidth() / 4, 0, this.getWidth() - 1, this.getHeight() - 1);
        } else if (draggedOver == 3) {
            graphics.setPaint(new GradientPaint(this.getWidth() * 3 / 4, 0.0f, this.getNodeView().getMap().getBackground(), this.getWidth() / 4, 0.0f, NodeView.dragColor));
            graphics.fillRect(0, 0, this.getWidth() * 3 / 4, this.getHeight() - 1);
        }
    }

    public void setDraggedOver(Point p) {
        this.setDraggedOver(this.dropLeft(p.getX()) ? 3 : 1);
    }

    public Insets getInsets() {
        return insets;
    }

    public Insets getInsets(Insets insets) {
        return RootMainView.insets;
    }

    public Point getConnectorPoint(Point p) {
        RootMainView mainView = this;
        if (USE_COMMON_OUT_POINT_FOR_ROOT_NODE) {
            return super.getConnectorPoint(p);
        }
        double nWidth = (float)mainView.getWidth() / 2.0f;
        double nHeight = (float)mainView.getHeight() / 2.0f;
        int dx = Math.max(Math.abs(p.x - mainView.getWidth() / 2), this.getNodeView().getZoomed(20));
        if (p.x < mainView.getWidth() / 2) {
            dx = -dx;
        }
        double angle = Math.atan(((double)p.y - nHeight) / (double)dx);
        if (dx < 0) {
            angle += Math.PI;
        }
        Point out = new Point((int)((1.0 + Math.cos(angle)) * nWidth), (int)((1.0 + Math.sin(angle)) * nHeight));
        return out;
    }

    public boolean isInDragRegion(Point p) {
        return false;
    }
}

