/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.NodeViewLayoutAdapter;

public class OutlineLayout
extends NodeViewLayoutAdapter {
    private int hGap;
    private static final NodeViewLayoutAdapter instance = new OutlineLayout();

    protected int getHGap() {
        return this.hGap;
    }

    static NodeViewLayoutAdapter getInstance() {
        return instance;
    }

    protected void layout() {
        int x;
        int y = x = this.getSpaceAround();
        JComponent content = this.getContent();
        NodeView view = this.getView();
        if (view.isContentVisible()) {
            this.getContent().setVisible(true);
            Dimension contentProfSize = this.calculateContentSize(view);
            content.setBounds(x, y, contentProfSize.width, contentProfSize.height);
        } else {
            content.setVisible(false);
            content.setBounds(x, y, 0, 0);
        }
        this.placeChildren();
    }

    private void placeChildren() {
        int baseX = this.getContent().getX();
        int y = this.getContent().getY() + this.getContent().getHeight() - this.getSpaceAround();
        if (this.getContent().isVisible()) {
            baseX += this.getHGap();
            y += this.getVGap();
        }
        int right = baseX + this.getContent().getWidth() + this.getSpaceAround();
        NodeView child = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            NodeView component;
            child = component = (NodeView)this.getView().getComponent(i);
            int additionalCloudHeigth = this.getAdditionalCloudHeigth(child) / 2;
            int childHGap = child.getContent().isVisible() ? this.getHGap() : 0;
            int x = baseX + childHGap - child.getContent().getX();
            child.setLocation(x, y += additionalCloudHeigth);
            int childHeight = child.getHeight() - 2 * this.getSpaceAround();
            if (childHeight != 0) {
                y += childHeight + this.getVGap() + additionalCloudHeigth;
            }
            right = Math.max(right, x + child.getWidth() + additionalCloudHeigth);
        }
        int bottom = this.getContent().getY() + this.getContent().getHeight() + this.getSpaceAround();
        if (child != null) {
            this.getView().setSize(right, Math.max(bottom, child.getY() + child.getHeight() + this.getAdditionalCloudHeigth(child) / 2));
        } else {
            this.getView().setSize(right, bottom);
        }
    }

    protected boolean setUp(Container c) {
        if (!super.setUp(c)) {
            return false;
        }
        int vgap = ResourceController.getResourceController().getIntProperty("outline_vgap", 0);
        int hgap = ResourceController.getResourceController().getIntProperty("outline_hgap", 0);
        this.setVGap(this.getView().getMap().getZoomed(vgap));
        this.hGap = this.getView().getMap().getZoomed(hgap);
        return true;
    }
}

