/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.view.swing.map.INodeViewLayout;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.map.cloud.CloudView;

public abstract class NodeViewLayoutAdapter
implements INodeViewLayout {
    private static Dimension minDimension;
    private int childCount;
    private JComponent content;
    protected Point location = new Point();
    private NodeModel model;
    private int spaceAround;
    private int vGap;
    private NodeView view;
    private int contentWidth;
    private int contentHeight;
    private int cloudHeight;

    public void addLayoutComponent(String arg0, Component arg1) {
    }

    protected int getChildCount() {
        return this.childCount;
    }

    protected JComponent getContent() {
        return this.content;
    }

    protected NodeModel getModel() {
        return this.model;
    }

    int getSpaceAround() {
        return this.spaceAround;
    }

    int getVGap() {
        return this.vGap;
    }

    protected NodeView getView() {
        return this.view;
    }

    protected abstract void layout();

    public void layoutContainer(Container c) {
        if (this.setUp(c)) {
            this.layout();
        }
        this.shutDown();
    }

    public Dimension minimumLayoutSize(Container arg0) {
        if (minDimension == null) {
            minDimension = new Dimension(0, 0);
        }
        return minDimension;
    }

    public Dimension preferredLayoutSize(Container c) {
        if (!c.isValid()) {
            c.validate();
        }
        return c.getSize();
    }

    public void removeLayoutComponent(Component arg0) {
    }

    protected boolean setUp(Container c) {
        NodeView localView = (NodeView)c;
        JComponent content = localView.getContent();
        if (content == null) {
            return false;
        }
        int localChildCount = localView.getComponentCount() - 1;
        for (int i = 0; i < localChildCount; ++i) {
            Component component = localView.getComponent(i);
            ((NodeView)component).validateTree();
        }
        this.content = content;
        this.view = localView;
        this.model = localView.getModel();
        this.childCount = localChildCount;
        if (this.getModel().isVisible()) {
            this.setVGap(this.getView().getVGap());
        } else {
            this.setVGap(this.getView().getVisibleParentView().getVGap());
        }
        this.spaceAround = this.view.getSpaceAround();
        if (this.view.isContentVisible()) {
            Dimension contentSize = this.calculateContentSize(this.view);
            this.contentWidth = contentSize.width;
            this.contentHeight = contentSize.height;
            this.cloudHeight = this.getAdditionalCloudHeigth(this.view);
        } else {
            this.contentHeight = 0;
            this.contentWidth = 0;
            this.cloudHeight = 0;
        }
        return true;
    }

    protected Dimension calculateContentSize(NodeView view) {
        Dimension contentSize;
        JComponent content = view.getContent();
        ModeController modeController = view.getMap().getModeController();
        NodeStyleController nsc = NodeStyleController.getController(modeController);
        if (content instanceof ZoomableLabel) {
            int maxNodeWidth = nsc.getMaxWidth(view.getModel());
            contentSize = ((ZoomableLabel)content).getPreferredSize(maxNodeWidth);
        } else {
            contentSize = content.getPreferredSize();
        }
        int minNodeWidth = nsc.getMinWidth(view.getModel());
        int contentWidth = Math.max(view.getZoomed(minNodeWidth), contentSize.width);
        int contentHeight = contentSize.height;
        Dimension contentProfSize = new Dimension(contentWidth, contentHeight);
        return contentProfSize;
    }

    protected void shutDown() {
        this.view = null;
        this.model = null;
        this.content = null;
        this.childCount = 0;
        this.setVGap(0);
        this.spaceAround = 0;
    }

    public void setVGap(int vGap) {
        this.vGap = vGap;
    }

    public int getAdditionalCloudHeigth(NodeView node) {
        if (!node.isContentVisible()) {
            return 0;
        }
        CloudModel cloud = node.getCloudModel();
        if (cloud != null) {
            return CloudView.getAdditionalHeigth(cloud, node);
        }
        return 0;
    }

    protected void calcLayout(boolean isLeft, LayoutData data) {
        int highestSummaryLevel = 1;
        int level = 1;
        for (int i = 0; i < this.getChildCount(); ++i) {
            NodeView child = (NodeView)this.getView().getComponent(i);
            if (child.isLeft() != isLeft) continue;
            if (child.isSummary()) {
                highestSummaryLevel = Math.max(highestSummaryLevel, ++level);
                continue;
            }
            level = 1;
        }
        int left = 0;
        int y = 0;
        int childContentHeightSum = 0;
        int visibleChildCounter = 0;
        boolean useSummaryAsItem = true;
        int top = 0;
        int[] groupStart = new int[highestSummaryLevel];
        int[] groupStartContentHeightSum = new int[highestSummaryLevel];
        int[] groupStartY = new int[highestSummaryLevel];
        int[] groupEndY = new int[highestSummaryLevel];
        int[] summaryBaseX = new int[highestSummaryLevel];
        level = highestSummaryLevel;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int x;
            boolean isFreeNode;
            NodeView child = (NodeView)this.getView().getComponent(i);
            if (child.isLeft() != isLeft) continue;
            boolean isSummary = child.isSummary();
            boolean isItem = !isSummary || useSummaryAsItem;
            int oldLevel = level++;
            if (isItem) {
                if (level > 0) {
                    useSummaryAsItem = true;
                }
                level = 0;
            }
            int childCloudHeigth = this.getAdditionalCloudHeigth(child);
            int childContentHeight = child.getContent().getHeight() + childCloudHeigth;
            int childShiftY = child.isContentVisible() ? child.getShift() : 0;
            int childContentShift = child.getContent().getY() - childCloudHeigth / 2 - this.getSpaceAround();
            int childHGap = child.isContentVisible() ? child.getHGap() : (child.isSummary() ? child.getZoomed(20) : 0);
            int childHeight = child.getHeight() - 2 * this.getSpaceAround();
            data.free[i] = isFreeNode = child.isFree();
            boolean bl = data.summary[i] = !isItem;
            if (isItem) {
                if (isFreeNode) {
                    data.ly[i] = childShiftY - childContentShift - childCloudHeigth / 2 - this.getSpaceAround();
                } else {
                    if (childShiftY < 0 || visibleChildCounter == 0) {
                        top += childShiftY;
                    }
                    top -= childContentShift;
                    top += child.getTopOverlap();
                    y -= child.getTopOverlap();
                    if (childShiftY < 0) {
                        data.ly[i] = y;
                        y -= childShiftY;
                    } else {
                        if (visibleChildCounter > 0) {
                            y += childShiftY;
                        }
                        data.ly[i] = y;
                    }
                    if (childHeight != 0) {
                        y += childHeight + this.getVGap();
                        y -= child.getBottomOverlap();
                    }
                    childContentHeightSum += childContentHeight;
                    if (oldLevel > 0) {
                        summaryBaseX[0] = 0;
                        for (int j = 0; j < oldLevel; ++j) {
                            groupStart[j] = i;
                            groupStartY[j] = Integer.MAX_VALUE;
                            groupEndY[j] = Integer.MIN_VALUE;
                            groupStartContentHeightSum[j] = childContentHeightSum;
                        }
                    } else if (child.isFirstGroupNode()) {
                        groupStartContentHeightSum[0] = childContentHeightSum;
                        summaryBaseX[0] = 0;
                        groupStart[0] = i;
                    }
                    if (childHeight != 0 && visibleChildCounter > 0) {
                        childContentHeightSum += this.getVGap();
                    }
                }
                if (childHeight != 0) {
                    ++visibleChildCounter;
                    useSummaryAsItem = false;
                }
            } else {
                int summaryY;
                int itemLevel = level - 1;
                if (child.isFirstGroupNode()) {
                    groupStartContentHeightSum[level] = groupStartContentHeightSum[itemLevel];
                    summaryBaseX[level] = 0;
                    groupStart[level] = groupStart[itemLevel];
                }
                data.ly[i] = summaryY = (groupStartY[itemLevel] + groupEndY[itemLevel]) / 2 - childContentHeight / 2 + childShiftY - (child.getContent().getY() - childCloudHeigth / 2 - this.getSpaceAround());
                if (!isFreeNode) {
                    int deltaY = summaryY - groupStartY[itemLevel] + child.getTopOverlap();
                    if (deltaY < 0) {
                        top += deltaY;
                        y -= deltaY;
                        summaryY -= deltaY;
                        for (int j = groupStart[itemLevel]; j <= i; ++j) {
                            NodeView groupItem = (NodeView)this.getView().getComponent(j);
                            if (groupItem.isLeft() != isLeft || !data.summary[j] && data.free[j]) continue;
                            int n = j;
                            data.ly[n] = data.ly[n] - deltaY;
                        }
                    }
                    if (childHeight != 0) {
                        summaryY += childHeight + this.getVGap() - child.getBottomOverlap();
                    }
                    y = Math.max(y, summaryY);
                    int summaryContentHeight = groupStartContentHeightSum[itemLevel] + childContentHeight;
                    if (childContentHeightSum < summaryContentHeight) {
                        childContentHeightSum = summaryContentHeight;
                    }
                }
            }
            if (!isItem || !isFreeNode) {
                if (child.isFirstGroupNode()) {
                    groupStartY[level] = data.ly[i] + child.getTopOverlap();
                    groupEndY[level] = data.ly[i] + childHeight - child.getBottomOverlap();
                } else {
                    groupStartY[level] = Math.min(groupStartY[level], data.ly[i] + child.getTopOverlap());
                    groupEndY[level] = Math.max(data.ly[i] + childHeight - child.getBottomOverlap(), groupEndY[level]);
                }
            }
            int baseX = level > 0 ? summaryBaseX[level - 1] : (child.isLeft() != (isItem && isFreeNode) ? 0 : this.contentWidth);
            if (child.isLeft()) {
                x = baseX - childHGap - child.getContent().getX() - child.getContent().getWidth();
                summaryBaseX[level] = Math.min(summaryBaseX[level], x + this.getSpaceAround());
            } else {
                x = baseX + childHGap - child.getContent().getX();
                summaryBaseX[level] = Math.max(summaryBaseX[level], x + child.getWidth() - this.getSpaceAround());
            }
            left = Math.min(left, x);
            data.lx[i] = x;
        }
        this.setData(data, isLeft, left, childContentHeightSum, top += (this.contentHeight - childContentHeightSum) / 2);
    }

    private void setData(LayoutData data, boolean isLeft, int left, int childContentHeight, int top) {
        if (!isLeft && data.leftDataSet || isLeft && data.rightDataSet) {
            boolean changeLeft;
            data.left = Math.min(data.left, left);
            data.childContentHeight = Math.max(data.childContentHeight, childContentHeight);
            int deltaTop = top - data.top;
            if (deltaTop < 0) {
                data.top = top;
                changeLeft = !isLeft;
                deltaTop = -deltaTop;
            } else {
                changeLeft = isLeft;
            }
            for (int i = 0; i < this.getChildCount(); ++i) {
                NodeView child = (NodeView)this.getView().getComponent(i);
                if (child.isLeft() != changeLeft || !data.summary[i] && data.free[i]) continue;
                int n = i;
                data.ly[n] = data.ly[n] + deltaTop;
            }
        } else {
            data.left = left;
            data.childContentHeight = childContentHeight;
            data.top = top;
        }
        if (isLeft) {
            data.leftDataSet = true;
        } else {
            data.rightDataSet = true;
        }
    }

    protected void placeChildren(LayoutData data) {
        int contentX = Math.max(this.getSpaceAround(), -data.left);
        int contentY = this.getSpaceAround() + this.cloudHeight / 2 - Math.min(0, data.top);
        if (this.getView().isContentVisible()) {
            this.getContent().setVisible(true);
        } else {
            this.getContent().setVisible(false);
        }
        int baseY = contentY - this.getSpaceAround() + data.top;
        int minY = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            minY = !data.summary[i] && data.free[i] ? Math.min(minY, contentY + data.ly[i]) : Math.min(minY, baseY + data.ly[i]);
        }
        if (minY < 0) {
            contentY -= minY;
            baseY -= minY;
        }
        int width = contentX + this.contentWidth + this.getSpaceAround();
        int height = contentY + this.contentHeight + this.cloudHeight / 2 + this.getSpaceAround();
        this.getContent().setBounds(contentX, contentY, this.contentWidth, this.contentHeight);
        int topOverlap = -minY;
        int heigthWithoutOverlap = height;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int y;
            NodeView child = (NodeView)this.getView().getComponent(i);
            if (!data.summary[i] && data.free[i]) {
                y = contentY + data.ly[i];
            } else {
                y = baseY + data.ly[i];
                if (!data.free[i]) {
                    heigthWithoutOverlap = Math.max(heigthWithoutOverlap, y + child.getHeight() + this.cloudHeight / 2 - child.getBottomOverlap());
                }
            }
            int x = contentX + data.lx[i];
            child.setLocation(x, y);
            width = Math.max(width, child.getX() + child.getWidth());
            height = Math.max(height, y + child.getHeight() + this.cloudHeight / 2);
        }
        this.view.setSize(width, height);
        this.view.setTopOverlap(topOverlap);
        this.view.setBottomOverlap(height - heigthWithoutOverlap);
    }

    protected static class LayoutData {
        final int[] lx;
        final int[] ly;
        final boolean[] free;
        final boolean[] summary;
        int left;
        int childContentHeight;
        int top;
        boolean rightDataSet;
        boolean leftDataSet;

        public LayoutData(int childCount) {
            this.lx = new int[childCount];
            this.ly = new int[childCount];
            this.free = new boolean[childCount];
            this.summary = new boolean[childCount];
            this.left = 0;
            this.childContentHeight = 0;
            this.top = 0;
            this.rightDataSet = false;
            this.leftDataSet = false;
        }
    }
}

