/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.text.DetailTextModel;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.ArrowIcon;
import org.freeplane.view.swing.map.BubbleMainView;
import org.freeplane.view.swing.map.ContentPane;
import org.freeplane.view.swing.map.DetailsView;
import org.freeplane.view.swing.map.ForkMainView;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeTooltipManager;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.RootMainView;
import org.freeplane.view.swing.map.SelectableLayout;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.ui.DefaultMapMouseListener;
import org.freeplane.view.swing.ui.DetailsViewMouseListener;
import org.freeplane.view.swing.ui.LinkNavigatorMouseListener;

class NodeViewFactory {
    private static NodeViewFactory factory;
    private static Map<Color, Icon> coloredNoteIcons;
    private Icon coloredIcon = this.createColoredIcon();
    private static final IMouseListener DETAILS_MOUSE_LISTENER;
    private static final LinkNavigatorMouseListener LINK_MOUSE_LISTENER;

    static NodeViewFactory getInstance() {
        if (factory == null) {
            factory = new NodeViewFactory();
        }
        return factory;
    }

    private NodeViewFactory() {
    }

    private void fireNodeViewCreated(NodeView newView) {
        newView.getMap().getModeController().onViewCreated(newView);
    }

    JComponent newContentPane(NodeView view) {
        return new ContentPane();
    }

    MainView newMainView(NodeView node) {
        MainView view;
        String shape = this.shape(node);
        MainView oldView = node.getMainView();
        if (oldView != null && oldView.getShape().equals(shape)) {
            return oldView;
        }
        ModeController modeController = node.getMap().getModeController();
        NodeModel model = node.getModel();
        if (shape.equals("bubble")) {
            view = model.isRoot() ? new RootMainView("bubble") : new BubbleMainView();
        } else {
            if (shape != null && !shape.equals("fork")) {
                System.err.println("Tried to create a NodeView of unknown Style " + String.valueOf(shape));
            }
            view = model.isRoot() ? new RootMainView("fork") : new ForkMainView();
        }
        NodeTooltipManager toolTipManager = NodeTooltipManager.getSharedInstance(modeController);
        toolTipManager.registerComponent(view);
        return view;
    }

    private String shape(NodeView node) {
        ModeController modeController = node.getMap().getModeController();
        NodeModel model = node.getModel();
        String shape = NodeStyleController.getController(modeController).getShape(model);
        if (shape.equals("combined")) {
            shape = Controller.getCurrentModeController().getMapController().isFolded(model) ? "bubble" : "fork";
        } else {
            while (shape.equals("as_parent")) {
                if ((node = node.getParentView()) == null) {
                    shape = "fork";
                    continue;
                }
                shape = node.getMainView().getShape();
            }
        }
        return shape;
    }

    NodeView newNodeView(NodeModel model, MapView map, Container parent, int index) {
        NodeView newView = new NodeView(model, map, parent);
        parent.add((Component)newView, index);
        if (map.isDisplayable()) {
            this.updateNewView(newView);
        } else {
            newView.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent e) {
                    NodeView view = (NodeView)e.getComponent();
                    if (this.displayed(view, e)) {
                        view.removeHierarchyListener(this);
                        NodeViewFactory.this.updateNewView(view);
                    } else if (this.removed(view, e)) {
                        view.removeHierarchyListener(this);
                    }
                }

                private boolean removed(NodeView view, HierarchyEvent e) {
                    return 0L != (e.getChangeFlags() & 1L) && view.getParent() == null;
                }

                private boolean displayed(NodeView view, HierarchyEvent e) {
                    return 0L != (e.getChangeFlags() & 2L) && view.isDisplayable();
                }
            });
        }
        return newView;
    }

    private void updateNewView(NodeView newView) {
        newView.getModel().addViewer(newView);
        newView.setLayout(SelectableLayout.getInstance());
        newView.setMainView(this.newMainView(newView));
        this.updateNoteViewer(newView);
        newView.update();
        this.fireNodeViewCreated(newView);
        newView.addChildViews();
    }

    public ZoomableLabel createNoteViewer() {
        ZoomableLabel label = new ZoomableLabel();
        label.addMouseListener(LINK_MOUSE_LISTENER);
        label.addMouseMotionListener(LINK_MOUSE_LISTENER);
        label.setIcon(this.coloredIcon);
        label.setVerticalTextPosition(1);
        return label;
    }

    private Icon createColoredIcon() {
        return new Icon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                NodeView nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, c);
                if (nodeView == null) {
                    return;
                }
                Color iconColor = nodeView.getEdgeColor();
                NodeViewFactory.this.createColoredIcon(iconColor).paintIcon(c, g, x, y);
            }

            public int getIconWidth() {
                return NodeViewFactory.this.createColoredIcon(Color.BLACK).getIconWidth();
            }

            public int getIconHeight() {
                return NodeViewFactory.this.createColoredIcon(Color.BLACK).getIconHeight();
            }
        };
    }

    private Icon createColoredIcon(Color iconColor) {
        Icon icon = coloredNoteIcons.get(iconColor);
        if (icon == null) {
            try {
                BufferedImage img = ImageIO.read(NoteController.bwNoteIconUrl);
                int oldRGB = 0xFFFFFF & Color.BLACK.getRGB();
                int newRGB = 0xFFFFFF & iconColor.getRGB();
                if (oldRGB != newRGB) {
                    for (int x = 0; x < img.getWidth(); ++x) {
                        for (int y = 0; y < img.getHeight(); ++y) {
                            int rgb = img.getRGB(x, y);
                            if ((0xFFFFFF & rgb) != oldRGB) continue;
                            img.setRGB(x, y, 0xFF000000 & rgb | newRGB);
                        }
                    }
                }
                icon = new ImageIcon(img);
                coloredNoteIcons.put(iconColor, icon);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return icon;
    }

    void updateNoteViewer(NodeView nodeView) {
        ZoomableLabel view;
        ZoomableLabel note = (ZoomableLabel)nodeView.getContent(10);
        String oldText = note != null ? note.getText() : null;
        String newText = null;
        if (nodeView.getMap().showNotes()) {
            TextController textController = TextController.getController();
            NodeModel model = nodeView.getModel();
            NoteModel extension = NoteModel.getNote(model);
            if (extension != null) {
                String originalText = extension.getHtml();
                try {
                    newText = textController.getTransformedTextNoThrow(originalText, model, extension);
                    boolean markTransformedText = TextController.isMarkTransformedTextSet();
                    if (markTransformedText && newText != originalText) {
                        newText = this.colorize(newText, "green");
                    }
                }
                catch (Exception e) {
                    newText = this.colorize(TextUtils.format("MainView.errorUpdateText", originalText, e.getLocalizedMessage()).replace("\n", "<br>"), "red");
                }
            }
        }
        if (oldText == null && newText == null) {
            return;
        }
        if (oldText != null && newText != null) {
            view = (ZoomableLabel)nodeView.getContent(10);
        } else if (oldText == null && newText != null) {
            view = NodeViewFactory.getInstance().createNoteViewer();
            nodeView.addContent(view, 10);
        } else {
            assert (oldText != null && newText == null);
            nodeView.removeContent(10);
            return;
        }
        view.setFont(nodeView.getMap().getDefaultNoteFont());
        view.updateText(newText);
    }

    private String colorize(String text, String color) {
        return "<span style=\"color:" + color + ";font-style:italic;\">" + text + "</span>";
    }

    void updateDetails(NodeView nodeView) {
        DetailTextModel detailText = DetailTextModel.getDetailText(nodeView.getModel());
        if (detailText == null) {
            nodeView.removeContent(2);
            return;
        }
        DetailsView detailContent = (DetailsView)nodeView.getContent(2);
        if (detailContent == null) {
            detailContent = this.createDetailView();
            nodeView.addContent(detailContent, 2);
        }
        if (detailText.isHidden()) {
            ArrowIcon icon = new ArrowIcon(nodeView, true);
            detailContent.setIcon(icon);
            detailContent.setBackground(null);
            detailContent.updateText("");
            detailContent.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        } else {
            MapView map = nodeView.getMap();
            detailContent.setFont(map.getDetailFont());
            detailContent.setIcon(new ArrowIcon(nodeView, false));
            detailContent.updateText(detailText.getHtml());
            detailContent.setForeground(map.getDetailForeground());
            detailContent.setBackground(nodeView.getDetailBackground());
            detailContent.setPreferredSize(null);
        }
    }

    private DetailsView createDetailView() {
        DetailsView detailContent = new DetailsView();
        DefaultMapMouseListener mouseListener = new DefaultMapMouseListener();
        detailContent.addMouseMotionListener(mouseListener);
        detailContent.addMouseMotionListener(DETAILS_MOUSE_LISTENER);
        detailContent.addMouseListener(DETAILS_MOUSE_LISTENER);
        return detailContent;
    }

    static {
        coloredNoteIcons = new HashMap<Color, Icon>();
        DETAILS_MOUSE_LISTENER = new DetailsViewMouseListener();
        LINK_MOUSE_LISTENER = new LinkNavigatorMouseListener();
    }
}

