/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.HideChildSubtree;
import org.freeplane.features.map.HistoryInformationModel;
import org.freeplane.features.map.INodeView;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.BubbleMainView;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeViewFactory;
import org.freeplane.view.swing.map.PaintingMode;
import org.freeplane.view.swing.map.RootMainView;
import org.freeplane.view.swing.map.SummaryEdgePainter;
import org.freeplane.view.swing.map.attribute.AttributeView;
import org.freeplane.view.swing.map.cloud.CloudView;
import org.freeplane.view.swing.map.cloud.CloudViewFactory;
import org.freeplane.view.swing.map.edge.EdgeView;
import org.freeplane.view.swing.map.edge.EdgeViewFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeView
extends JComponent
implements INodeView {
    static final int ALIGN_BOTTOM = -1;
    static final int ALIGN_CENTER = 0;
    static final int ALIGN_TOP = 1;
    protected static final Color dragColor = Color.lightGray;
    public static final int DRAGGED_OVER_NO = 0;
    public static final int DRAGGED_OVER_SIBLING = 2;
    public static final int DRAGGED_OVER_SON = 1;
    public static final int DRAGGED_OVER_SON_LEFT = 3;
    private static int FOLDING_SYMBOL_WIDTH = -1;
    private static final long serialVersionUID = 1L;
    public static final int SHIFT = -2;
    static final int SPACE_AROUND = 50;
    public static final int MAIN_VIEWER_POSITION = 1;
    public static final int NOTE_VIEWER_POSITION = 10;
    static final boolean PAINT_DEBUG_BORDER;
    private static int maxToolTipWidth;
    private AttributeView attributeView;
    private JComponent contentPane;
    private MainView mainView;
    private final MapView map;
    private NodeModel model;
    private NodeView preferredChild;
    private EdgeStyle edgeStyle = EdgeStyle.EDGESTYLE_HIDDEN;
    private Integer edgeWidth = 1;
    private Color edgeColor = Color.BLACK;
    private Color modelBackgroundColor;
    private int topOverlap;
    private int bottomOverlap;
    public static final int DETAIL_VIEWER_POSITION = 2;
    public static int ADDITIONAL_MOUSE_SENSITIVE_AREA;

    protected NodeView(NodeModel model, MapView map, Container parent) {
        this.setFocusCycleRoot(true);
        this.model = model;
        this.map = map;
    }

    void addDragListener(DragGestureListener dgl) {
        if (dgl == null) {
            return;
        }
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.getMainView(), 0x40000003, dgl);
    }

    void addDropListener(DropTargetListener dtl) {
        if (dtl == null) {
            return;
        }
        DropTarget dropTarget = new DropTarget(this.getMainView(), dtl);
        dropTarget.setActive(true);
    }

    private int calcShiftY(LocationModel locationModel) {
        try {
            NodeModel parent = this.model.getParentNode();
            return locationModel.getShiftY() + (this.getMap().getModeController().hasOneVisibleChild(parent) ? -2 : 0);
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    @Override
    public boolean contains(int x, int y) {
        int space = this.getMap().getZoomed(50);
        int reducedSpace = space - ADDITIONAL_MOUSE_SENSITIVE_AREA;
        if (x >= reducedSpace && x < this.getWidth() - reducedSpace && y >= reducedSpace && y < this.getHeight() - reducedSpace) {
            for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                Component comp = this.getComponent(i);
                if (!comp.isVisible() || !comp.contains(x - comp.getX(), y - comp.getY())) continue;
                return true;
            }
        }
        return false;
    }

    protected void convertPointToMap(Point p) {
        UITools.convertPointToAncestor((Component)this, p, this.getMap());
    }

    public void createAttributeView() {
        if (this.attributeView == null && NodeAttributeTableModel.getModel(this.model).getNode() != null) {
            this.attributeView = new AttributeView(this, true);
        }
        this.syncronizeAttributeView();
    }

    public boolean focused() {
        return this.mainView.hasFocus();
    }

    public AttributeView getAttributeView() {
        if (this.attributeView == null) {
            AttributeController.getController(this.getMap().getModeController()).createAttributeTableModel(this.model);
            this.attributeView = new AttributeView(this, true);
        }
        return this.attributeView;
    }

    public Color getBackgroundColor() {
        Color cloudColor = this.getCloudColor();
        if (cloudColor != null) {
            return cloudColor;
        }
        if (this.isRoot()) {
            return this.getMap().getBackground();
        }
        return this.getParentView().getBackgroundColor();
    }

    public Color getCloudColor() {
        CloudModel cloudModel = this.getCloudModel();
        if (cloudModel != null) {
            Color cloudColor = cloudModel.getColor();
            return cloudColor;
        }
        return null;
    }

    public LinkedList<NodeView> getChildrenViews() {
        LinkedList<NodeView> childrenViews = new LinkedList<NodeView>();
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof NodeView)) continue;
            NodeView view = (NodeView)components[i];
            childrenViews.add(view);
        }
        return childrenViews;
    }

    public JComponent getContent() {
        JComponent c;
        JComponent jComponent = c = this.contentPane == null ? this.mainView : this.contentPane;
        assert (c == null || c.getParent() == this);
        return c;
    }

    private Container getContentPane() {
        if (this.contentPane == null) {
            Window windowAncestor = SwingUtilities.getWindowAncestor(this.mainView);
            boolean hasFocus = windowAncestor != null && windowAncestor.getMostRecentFocusOwner() == this.mainView;
            this.contentPane = NodeViewFactory.getInstance().newContentPane(this);
            int index = this.getComponentCount() - 1;
            this.remove(index);
            this.contentPane.add(this.mainView);
            this.mainView.putClientProperty("NODE_VIEW_CONTENT_POSITION", 1);
            if (!this.mainView.isVisible()) {
                this.mainView.setVisible(true);
            }
            this.add((Component)this.contentPane, index);
            if (hasFocus) {
                this.restoreFocusToMainView();
            }
        }
        return this.contentPane;
    }

    private void restoreFocusToMainView() {
        final Window windowAncestor = SwingUtilities.getWindowAncestor(this.mainView);
        if (windowAncestor.isFocused()) {
            this.mainView.requestFocusInWindow();
        } else {
            windowAncestor.addWindowFocusListener(new WindowFocusListener(){

                public void windowLostFocus(WindowEvent e) {
                }

                public void windowGainedFocus(WindowEvent e) {
                    NodeView.this.mainView.requestFocusInWindow();
                    windowAncestor.removeWindowFocusListener(this);
                }
            });
        }
    }

    public void getCoordinates(LinkedList<Point> inList) {
        this.getCoordinates(inList, 0, false, 0, 0);
    }

    private void getCoordinates(LinkedList<Point> inList, int additionalDistanceForConvexHull, boolean byChildren, int transX, int transY) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isContentVisible()) {
            ModeController modeController;
            CloudController cloudController;
            CloudModel cloud;
            if (byChildren && (cloud = (cloudController = CloudController.getController(modeController = this.getMap().getModeController())).getCloud(this.getModel())) != null) {
                additionalDistanceForConvexHull += CloudView.getAdditionalHeigth(cloud, this) / 5;
            }
            int x = transX + this.getContent().getX() - this.getDeltaX();
            int y = transY + this.getContent().getY() - this.getDeltaY();
            int width = this.mainView.getMainViewWidthWithFoldingMark();
            int heightWithFoldingMark = this.mainView.getMainViewHeightWithFoldingMark();
            int height = Math.max(heightWithFoldingMark, this.getContent().getHeight());
            inList.addLast(new Point(-additionalDistanceForConvexHull + x, -additionalDistanceForConvexHull + y));
            inList.addLast(new Point(-additionalDistanceForConvexHull + x, additionalDistanceForConvexHull + y + height));
            inList.addLast(new Point(additionalDistanceForConvexHull + x + width, additionalDistanceForConvexHull + y + height));
            inList.addLast(new Point(additionalDistanceForConvexHull + x + width, -additionalDistanceForConvexHull + y));
        }
        for (NodeView child : this.getChildrenViews()) {
            child.getCoordinates(inList, additionalDistanceForConvexHull, true, transX + child.getX(), transY + child.getY());
        }
    }

    public int getDeltaX() {
        return this.mainView.getDeltaX();
    }

    public int getDeltaY() {
        return this.mainView.getDeltaY();
    }

    NodeView getFirst(Component startAfter, boolean leftOnly, boolean rightOnly) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (startAfter != null) {
                if (components[i] != startAfter) continue;
                startAfter = null;
                continue;
            }
            if (!(components[i] instanceof NodeView)) continue;
            NodeView view = (NodeView)components[i];
            if (leftOnly && !view.isLeft() || rightOnly && view.isLeft()) continue;
            if (view.isContentVisible()) {
                return view;
            }
            NodeView child = view.getFirst(null, leftOnly, rightOnly);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public int getHGap() {
        return this.map.getZoomed(LocationModel.getModel(this.model).getHGap());
    }

    private NodeView getLast(Component startBefore, boolean leftOnly, boolean rightOnly) {
        Component[] components = this.getComponents();
        for (int i = components.length - 1; i >= 0; --i) {
            if (startBefore != null) {
                if (components[i] != startBefore) continue;
                startBefore = null;
                continue;
            }
            if (!(components[i] instanceof NodeView)) continue;
            NodeView view = (NodeView)components[i];
            if (leftOnly && !view.isLeft() || rightOnly && view.isLeft()) continue;
            if (view.isContentVisible()) {
                return view;
            }
            NodeView child = view.getLast(null, leftOnly, rightOnly);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    LinkedList<NodeView> getLeft(boolean onlyVisible) {
        LinkedList<NodeView> left = new LinkedList<NodeView>();
        for (NodeView node : this.getChildrenViews()) {
            if (node == null || !node.isLeft()) continue;
            left.add(node);
        }
        return left;
    }

    public Point getLinkPoint(Point declination) {
        Point linkPoint;
        int y;
        int x;
        if (declination != null) {
            x = this.getMap().getZoomed(declination.x);
            y = this.getMap().getZoomed(declination.y);
        } else {
            x = 1;
            y = 0;
        }
        if (this.isLeft()) {
            x = -x;
        }
        if (y != 0) {
            int absLinkY;
            int absLinkX;
            double ctgLine;
            double ctgRect = Math.abs((double)this.getContent().getWidth() / (double)this.getContent().getHeight());
            if (ctgRect > (ctgLine = Math.abs((double)x / (double)y))) {
                absLinkX = Math.abs(x * this.getContent().getHeight() / (2 * y));
                absLinkY = this.getContent().getHeight() / 2;
            } else {
                absLinkX = this.getContent().getWidth() / 2;
                absLinkY = Math.abs(y * this.getContent().getWidth() / (2 * x));
            }
            linkPoint = new Point(this.getContent().getWidth() / 2 + (x > 0 ? absLinkX : -absLinkX), this.getContent().getHeight() / 2 + (y > 0 ? absLinkY : -absLinkY));
        } else {
            linkPoint = new Point(x > 0 ? this.getContent().getWidth() : 0, this.getContent().getHeight() / 2);
        }
        linkPoint.translate(this.getContent().getX(), this.getContent().getY());
        this.convertPointToMap(linkPoint);
        return linkPoint;
    }

    public MainView getMainView() {
        return this.mainView;
    }

    public Point getMainViewConnectorPoint(NodeView target) {
        Point relativeLocation = this.getRelativeLocation(target);
        relativeLocation.x += target.getMainView().getWidth() / 2;
        relativeLocation.y += target.getMainView().getHeight() / 2;
        return this.mainView.getConnectorPoint(relativeLocation);
    }

    public Point getRelativeLocation(NodeView target) {
        int targetX = 0;
        int targetY = 0;
        Container component = target.getMainView();
        while (!this.equals(component) && !component.getClass().equals(MapView.class)) {
            targetX += ((Component)component).getX();
            targetY += ((Component)component).getY();
            component = component.getParent();
        }
        Point relativeLocation = new Point();
        UITools.convertPointToAncestor((Component)this.mainView, relativeLocation, component);
        relativeLocation.x = targetX - relativeLocation.x;
        relativeLocation.y = targetY - relativeLocation.y;
        return relativeLocation;
    }

    public MapView getMap() {
        return this.map;
    }

    public int getMaxToolTipWidth() {
        if (maxToolTipWidth == 0) {
            try {
                maxToolTipWidth = ResourceController.getResourceController().getIntProperty("toolTipManager.max_tooltip_width", 600);
            }
            catch (NumberFormatException e) {
                maxToolTipWidth = 600;
            }
        }
        return maxToolTipWidth;
    }

    public NodeModel getModel() {
        return this.model;
    }

    protected NodeView getNextSiblingSingle() {
        LinkedList<NodeView> v = null;
        v = this.getParentView().getModel().isRoot() ? (this.isLeft() ? this.getParentView().getLeft(true) : this.getParentView().getRight(true)) : this.getParentView().getChildrenViews();
        int index = v.indexOf(this);
        for (int i = index + 1; i < v.size(); ++i) {
            NodeView nextView = v.get(i);
            if (nextView.isContentVisible()) {
                return nextView;
            }
            NodeView first = nextView.getFirst(null, false, false);
            if (first == null) continue;
            return first;
        }
        return this;
    }

    protected NodeView getNextVisibleSibling() {
        NodeView first;
        NodeView lastSibling = this;
        NodeView sibling = this;
        while (!sibling.getModel().isRoot()) {
            lastSibling = sibling;
            if ((sibling = sibling.getNextSiblingSingle()) != lastSibling) break;
            sibling = sibling.getParentView();
        }
        while (sibling.getModel().getNodeLevel(false) < this.getMap().getSiblingMaxLevel() && (first = sibling.getFirst(sibling.isRoot() ? lastSibling : null, this.isLeft(), !this.isLeft())) != null) {
            sibling = first;
        }
        if (sibling.isRoot()) {
            return this;
        }
        return sibling;
    }

    public NodeView getParentView() {
        Container parent = this.getParent();
        if (parent instanceof NodeView) {
            return (NodeView)parent;
        }
        return null;
    }

    public NodeView getPreferredVisibleChild(boolean getUpper, boolean left) {
        if (this.getModel().isLeaf()) {
            return null;
        }
        if (getUpper) {
            this.preferredChild = null;
        }
        if (this.preferredChild != null && left == this.preferredChild.isLeft() && this.preferredChild.getParent() == this) {
            if (this.preferredChild.isContentVisible()) {
                return this.preferredChild;
            }
            NodeView newSelected = this.preferredChild.getPreferredVisibleChild(getUpper, left);
            if (newSelected != null) {
                return newSelected;
            }
        }
        int yGap = Integer.MAX_VALUE;
        NodeView baseComponent = this.isContentVisible() ? this : this.getVisibleParentView();
        int ownX = baseComponent.getContent().getX() + baseComponent.getContent().getWidth() / 2;
        int ownY = baseComponent.getContent().getY() + baseComponent.getContent().getHeight() / 2;
        NodeView newSelected = null;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            NodeView childView;
            Component c = this.getComponent(i);
            if (!(c instanceof NodeView) || (childView = (NodeView)c).isLeft() != left || !childView.isContentVisible() && (childView = childView.getPreferredVisibleChild(getUpper, left)) == null) continue;
            if (getUpper) {
                return childView;
            }
            JComponent childContent = childView.getContent();
            if (childContent == null) continue;
            Point childPoint = new Point(left ? childContent.getWidth() : 0, childContent.getHeight() / 2);
            UITools.convertPointToAncestor((Component)childContent, childPoint, baseComponent);
            int dy = childPoint.y - ownY;
            int dx = childPoint.x - ownX;
            int gapToChild = dy * dy + dx * dx;
            if (gapToChild >= yGap) break;
            newSelected = childView;
            this.preferredChild = (NodeView)c;
            yGap = gapToChild;
        }
        return newSelected;
    }

    protected NodeView getPreviousSiblingSingle() {
        LinkedList<NodeView> v = null;
        v = this.getParentView().getModel().isRoot() ? (this.isLeft() ? this.getParentView().getLeft(true) : this.getParentView().getRight(true)) : this.getParentView().getChildrenViews();
        int index = v.indexOf(this);
        for (int i = index - 1; i >= 0; --i) {
            NodeView nextView = v.get(i);
            if (nextView.isContentVisible()) {
                return nextView;
            }
            NodeView last = nextView.getLast(null, false, false);
            if (last == null) continue;
            return last;
        }
        return this;
    }

    protected NodeView getPreviousVisibleSibling() {
        NodeView last;
        NodeView previousSibling = this;
        NodeView sibling = this;
        while (!sibling.getModel().isRoot()) {
            previousSibling = sibling;
            if ((sibling = sibling.getPreviousSiblingSingle()) != previousSibling) break;
            sibling = sibling.getParentView();
        }
        while (sibling.getModel().getNodeLevel(false) < this.getMap().getSiblingMaxLevel() && (last = sibling.getLast(sibling.isRoot() ? previousSibling : null, this.isLeft(), !this.isLeft())) != null) {
            sibling = last;
        }
        if (sibling.isRoot()) {
            return this;
        }
        return sibling;
    }

    LinkedList<NodeView> getRight(boolean onlyVisible) {
        LinkedList<NodeView> right = new LinkedList<NodeView>();
        for (NodeView node : this.getChildrenViews()) {
            if (node == null || node.isLeft()) continue;
            right.add(node);
        }
        return right;
    }

    public Color getSelectedColor() {
        return MapView.standardSelectColor;
    }

    public int getShift() {
        LocationModel locationModel = LocationModel.getModel(this.model);
        return this.map.getZoomed(this.calcShiftY(locationModel));
    }

    protected LinkedList<NodeView> getSiblingViews() {
        return this.getParentView().getChildrenViews();
    }

    public Color getTextBackground() {
        if (this.modelBackgroundColor != null) {
            return this.modelBackgroundColor;
        }
        return this.getBackgroundColor();
    }

    public Color getTextColor() {
        Color color = NodeStyleController.getController(this.getMap().getModeController()).getColor(this.model);
        return color;
    }

    public int getVGap() {
        return this.map.getZoomed(LocationModel.getModel(this.model).getVGap());
    }

    public NodeView getVisibleParentView() {
        Container parent = this.getParent();
        if (!(parent instanceof NodeView)) {
            return null;
        }
        NodeView parentView = (NodeView)parent;
        if (parentView.isContentVisible()) {
            return parentView;
        }
        return parentView.getVisibleParentView();
    }

    public int getZoomedFoldingSymbolHalfWidth() {
        if (FOLDING_SYMBOL_WIDTH == -1) {
            FOLDING_SYMBOL_WIDTH = ResourceController.getResourceController().getIntProperty("foldingsymbolwidth", 8);
        }
        int preferredFoldingSymbolHalfWidth = (int)((float)FOLDING_SYMBOL_WIDTH * this.map.getZoom() / 2.0f);
        return preferredFoldingSymbolHalfWidth;
    }

    void addChildViews() {
        int index = 0;
        for (NodeModel child : this.getMap().getModeController().getMapController().childrenFolded(this.getModel())) {
            if (child.containsExtension(HideChildSubtree.class)) {
                return;
            }
            if (this.getComponentCount() > index && this.getComponent(index) instanceof NodeView) continue;
            this.addChildView(child, index++);
        }
    }

    void addChildView(NodeModel newNode, int index) {
        NodeViewFactory.getInstance().newNodeView(newNode, this.getMap(), this, index);
    }

    public boolean isChildOf(NodeView myNodeView) {
        return this.getParentView() == myNodeView;
    }

    public boolean isContentVisible() {
        return this.getModel().isVisible();
    }

    public boolean isLeft() {
        if (this.getMap().getLayoutType() == MapViewLayout.OUTLINE) {
            return false;
        }
        return this.getModel().isLeft();
    }

    public boolean isParentHidden() {
        Container parent = this.getParent();
        if (!(parent instanceof NodeView)) {
            return false;
        }
        NodeView parentView = (NodeView)parent;
        return !parentView.isContentVisible();
    }

    public boolean isParentOf(NodeView myNodeView) {
        return this == myNodeView.getParentView();
    }

    public boolean isRoot() {
        return this.getModel().isRoot();
    }

    public boolean isSelected() {
        return this.getMap().isSelected(this);
    }

    public boolean isSiblingOf(NodeView myNodeView) {
        return this.getParentView() == myNodeView.getParentView();
    }

    @Override
    public void mapChanged(MapChangeEvent event) {
    }

    @Override
    public void nodeChanged(NodeChangeEvent event) {
        NodeModel node = event.getNode();
        if (!node.isRoot() && node.getParent() == null) {
            return;
        }
        Object property = event.getProperty();
        if (property == NodeModel.NodeChangeType.FOLDING) {
            this.treeStructureChanged();
            this.getMap().selectIfSelectionIsEmpty(this);
            String shape = NodeStyleController.getController(this.getMap().getModeController()).getShape(this.model);
            if (shape.equals("combined")) {
                this.update();
            }
            return;
        }
        if (this.mainView == null) {
            return;
        }
        if (property.equals("icon") || property.equals("hierarchical_icons")) {
            this.mainView.updateIcons(this);
            this.revalidate();
            return;
        }
        if (property.equals("note_text")) {
            NodeViewFactory.getInstance().updateNoteViewer(this);
            this.mainView.updateIcons(this);
            return;
        }
        if (property.equals("SHORTENER")) {
            NodeViewFactory.getInstance().updateNoteViewer(this);
        }
        if (property.equals(HistoryInformationModel.class)) {
            return;
        }
        this.update();
        if (!this.isRoot()) {
            this.getParentView().numberingChanged(node.getParent().getIndex(node) + 1);
        }
    }

    @Override
    public void onNodeDeleted(NodeModel parent, NodeModel child, int index) {
        if (this.getMap().getModeController().getMapController().isFolded(this.model)) {
            return;
        }
        boolean preferredChildIsLeft = this.preferredChild != null && this.preferredChild.isLeft();
        NodeView node = (NodeView)this.getComponent(index);
        if (node == this.preferredChild) {
            NodeView candidate;
            Component c;
            int j;
            this.preferredChild = null;
            for (j = index + 1; j < this.getComponentCount() && (c = this.getComponent(j)) instanceof NodeView; ++j) {
                candidate = (NodeView)c;
                if (!candidate.isVisible() || node.isLeft() != candidate.isLeft()) continue;
                this.preferredChild = candidate;
                break;
            }
            if (this.preferredChild == null) {
                for (j = index - 1; j >= 0 && (c = this.getComponent(j)) instanceof NodeView; --j) {
                    candidate = (NodeView)c;
                    if (!candidate.isVisible() || node.isLeft() != candidate.isLeft()) continue;
                    this.preferredChild = candidate;
                    break;
                }
            }
        }
        this.numberingChanged(index + 1);
        node.remove();
        NodeView preferred = this.getPreferredVisibleChild(false, preferredChildIsLeft);
        if (preferred == null) {
            preferred = this;
        }
        if (this.getMap().getSelected() == null) {
            this.getMap().selectVisibleAncestorOrSelf(preferred);
        }
        this.revalidate();
    }

    @Override
    public void onNodeInserted(NodeModel parent, NodeModel child, int index) {
        assert (parent == this.model);
        if (this.getMap().getModeController().getMapController().isFolded(this.model)) {
            return;
        }
        this.addChildView(child, index);
        this.numberingChanged(index + 1);
        this.revalidate();
    }

    @Override
    public void onNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
    }

    @Override
    public void onPreNodeDelete(NodeModel oldParent, NodeModel child, int oldIndex) {
    }

    private void numberingChanged(int firstChangedIndex) {
        TextController textController = TextController.getController(this.getMap().getModeController());
        if (firstChangedIndex > 0 || textController.getNodeNumbering(this.getModel())) {
            Component[] components = this.getComponents();
            for (int i = firstChangedIndex; i < components.length; ++i) {
                NodeView view;
                MainView childMainView;
                if (!(components[i] instanceof NodeView) || (childMainView = (view = (NodeView)components[i]).getMainView()) == null) continue;
                childMainView.updateText(view.getModel());
                view.numberingChanged(0);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.getMainView() == null) {
            return;
        }
        PaintingMode paintingMode = this.map.getPaintingMode();
        if (this.isContentVisible()) {
            Graphics2D g2 = (Graphics2D)g;
            ModeController modeController = this.map.getModeController();
            Object renderingHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            switch (paintingMode) {
                case CLOUDS: {
                    modeController.getController().getMapViewManager().setEdgesRenderingHint(g2);
                    boolean isRoot = this.isRoot();
                    if (isRoot) {
                        this.paintCloud(g);
                    }
                    this.paintClouds(g2);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
                }
            }
            switch (paintingMode) {
                case NODES: {
                    g2.setStroke(BubbleMainView.DEF_STROKE);
                    modeController.getController().getMapViewManager().setEdgesRenderingHint(g2);
                    this.paintEdges(g2, this);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
                }
            }
        }
        if (PAINT_DEBUG_BORDER && this.isSelected() && paintingMode.equals((Object)PaintingMode.SELECTED_NODES)) {
            int spaceAround = this.getZoomed(50);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.drawRect(spaceAround - 1, spaceAround - 1, this.getWidth() - 2 * spaceAround, this.getHeight() - 2 * spaceAround);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintDecoration((Graphics2D)g);
    }

    private void paintCloud(Graphics g) {
        if (!this.isContentVisible()) {
            return;
        }
        CloudModel cloudModel = this.getCloudModel();
        if (cloudModel == null) {
            return;
        }
        CloudView cloud = new CloudViewFactory().createCloudView(cloudModel, this);
        cloud.paint(g);
    }

    private void paintClouds(Graphics2D g) {
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (!(component instanceof NodeView)) continue;
            NodeView nodeView = (NodeView)component;
            Point p = new Point();
            UITools.convertPointToAncestor((Component)nodeView, p, this);
            g.translate(p.x, p.y);
            if (nodeView.isContentVisible()) {
                nodeView.paintCloud(g);
            } else {
                nodeView.paintClouds(g);
            }
            g.translate(-p.x, -p.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintEdges(Graphics2D g, NodeView source) {
        int step;
        int end;
        int start;
        SummaryEdgePainter rightSummaryEdgePainter;
        SummaryEdgePainter summaryEdgePainter = new SummaryEdgePainter(this, this.isRoot() ? true : this.isLeft());
        SummaryEdgePainter summaryEdgePainter2 = rightSummaryEdgePainter = this.isRoot() ? new SummaryEdgePainter(this, false) : null;
        if (this.getMap().getLayoutType() == MapViewLayout.OUTLINE) {
            start = this.getComponentCount() - 1;
            end = -1;
            step = -1;
        } else {
            start = 0;
            end = this.getComponentCount();
            step = 1;
        }
        for (int i = start; i != end; i += step) {
            Component component = this.getComponent(i);
            if (!(component instanceof NodeView)) continue;
            NodeView nodeView = (NodeView)component;
            if (this.getMap().getLayoutType() != MapViewLayout.OUTLINE) {
                SummaryEdgePainter activePainter = nodeView.isLeft() || !this.isRoot() ? summaryEdgePainter : rightSummaryEdgePainter;
                activePainter.addChild(nodeView);
                if (activePainter.paintSummaryEdge(g, source, nodeView)) {
                    if (nodeView.isContentVisible()) continue;
                    Rectangle bounds = SwingUtilities.convertRectangle(this, nodeView.getBounds(), source);
                    Graphics cg = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
                    try {
                        nodeView.paintEdges((Graphics2D)cg, nodeView);
                        continue;
                    }
                    finally {
                        cg.dispose();
                    }
                }
            }
            if (nodeView.isContentVisible()) {
                EdgeView edge = EdgeViewFactory.getInstance().getEdge(source, nodeView, source);
                edge.paint(g);
                continue;
            }
            nodeView.paintEdges(g, source);
        }
    }

    int getSpaceAround() {
        return this.getZoomed(50);
    }

    public int getZoomed(int x) {
        return this.getMap().getZoomed(x);
    }

    private void paintDecoration(Graphics2D g) {
        PaintingMode paintingMode = this.map.getPaintingMode();
        if (!(this.getMainView() != null && (paintingMode.equals((Object)PaintingMode.NODES) && !this.isSelected() || paintingMode.equals((Object)PaintingMode.SELECTED_NODES) && this.isSelected()) && this.isContentVisible())) {
            return;
        }
        Graphics2D g2 = g;
        ModeController modeController = this.map.getModeController();
        Object renderingHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setStroke(BubbleMainView.DEF_STROKE);
        modeController.getController().getMapViewManager().setEdgesRenderingHint(g2);
        Point origin = new Point();
        UITools.convertPointToAncestor((Component)this.mainView, origin, this);
        g.translate(origin.x, origin.y);
        this.mainView.paintDecoration(this, g);
        g.translate(-origin.x, -origin.y);
        FilterController filterController = FilterController.getController(this.getMap().getModeController().getController());
        if (filterController.isNodeHighlighted(this.getModel())) {
            Color oldColor = g.getColor();
            Stroke oldStroke = g.getStroke();
            g.setColor(Color.MAGENTA);
            g.setStroke(this.getMap().getStandardSelectionStroke());
            JComponent content = this.getContent();
            Point contentLocation = content.getLocation();
            int arcWidth = 8;
            g.drawRoundRect(contentLocation.x - 8, contentLocation.y - 8, content.getWidth() + 16, content.getHeight() + 16, 15, 15);
            g.setColor(oldColor);
            g.setStroke(oldStroke);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
    }

    void remove() {
        ListIterator e = this.getChildrenViews().listIterator();
        while (e.hasNext()) {
            ((NodeView)e.next()).remove();
        }
        this.getMap().deselect(this);
        this.getMap().getModeController().onViewRemoved(this);
        this.removeFromMap();
        if (this.attributeView != null) {
            this.attributeView.viewRemoved();
        }
        this.getModel().removeViewer(this);
    }

    protected void removeFromMap() {
        this.setFocusCycleRoot(false);
        Container parent = this.getParent();
        parent.remove(this);
    }

    private void repaintEdge(NodeView target) {
        if (target.getMap().getLayoutType() == MapViewLayout.OUTLINE) {
            target.getVisibleParentView().repaint();
            return;
        }
        Point relativeLocation = this.getRelativeLocation(target);
        MainView targetMainView = target.getMainView();
        relativeLocation.x += targetMainView.getWidth() / 2;
        relativeLocation.y += targetMainView.getHeight() / 2;
        Point inPoint = this.mainView.getConnectorPoint(relativeLocation);
        UITools.convertPointToAncestor((Component)targetMainView, inPoint, this);
        relativeLocation.x -= targetMainView.getWidth() / 2;
        relativeLocation.y -= targetMainView.getHeight() / 2;
        relativeLocation.x = -relativeLocation.x + this.mainView.getWidth() / 2;
        relativeLocation.y = -relativeLocation.y + this.mainView.getHeight() / 2;
        Point outPoint = targetMainView.getConnectorPoint(relativeLocation);
        UITools.convertPointToAncestor((Component)this.getMainView(), outPoint, this);
        int x = Math.min(inPoint.x, outPoint.x);
        int y = Math.min(inPoint.y, outPoint.y);
        int w = Math.abs(inPoint.x - outPoint.x);
        int h = Math.abs(inPoint.y - outPoint.y);
        int EXTRA = 50;
        this.repaint(x - 50, y - 50, w + 100, h + 100);
    }

    void repaintSelected() {
        NodeView visibleParentView;
        if (this.mainView == null) {
            return;
        }
        if (this.model.getParentNode() == null && !this.model.isRoot()) {
            return;
        }
        if (this.getEdgeStyle().equals((Object)EdgeStyle.EDGESTYLE_HIDDEN) && (visibleParentView = this.getVisibleParentView()) != null) {
            visibleParentView.repaintEdge(this);
        }
        JComponent content = this.getContent();
        int EXTRA = 20;
        int x = content.getX() - 20;
        int y = content.getY() - 20;
        this.repaint(x, y, content.getWidth() + 40, content.getHeight() + 40);
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.mainView == null) {
            return false;
        }
        if (this.mainView.requestFocusInWindow()) {
            this.getMap().scrollNodeToVisible(this);
            Controller.getCurrentController().getViewController().addObjectTypeInfo(this.getModel().getUserObject());
            return true;
        }
        return false;
    }

    @Override
    public void requestFocus() {
        if (this.mainView == null) {
            return;
        }
        this.getMap().scrollNodeToVisible(this);
        Controller.getCurrentController().getViewController().addObjectTypeInfo(this.getModel().getUserObject());
        this.mainView.requestFocus();
    }

    void setMainView(MainView newMainView) {
        if (this.contentPane != null) {
            assert (this.contentPane.getParent() == this);
            if (this.mainView != null) {
                this.removeContent(1);
            }
            this.addContent(newMainView, 1);
            assert (this.contentPane.getParent() == this);
        } else if (this.mainView != null) {
            int i;
            Container c = this.mainView.getParent();
            for (i = c.getComponentCount() - 1; i >= 0 && this.mainView != c.getComponent(i); --i) {
            }
            c.remove(i);
            c.add((Component)newMainView, i);
        } else {
            this.add(newMainView);
        }
        this.mainView = newMainView;
        IUserInputListenerFactory userInputListenerFactory = this.getMap().getModeController().getUserInputListenerFactory();
        this.mainView.addMouseListener(userInputListenerFactory.getNodeMouseMotionListener());
        this.mainView.addMouseMotionListener(userInputListenerFactory.getNodeMouseMotionListener());
        this.mainView.addKeyListener(userInputListenerFactory.getNodeKeyListener());
        this.addDragListener(userInputListenerFactory.getNodeDragListener());
        this.addDropListener(userInputListenerFactory.getNodeDropTargetListener());
    }

    protected void setModel(NodeModel model) {
        this.model = model;
    }

    public void setPreferredChild(NodeView view) {
        if (view != null && !SummaryNode.isSummaryNode(view.getModel())) {
            this.preferredChild = view;
        }
        Container parent = this.getParent();
        if (view == null) {
            return;
        }
        if (parent instanceof NodeView) {
            ((NodeView)parent).setPreferredChild(this);
        }
    }

    public void setText(String string) {
        this.mainView.setText(string);
    }

    void syncronizeAttributeView() {
        if (this.attributeView != null) {
            this.attributeView.syncronizeAttributeView();
        }
    }

    @Override
    public String toString() {
        return this.getModel().toString() + ", " + super.toString();
    }

    private void treeStructureChanged() {
        ListIterator i = this.getChildrenViews().listIterator();
        while (i.hasNext()) {
            ((NodeView)i.next()).remove();
        }
        this.addChildViews();
        this.map.revalidateSelecteds();
        this.revalidate();
    }

    public void update() {
        boolean textShortened;
        this.updateShape();
        this.updateEdge();
        if (!this.isContentVisible()) {
            this.mainView.setVisible(false);
            return;
        }
        this.mainView.setVisible(true);
        this.mainView.updateTextColor(this);
        this.mainView.updateFont(this);
        this.createAttributeView();
        if (this.attributeView != null) {
            this.attributeView.update();
        }
        if (!(textShortened = this.isShortened())) {
            NodeViewFactory.getInstance().updateDetails(this);
            if (this.contentPane != null) {
                int componentCount = this.contentPane.getComponentCount();
                for (int i = 1; i < componentCount; ++i) {
                    Component component = this.contentPane.getComponent(i);
                    if (!(component instanceof JComponent)) continue;
                    ((JComponent)component).revalidate();
                }
            }
        }
        this.updateShortener(this.getModel(), textShortened);
        this.mainView.updateIcons(this);
        this.mainView.updateText(this.getModel());
        this.updateCloud();
        this.modelBackgroundColor = NodeStyleController.getController(this.getMap().getModeController()).getBackgroundColor(this.model);
        this.revalidate();
    }

    public boolean isShortened() {
        ModeController modeController = this.getMap().getModeController();
        TextController textController = TextController.getController(modeController);
        boolean textShortened = textController.isMinimized(this.getModel());
        return textShortened;
    }

    private void updateEdge() {
        EdgeController edgeController = EdgeController.getController(this.getMap().getModeController());
        this.edgeStyle = edgeController.getStyle(this.model, false);
        this.edgeWidth = edgeController.getWidth(this.model, false);
        this.edgeColor = edgeController.getColor(this.model, false);
    }

    public EdgeStyle getEdgeStyle() {
        if (this.edgeStyle != null) {
            return this.edgeStyle;
        }
        NodeView parentView = this.getParentView();
        if (parentView != null) {
            return parentView.getEdgeStyle();
        }
        return EdgeStyle.values()[0];
    }

    public int getEdgeWidth() {
        if (this.edgeWidth != null) {
            return this.edgeWidth;
        }
        NodeView parentView = this.getParentView();
        if (parentView != null) {
            return parentView.getEdgeWidth();
        }
        return 1;
    }

    public Color getEdgeColor() {
        if (this.edgeColor != null) {
            return this.edgeColor;
        }
        NodeView parentView = this.getParentView();
        if (parentView != null) {
            return parentView.getEdgeColor();
        }
        return Color.GRAY;
    }

    private void updateCloud() {
        CloudModel cloudModel = CloudController.getController(this.getMap().getModeController()).getCloud(this.model);
        this.putClientProperty(CloudModel.class, cloudModel);
    }

    public CloudModel getCloudModel() {
        return (CloudModel)this.getClientProperty(CloudModel.class);
    }

    private void updateShortener(NodeModel nodeModel, boolean textShortened) {
        boolean componentsVisible = !textShortened;
        this.setContentComponentVisible(componentsVisible);
    }

    private void setContentComponentVisible(boolean componentsVisible) {
        if (this.contentPane == null) {
            return;
        }
        Component[] components = this.getContentPane().getComponents();
        for (int index = 0; index < components.length; ++index) {
            Component component = components[index];
            if (component == this.getMainView() || component.isVisible() == componentsVisible) continue;
            component.setVisible(componentsVisible);
        }
    }

    public void updateAll() {
        NodeViewFactory.getInstance().updateNoteViewer(this);
        this.update();
        this.invalidate();
        for (NodeView child : this.getChildrenViews()) {
            child.updateAll();
        }
    }

    private void updateShape() {
        MainView newMainView;
        String newShape = NodeStyleController.getController(this.getMap().getModeController()).getShape(this.model);
        String oldShape = this.mainView != null ? this.mainView.getShape() : null;
        if (this.mainView != null) {
            if (oldShape.equals(newShape)) {
                return;
            }
            if (this.model.isRoot()) {
                if (newShape != null) {
                    ((RootMainView)this.mainView).setShape(newShape);
                }
                return;
            }
        }
        if ((newMainView = NodeViewFactory.getInstance().newMainView(this)).getShape().equals(oldShape)) {
            return;
        }
        this.setMainView(newMainView);
        if (this.map.getSelected() == this) {
            this.requestFocusInWindow();
        }
    }

    boolean useSelectionColors() {
        return this.isSelected() && !MapView.standardDrawRectangleForSelection && !this.map.isPrinting();
    }

    @Override
    public void onPreNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
    }

    @Override
    protected void validateTree() {
        super.validateTree();
    }

    public void addContent(JComponent component, int pos) {
        component.putClientProperty("NODE_VIEW_CONTENT_POSITION", pos);
        Container contentPane = this.getContentPane();
        for (int i = 0; i < contentPane.getComponentCount(); ++i) {
            JComponent content = (JComponent)contentPane.getComponent(i);
            if (content == null) {
                throw new RuntimeException("component " + i + "is null");
            }
            Object clientProperty = content.getClientProperty("NODE_VIEW_CONTENT_POSITION");
            if (clientProperty == null) {
                throw new RuntimeException("NODE_VIEW_CONTENT_POSITION not set on component " + content.toString() + i + "/" + contentPane.getComponentCount());
            }
            if (pos >= (Integer)clientProperty) continue;
            contentPane.add((Component)component, i);
            return;
        }
        contentPane.add(component);
    }

    public JComponent removeContent(int pos) {
        return this.removeContent(pos, true);
    }

    private JComponent removeContent(int pos, boolean remove) {
        if (this.contentPane == null) {
            return null;
        }
        for (int i = 0; i < this.contentPane.getComponentCount(); ++i) {
            JComponent component = (JComponent)this.contentPane.getComponent(i);
            Integer contentPos = (Integer)component.getClientProperty("NODE_VIEW_CONTENT_POSITION");
            if (contentPos == null) continue;
            if (contentPos == pos) {
                if (remove) {
                    component.putClientProperty("NODE_VIEW_CONTENT_POSITION", null);
                    this.contentPane.remove(i);
                }
                return component;
            }
            if (contentPos <= pos) continue;
            return null;
        }
        return null;
    }

    public JComponent getContent(int pos) {
        return this.removeContent(pos, false);
    }

    public boolean isSummary() {
        return SummaryNode.isSummaryNode(this.getModel());
    }

    public boolean isFirstGroupNode() {
        return SummaryNode.isFirstGroupNode(this.getModel());
    }

    public boolean isFree() {
        return FreeNode.isFreeNode(this.getModel());
    }

    public Color getDetailBackground() {
        Color detailBackground = this.getMap().getDetailBackground();
        return detailBackground;
    }

    int getTopOverlap() {
        return this.topOverlap;
    }

    void setTopOverlap(int topOverlap) {
        this.topOverlap = topOverlap;
    }

    int getBottomOverlap() {
        return this.bottomOverlap;
    }

    void setBottomOverlap(int bottomOverlap) {
        this.bottomOverlap = bottomOverlap;
    }

    static {
        boolean paintDebugBorder = false;
        try {
            paintDebugBorder = Boolean.getBoolean("org.freeplane.view.swing.map.NodeView.PAINT_DEBUG_BORDER");
        }
        catch (Exception exception) {
            // empty catch block
        }
        PAINT_DEBUG_BORDER = paintDebugBorder;
        ADDITIONAL_MOUSE_SENSITIVE_AREA = 50;
    }
}

