/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlException;
import javax.swing.JEditorPane;
import javax.swing.JToolTip;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.ui.components.JRestrictedSizeScrollPane;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.html.ScaledEditorKit;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.url.UrlManager;

public class NodeTooltip
extends JToolTip {
    private final JEditorPane tip = new JEditorPane();
    private static int maximumWidth = Integer.MAX_VALUE;

    public NodeTooltip() {
        this.tip.setContentType("text/html");
        this.tip.putClientProperty("JEditorPane.honorDisplayProperties", false);
        ScaledEditorKit kit = ScaledEditorKit.create();
        this.tip.setEditorKit(kit);
        this.tip.setEditable(false);
        this.tip.setMargin(new Insets(0, 0, 0, 0));
        LinkMouseListener linkMouseListener = new LinkMouseListener();
        this.tip.addMouseListener(linkMouseListener);
        this.tip.addMouseMotionListener(linkMouseListener);
        HTMLDocument document = (HTMLDocument)this.tip.getDocument();
        StyleSheet styleSheet = document.getStyleSheet();
        styleSheet.removeStyle("p");
        styleSheet.removeStyle("body");
        styleSheet.addRule("p {margin-top:0;}\n");
        JRestrictedSizeScrollPane scrollPane = new JRestrictedSizeScrollPane(this.tip);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, maximumWidth / 2));
        scrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                NodeTooltip.this.revalidate();
            }
        });
        UITools.setScrollbarIncrement(scrollPane);
        this.add(scrollPane);
        this.tip.setOpaque(false);
    }

    public static void setMaximumWidth(int width) {
        maximumWidth = width;
    }

    public void setTipText(String tipText) {
        try {
            this.setTipTextUnsafe(tipText);
        }
        catch (Exception e1) {
            if (e1 instanceof AccessControlException) {
                LogUtils.warn(e1.getMessage());
            } else {
                LogUtils.severe(e1);
            }
            String localizedMessage = e1.getLocalizedMessage();
            String htmlEscapedText = HtmlUtils.plainToHTML(localizedMessage + '\n' + tipText);
            try {
                this.setTipTextUnsafe(htmlEscapedText);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    private void setTipTextUnsafe(String tipText) throws Exception {
        this.tip.setSize(0, 0);
        this.tip.setPreferredSize(null);
        this.tip.setText(tipText);
        Dimension preferredSize = this.tip.getPreferredSize();
        if (preferredSize.width < maximumWidth) {
            this.tip.setPreferredSize(preferredSize);
            return;
        }
        HTMLDocument document = (HTMLDocument)this.tip.getDocument();
        document.getStyleSheet().addRule("body { width: " + maximumWidth + "}");
        this.tip.setEditable(true);
        this.tip.setEditable(false);
        this.tip.setPreferredSize(this.tip.getPreferredSize());
    }

    public Dimension getPreferredSize() {
        Component scrollPane = this.getComponent(0);
        return scrollPane.getPreferredSize();
    }

    public void layout() {
        Component scrollPane = this.getComponent(0);
        scrollPane.setSize(this.getPreferredSize());
        super.layout();
    }

    void scrollUp() {
        this.tip.scrollRectToVisible(new Rectangle(1, 1));
    }

    public void setBase(URL url) {
        ((HTMLDocument)this.tip.getDocument()).setBase(url);
    }

    class LinkMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        LinkMouseListener() {
        }

        public void mouseMoved(MouseEvent ev) {
            int requiredCursor;
            String link = HtmlUtils.getURLOfExistingLink((HTMLDocument)NodeTooltip.this.tip.getDocument(), NodeTooltip.this.tip.viewToModel(ev.getPoint()));
            boolean followLink = link != null;
            Controller currentController = Controller.getCurrentController();
            if (followLink) {
                currentController.getViewController().out(link);
                requiredCursor = 12;
            } else {
                requiredCursor = 0;
            }
            if (NodeTooltip.this.tip.getCursor().getType() != requiredCursor) {
                NodeTooltip.this.tip.setCursor(requiredCursor != 0 ? new Cursor(requiredCursor) : null);
            }
        }

        public void mouseClicked(MouseEvent ev) {
            String linkURL;
            if (Compat.isPlainEvent(ev) && (linkURL = HtmlUtils.getURLOfExistingLink((HTMLDocument)NodeTooltip.this.tip.getDocument(), NodeTooltip.this.tip.viewToModel(ev.getPoint()))) != null) {
                try {
                    UrlManager.getController().loadURL(new URI(linkURL));
                }
                catch (Exception e) {
                    LogUtils.warn(e);
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
        }
    }
}

