/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

public class MindMapLayout
implements LayoutManager {
    static final int BORDER = 30;
    public static final int MINIMAL_LEAF_WIDTH = 150;

    public void addLayoutComponent(String name, Component comp) {
    }

    private int calcXBorderSize(MapView map) {
        Dimension visibleSize = map.getViewportSize();
        int minBorderWidth = map.getZoomed(180);
        int xBorderSize = visibleSize != null ? Math.max(visibleSize.width, minBorderWidth) : minBorderWidth;
        return xBorderSize;
    }

    private int calcYBorderSize(MapView map) {
        int minBorderHeight = map.getZoomed(30);
        Dimension visibleSize = map.getViewportSize();
        int yBorderSize = visibleSize != null ? Math.max(visibleSize.height, minBorderHeight) : minBorderHeight;
        return yBorderSize;
    }

    private NodeView getRoot(Container c) {
        return ((MapView)c).getRoot();
    }

    public void layoutContainer(Container c) {
        MapView mapView = (MapView)c;
        int calcXBorderSize = this.calcXBorderSize(mapView);
        int calcYBorderSize = this.calcYBorderSize(mapView);
        this.getRoot(mapView).validate();
        this.getRoot(mapView).setLocation(calcXBorderSize, calcYBorderSize);
        mapView.setSize(calcXBorderSize * 2 + this.getRoot(mapView).getWidth(), calcYBorderSize * 2 + this.getRoot(mapView).getHeight());
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(200, 200);
    }

    public Dimension preferredLayoutSize(Container c) {
        MapView mapView = (MapView)c;
        Dimension preferredSize = mapView.getRoot().getPreferredSize();
        return new Dimension(2 * this.calcXBorderSize(mapView) + preferredSize.width, 2 * this.calcYBorderSize(mapView) + preferredSize.height);
    }

    public void removeLayoutComponent(Component comp) {
    }
}

