/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Timer;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.mode.Controller;

public class MapViewScrollPane
extends JScrollPane
implements IFreeplanePropertyListener {
    private static final long serialVersionUID = 1L;

    public MapViewScrollPane() {
        this.setViewport(new MapViewPort());
    }

    public void addNotify() {
        super.addNotify();
        this.setScrollbarsVisiblilty();
        UITools.setScrollbarIncrement(this);
        ResourceController.getResourceController().addPropertyChangeListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        ResourceController.getResourceController().removePropertyChangeListener(this);
    }

    protected void validateTree() {
        Component view = this.getViewport().getView();
        if (view != null) {
            view.validate();
        }
        super.validateTree();
    }

    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if ("fullscreen_enabled".equals(propertyName) || propertyName.startsWith("scrollbarsVisible")) {
            this.setScrollbarsVisiblilty();
        } else if (propertyName.equals("scrollbar_increment")) {
            int scrollbarIncrement = Integer.valueOf(newValue);
            this.getHorizontalScrollBar().setUnitIncrement(scrollbarIncrement);
            this.getVerticalScrollBar().setUnitIncrement(scrollbarIncrement);
        }
    }

    private void setScrollbarsVisiblilty() {
        boolean areScrollbarsVisible = Controller.getCurrentController().getViewController().areScrollbarsVisible();
        this.setHorizontalScrollBarPolicy(areScrollbarsVisible ? 32 : 31);
        this.setVerticalScrollBarPolicy(areScrollbarsVisible ? 22 : 21);
    }

    static class MapViewPort
    extends JViewport {
        private Timer timer;

        MapViewPort() {
        }

        public void setViewPosition(Point p) {
            boolean scrollingToVisible = Boolean.TRUE.equals(this.getClientProperty("slowScrolling"));
            if (scrollingToVisible) {
                this.putClientProperty("slowScrolling", null);
                this.slowSetViewPosition(p);
            } else {
                super.setViewPosition(p);
            }
        }

        private void slowSetViewPosition(final Point p) {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            Point viewPosition = this.getViewPosition();
            int dx = p.x - viewPosition.x;
            int dy = p.y - viewPosition.y;
            int slowDx = this.calcScrollIncrement(dx);
            int slowDy = this.calcScrollIncrement(dy);
            viewPosition.translate(slowDx, slowDy);
            super.setViewPosition(viewPosition);
            if (slowDx == dx && slowDy == dy) {
                return;
            }
            this.timer = new Timer(20, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MapViewPort.this.timer = null;
                    MapViewPort.this.slowSetViewPosition(p);
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
        }

        private int calcScrollIncrement(int dx) {
            int v = ResourceController.getResourceController().getIntProperty("scrolling_speed");
            int slowDX = (int)((double)v / 5.0 * Math.sqrt(Math.abs(dx)));
            if (Math.abs(dx) > 2 && slowDX < Math.abs(dx)) {
                dx = slowDX * Integer.signum(dx);
            }
            return dx;
        }
    }
}

