/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.view.swing.map.ClickableImageCreator;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MapViewChangeObserverCompound;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ZoomInAction;
import org.freeplane.view.swing.map.ZoomOutAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapViewController
implements IMapViewManager,
IMapViewChangeListener,
IFreeplanePropertyListener {
    private String lastModeName;
    private MapView selectedMapView;
    MapViewChangeObserverCompound mapViewChangeListeners = new MapViewChangeObserverCompound();
    private final Vector<MapView> mapViewVector = new Vector();
    private float zoom;
    private boolean setZoomComboBoxRun;
    private final Controller controller;
    private final String userDefinedZoom;
    private final ZoomInAction zoomIn;
    private final DefaultComboBoxModel zoomModel;
    private final ZoomOutAction zoomOut;
    private static final String[] zooms = new String[]{"25%", "50%", "75%", "100%", "150%", "200%", "300%", "400%"};
    private boolean antialiasAll = false;
    private boolean antialiasEdges = false;

    public MapViewController(Controller controller) {
        this.controller = controller;
        controller.setMapViewManager(this);
        this.addMapViewChangeListener(this);
        this.zoomIn = new ZoomInAction(this);
        controller.addAction(this.zoomIn);
        this.zoomOut = new ZoomOutAction(this);
        controller.addAction(this.zoomOut);
        this.userDefinedZoom = TextUtils.getText("user_defined_zoom");
        this.zoomModel = new DefaultComboBoxModel<String>(this.getZooms());
        this.zoomModel.addElement(this.userDefinedZoom);
        ResourceController resourceController = ResourceController.getResourceController();
        resourceController.addPropertyChangeListener(this);
        this.zoomModel.setSelectedItem("100%");
        this.zoomModel.addListDataListener(new ListDataListener(){

            public void intervalRemoved(ListDataEvent e) {
            }

            public void intervalAdded(ListDataEvent e) {
            }

            public void contentsChanged(ListDataEvent e) {
                if (!MapViewController.this.setZoomComboBoxRun && e.getIndex0() == -1) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            MapViewController.this.setZoomByItem(MapViewController.this.zoomModel.getSelectedItem());
                        }
                    });
                }
            }
        });
        String antialiasProperty = resourceController.getProperty("antialias");
        this.changeAntialias(antialiasProperty);
    }

    @Override
    public void addMapSelectionListener(IMapSelectionListener pListener) {
        this.mapViewChangeListeners.addListener(pListener);
    }

    @Override
    public void addMapViewChangeListener(IMapViewChangeListener pListener) {
        this.mapViewChangeListeners.addListener(pListener);
    }

    private void addToOrChangeInMapViews(String key, MapView newOrChangedMapView) {
        String extension = "";
        int count = 1;
        List<String> mapKeys = this.getMapKeys();
        while (mapKeys.contains(key + extension)) {
            extension = "<" + ++count + ">";
        }
        newOrChangedMapView.setName(key + extension);
        newOrChangedMapView.setName(key + extension);
        if (!this.mapViewVector.contains(newOrChangedMapView)) {
            this.mapViewVector.add(newOrChangedMapView);
        }
    }

    @Override
    public boolean changeToMapView(Component newMapViewComponent) {
        MapView newMapView = (MapView)newMapViewComponent;
        MapView oldMapView = this.selectedMapView;
        if (newMapView == oldMapView) {
            return true;
        }
        this.mapViewChangeListeners.beforeMapViewChange(oldMapView, newMapView);
        this.selectedMapView = newMapView;
        if (this.selectedMapView != null) {
            this.selectedMapView.revalidateSelecteds();
            ModeController modeController = this.selectedMapView.getModeController();
            this.lastModeName = modeController.getModeName();
            float mapViewZoom = this.selectedMapView.getZoom();
            if (this.zoom != mapViewZoom) {
                this.setZoom(mapViewZoom);
            }
            modeController.getController().selectMode(modeController);
        }
        this.mapViewChangeListeners.afterMapViewChange(oldMapView, newMapView);
        return true;
    }

    @Override
    public boolean changeToMapView(String mapViewDisplayName) {
        MapView mapViewCandidate = null;
        for (MapView mapView : this.mapViewVector) {
            String mapViewName = mapView.getName();
            if (mapViewDisplayName != mapViewName && (mapViewDisplayName == null || !mapViewDisplayName.equals(mapViewName))) continue;
            mapViewCandidate = mapView;
            break;
        }
        if (mapViewCandidate == null) {
            throw new IllegalArgumentException("Map mapView " + mapViewDisplayName + " not found.");
        }
        return this.changeToMapView(mapViewCandidate);
    }

    @Override
    public boolean changeToMode(String modeName) {
        if (modeName.equals(this.lastModeName)) {
            return true;
        }
        MapView mapViewCandidate = null;
        for (MapView mapView : this.mapViewVector) {
            if (!modeName.equals(mapView.getModeController().getModeName())) continue;
            mapViewCandidate = mapView;
            break;
        }
        MapView oldMapView = this.selectedMapView;
        boolean changed = this.changeToMapView(mapViewCandidate);
        if (changed) {
            this.lastModeName = modeName;
            if (oldMapView == this.selectedMapView) {
                this.mapViewChangeListeners.afterMapViewChange(oldMapView, this.selectedMapView);
            }
        }
        return changed;
    }

    @Override
    public String checkIfFileIsAlreadyOpened(URL urlToCheck) throws MalformedURLException {
        for (MapView mapView : this.mapViewVector) {
            URL mapViewUrl;
            if (this.getModel(mapView) == null || !this.sameFile(urlToCheck, mapViewUrl = this.getModel(mapView).getURL())) continue;
            return mapView.getName();
        }
        return null;
    }

    @Override
    public boolean close(boolean force) {
        MapView mapView = this.getMapView();
        return this.close(mapView, force);
    }

    @Override
    public boolean close(Component mapViewComponent, boolean force) {
        if (mapViewComponent == null) {
            return false;
        }
        MapView mapView = (MapView)mapViewComponent;
        MapController mapController = mapView.getModeController().getMapController();
        boolean closingNotCancelled = mapController.close(mapView.getModel(), force);
        if (!closingNotCancelled) {
            return false;
        }
        int index = this.mapViewVector.indexOf(mapView);
        mapController.removeMapChangeListener(mapView);
        ResourceController.getResourceController().removePropertyChangeListener(mapView);
        this.mapViewVector.remove(mapView);
        if (this.mapViewVector.isEmpty()) {
            this.changeToMapView((Component)null);
        } else if (mapView == this.selectedMapView) {
            if (index >= this.mapViewVector.size() || index < 0) {
                index = this.mapViewVector.size() - 1;
            }
            this.changeToMapView(this.mapViewVector.get(index));
        }
        this.mapViewChangeListeners.afterMapViewClose(mapView);
        mapView.getRoot().remove();
        return true;
    }

    @Override
    public String createHtmlMap() {
        MapModel model = this.getModel();
        ClickableImageCreator creator = new ClickableImageCreator(model.getRootNode(), this.getMapView().getModeController(), "FM$1FM");
        return creator.generateHtml();
    }

    @Override
    public RenderedImage createImage(int dpi) {
        MapView view = this.getMapView();
        if (view == null) {
            return null;
        }
        view.preparePrinting();
        Rectangle innerBounds = view.getInnerBounds();
        boolean BOUND = true;
        --innerBounds.x;
        --innerBounds.y;
        innerBounds.width += 2;
        innerBounds.height += 2;
        double scaleFactor = (double)dpi / (double)UITools.getScreenResolution();
        int imageWidth = (int)Math.ceil((double)innerBounds.width * scaleFactor);
        int imageHeight = (int)Math.ceil((double)innerBounds.height * scaleFactor);
        BufferedImage myImage = (BufferedImage)view.createImage(imageWidth, imageHeight);
        Graphics2D g = (Graphics2D)myImage.getGraphics();
        g.scale(scaleFactor, scaleFactor);
        g.translate(-innerBounds.x, -innerBounds.y);
        view.print(g);
        view.endPrinting();
        return myImage;
    }

    @Override
    public Color getBackgroundColor(NodeModel node) {
        MapView mapView = this.getMapView();
        if (mapView == null) {
            return null;
        }
        NodeView nodeView = mapView.getNodeView(node);
        if (nodeView == null) {
            return null;
        }
        return nodeView.getTextBackground();
    }

    @Override
    public Component getComponent(NodeModel node) {
        if (this.selectedMapView == null) {
            return null;
        }
        NodeView nodeView = this.selectedMapView.getNodeView(node);
        if (nodeView == null) {
            return null;
        }
        return nodeView.getMainView();
    }

    @Override
    public Font getFont(NodeModel node) {
        MapView mapView = this.getMapView();
        if (mapView == null) {
            return null;
        }
        NodeView nodeView = mapView.getNodeView(node);
        if (nodeView == null) {
            return null;
        }
        return nodeView.getMainView().getFont();
    }

    @Override
    public List<String> getMapKeys() {
        LinkedList<String> returnValue = new LinkedList<String>();
        for (MapView mapView : this.mapViewVector) {
            returnValue.add(mapView.getName());
        }
        return Collections.unmodifiableList(returnValue);
    }

    @Override
    public Map<String, MapModel> getMaps() {
        HashMap<String, MapModel> returnValue = new HashMap<String, MapModel>(this.mapViewVector.size());
        for (MapView mapView : this.mapViewVector) {
            returnValue.put(mapView.getName(), this.getModel(mapView));
        }
        return Collections.unmodifiableMap(returnValue);
    }

    @Override
    public IMapSelection getMapSelection() {
        MapView mapView = this.getMapView();
        return mapView == null ? null : mapView.getMapSelection();
    }

    public MapView getMapView() {
        return this.selectedMapView;
    }

    @Override
    public Component getMapViewComponent() {
        return this.getMapView();
    }

    public List<MapView> getMapViewVector() {
        return Collections.unmodifiableList(this.mapViewVector);
    }

    @Override
    public ModeController getModeController(Component mapView) {
        return ((MapView)mapView).getModeController();
    }

    @Override
    public MapModel getModel() {
        MapView mapView = this.getMapView();
        return mapView == null ? null : this.getModel(mapView);
    }

    @Override
    public MapModel getModel(Component mapView) {
        return ((MapView)mapView).getModel();
    }

    private MapModel getModel(MapView mapView) {
        return mapView == null ? null : mapView.getModel();
    }

    @Override
    public Component getSelectedComponent() {
        MapView mapView = this.getMapView();
        return mapView == null ? null : mapView.getSelected();
    }

    @Override
    public Color getTextColor(NodeModel node) {
        MapView mapView = this.getMapView();
        if (mapView == null) {
            return null;
        }
        NodeView nodeView = mapView.getNodeView(node);
        if (nodeView == null) {
            return null;
        }
        return nodeView.getTextColor();
    }

    public int getViewNumber() {
        return this.mapViewVector.size();
    }

    @Override
    public float getZoom() {
        return this.zoom;
    }

    @Override
    public void newMapView(MapModel map, ModeController modeController) {
        MapView mapView = new MapView(map, modeController);
        this.addToOrChangeInMapViews(mapView.getName(), mapView);
        modeController.getMapController().addMapChangeListener(mapView);
        ResourceController.getResourceController().addPropertyChangeListener(mapView);
        this.mapViewChangeListeners.mapViewCreated(mapView);
        this.changeToMapView(mapView);
    }

    @Override
    public void nextMapView() {
        int size = this.mapViewVector.size();
        int index = this.getMapView() != null ? this.mapViewVector.indexOf(this.getMapView()) : size - 1;
        if (index + 1 < size && index >= 0) {
            this.changeToMapView(this.mapViewVector.get(index + 1));
        } else if (size > 0) {
            this.changeToMapView(this.mapViewVector.get(0));
        }
    }

    @Override
    public void previousMapView() {
        int size = this.mapViewVector.size();
        int index = this.getMapView() != null ? this.mapViewVector.indexOf(this.getMapView()) : 0;
        if (index > 0) {
            this.changeToMapView(this.mapViewVector.get(index - 1));
        } else if (size > 0) {
            this.changeToMapView(this.mapViewVector.get(size - 1));
        }
    }

    @Override
    public void removeMapSelectionListener(IMapSelectionListener pListener) {
        this.mapViewChangeListeners.removeListener(pListener);
    }

    @Override
    public void removeMapViewChangeListener(IMapViewChangeListener pListener) {
        this.mapViewChangeListeners.removeListener(pListener);
    }

    private boolean sameFile(URL urlToCheck, URL mapViewUrl) {
        if (mapViewUrl == null) {
            return false;
        }
        if (urlToCheck.getProtocol().equals("file") && mapViewUrl.getProtocol().equals("file")) {
            return new File(urlToCheck.getFile()).equals(new File(mapViewUrl.getFile()));
        }
        return urlToCheck.sameFile(mapViewUrl);
    }

    @Override
    public void scrollNodeToVisible(NodeModel node) {
        NodeView nodeView = this.selectedMapView.getNodeView(node);
        if (nodeView != null) {
            this.selectedMapView.scrollNodeToVisible(nodeView);
        }
    }

    @Override
    public void setZoom(float zoom) {
        this.zoom = zoom;
        MapView mapView = this.getMapView();
        if (mapView == null) {
            return;
        }
        MapModel map = mapView.getModel();
        MapStyle mapStyle = mapView.getModeController().getExtension(MapStyle.class);
        if (mapView.getZoom() == zoom) {
            return;
        }
        mapStyle.setZoom(map, zoom);
        mapView.setZoom(zoom);
        this.setZoomComboBox(zoom);
        Object[] messageArguments = new Object[]{String.valueOf(zoom * 100.0f)};
        String stringResult = TextUtils.format("user_defined_zoom_status_bar", messageArguments);
        this.controller.getViewController().out(stringResult);
    }

    @Override
    public boolean tryToChangeToMapView(String mapView) {
        if (mapView != null && this.getMapKeys().contains(mapView)) {
            this.changeToMapView(mapView);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryToChangeToMapView(URL url) throws MalformedURLException {
        String mapExtensionKey = this.checkIfFileIsAlreadyOpened(url);
        if (mapExtensionKey != null) {
            this.tryToChangeToMapView(mapExtensionKey);
            return true;
        }
        return false;
    }

    @Override
    public void updateMapViewName() {
        MapView r = this.getMapView();
        String name = r.getModel().getTitle();
        this.addToOrChangeInMapViews(name, this.getMapView());
        this.changeToMapView(this.getMapView());
    }

    @Override
    public boolean isLeftTreeSupported(Component mapViewComponent) {
        return ((MapView)mapViewComponent).getLayoutType() != MapViewLayout.OUTLINE;
    }

    @Override
    public Map<String, MapModel> getMaps(String modename) {
        HashMap<String, MapModel> returnValue = new HashMap<String, MapModel>(this.mapViewVector.size());
        for (MapView mapView : this.mapViewVector) {
            if (!mapView.getModeController().getModeName().equals(modename)) continue;
            returnValue.put(mapView.getName(), this.getModel(mapView));
        }
        return Collections.unmodifiableMap(returnValue);
    }

    @Override
    public List<Component> getViews(MapModel map) {
        LinkedList<Component> list = new LinkedList<Component>();
        for (MapView view : this.mapViewVector) {
            if (!view.getModel().equals(map)) continue;
            list.add(view);
        }
        return list;
    }

    @Override
    public void afterViewChange(Component oldMap, Component pNewMap) {
        ModeController oldModeController;
        Controller controller = Controller.getCurrentController();
        ModeController newModeController = oldModeController = controller.getModeController();
        if (pNewMap != null) {
            IMapSelection mapSelection = this.getMapSelection();
            NodeModel selected = mapSelection.getSelected();
            mapSelection.scrollNodeToVisible(selected);
            this.setZoomComboBox(this.getZoom());
            this.obtainFocusForSelected();
            newModeController = this.getModeController(pNewMap);
            if (newModeController != oldModeController) {
                controller.selectMode(newModeController);
            }
        }
        this.setTitle();
        controller.getViewController().viewNumberChanged(this.getViewNumber());
        newModeController.getUserInputListenerFactory().updateMapList();
        if (pNewMap != null) {
            newModeController.setVisible(true);
        }
    }

    @Override
    public void afterViewClose(Component oldView) {
        ModeController newModeController = this.getModeController(oldView);
        newModeController.getUserInputListenerFactory().updateMapList();
    }

    @Override
    public void afterViewCreated(Component mapView) {
    }

    @Override
    public void beforeViewChange(Component oldMap, Component newMap) {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController();
        if (oldMap != null) {
            modeController.setVisible(false);
        }
    }

    private void setZoomByItem(Object item) {
        float zoomValue;
        if (((String)item).equals(this.userDefinedZoom)) {
            float zoom = this.getZoom();
            int zoomInt = Math.round(100.0f * zoom);
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(zoomInt, 1, 3200, 1);
            JSpinner spinner = new JSpinner(spinnerNumberModel);
            int option = JOptionPane.showConfirmDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), spinner, TextUtils.getText("enter_zoom"), 2);
            zoomValue = option == 0 ? spinnerNumberModel.getNumber().floatValue() / 100.0f : zoom;
        } else {
            zoomValue = this.getZoomValue(item);
        }
        this.setZoom(zoomValue);
    }

    private float getCurrentZoomIndex() {
        int selectedIndex = this.zoomModel.getIndexOf(this.zoomModel.getSelectedItem());
        int itemCount = this.zoomModel.getSize();
        if (selectedIndex != -1) {
            return selectedIndex;
        }
        float userZoom = this.getZoom();
        for (int i = 0; i < itemCount - 1; ++i) {
            if (!(userZoom < this.getZoomValue(this.zoomModel.getElementAt(i)))) continue;
            return (float)i - 0.5f;
        }
        return (float)itemCount - 1.5f;
    }

    public String getItemForZoom(float f) {
        return (int)(f * 100.0f) + "%";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setZoomComboBox(float f) {
        this.setZoomComboBoxRun = true;
        try {
            String toBeFound = this.getItemForZoom(f);
            this.zoomModel.setSelectedItem(toBeFound);
        }
        finally {
            this.setZoomComboBoxRun = false;
        }
    }

    public void zoomIn() {
        float currentZoomIndex = this.getCurrentZoomIndex();
        if (currentZoomIndex < (float)(this.zoomModel.getSize() - 2)) {
            this.setZoomByItem(this.zoomModel.getElementAt((int)(currentZoomIndex + 1.0f)));
        }
    }

    public void zoomOut() {
        float currentZoomIndex = this.getCurrentZoomIndex();
        if (currentZoomIndex > 0.0f) {
            this.setZoomByItem(this.zoomModel.getElementAt((int)(currentZoomIndex - 0.5f)));
        }
    }

    @Override
    public void updateMenus(MenuBuilder menuBuilder) {
        if (menuBuilder.contains("main_toolbar_zoom")) {
            JComboBox zoomBox = new JComboBox(this.zoomModel);
            menuBuilder.addElement("main_toolbar_zoom", zoomBox, 0);
        }
    }

    public String[] getZooms() {
        return zooms;
    }

    private float getZoomValue(Object item) {
        String dirty = (String)item;
        String cleaned = dirty.substring(0, dirty.length() - 1);
        float zoomValue = (float)Integer.parseInt(cleaned, 10) / 100.0f;
        return zoomValue;
    }

    @Override
    public void obtainFocusForSelected() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Component selectedComponent;
                if (MapViewController.this.getMapView() != null && (selectedComponent = MapViewController.this.getSelectedComponent()) != null) {
                    selectedComponent.requestFocus();
                }
            }
        });
    }

    @Override
    public boolean closeAllMaps() {
        while (this.getMapViewVector().size() > 0) {
            if (this.getMapView() != null) {
                boolean closingNotCancelled = this.close(false);
                if (closingNotCancelled) continue;
                return false;
            }
            this.nextMapView();
        }
        ResourceController.getResourceController().setProperty("antialiasEdges", this.antialiasEdges ? "true" : "false");
        ResourceController.getResourceController().setProperty("antialiasAll", this.antialiasAll ? "true" : "false");
        return true;
    }

    private boolean getAntialiasAll() {
        return this.antialiasAll;
    }

    private boolean getAntialiasEdges() {
        return this.antialiasEdges;
    }

    public void setAntialiasAll(boolean antialiasAll) {
        this.antialiasAll = antialiasAll;
    }

    public void setAntialiasEdges(boolean antialiasEdges) {
        this.antialiasEdges = antialiasEdges;
    }

    @Override
    public Object setEdgesRenderingHint(Graphics2D g) {
        Object renderingHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.getAntialiasEdges()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        return renderingHint;
    }

    @Override
    public void setTextRenderingHint(Graphics2D g) {
        if (this.getAntialiasAll()) {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    private void changeAntialias(String command) {
        Component mapView;
        if (command == null) {
            return;
        }
        if (command.equals("antialias_none")) {
            this.setAntialiasEdges(false);
            this.setAntialiasAll(false);
        }
        if (command.equals("antialias_edges")) {
            this.setAntialiasEdges(true);
            this.setAntialiasAll(false);
        }
        if (command.equals("antialias_all")) {
            this.setAntialiasEdges(true);
            this.setAntialiasAll(true);
        }
        if ((mapView = this.getMapViewComponent()) != null) {
            mapView.repaint();
        }
    }

    @Override
    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (propertyName.equals("antialias")) {
            this.changeAntialias(newValue);
        }
    }

    @Override
    public void setTitle() {
        ModeController modeController = Controller.getCurrentModeController();
        if (modeController == null) {
            this.controller.getViewController().setTitle("");
            return;
        }
        Object[] messageArguments = new Object[]{TextUtils.getText("mode_" + modeController.getModeName())};
        MessageFormat formatter = new MessageFormat(TextUtils.getText("mode_title"));
        String frameTitle = formatter.format(messageArguments);
        String viewName = "";
        MapModel model = this.getModel();
        if (model != null) {
            viewName = this.getMapViewComponent().getName();
            frameTitle = viewName + (model.isSaved() ? "" : "*") + " - " + frameTitle + (model.isReadOnly() ? " (" + TextUtils.getText("read_only") + ")" : "");
            File file = model.getFile();
            if (file != null) {
                frameTitle = frameTitle + " " + file.getAbsolutePath();
            }
        }
        this.controller.getViewController().setTitle(frameTitle);
        modeController.getUserInputListenerFactory().updateMapList();
    }
}

