/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.AWTKeyStroke;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.dnd.Autoscroll;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.LinkModel;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeView;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.print.FitMap;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MindMapLayout;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.NodeViewFactory;
import org.freeplane.view.swing.map.PaintingMode;
import org.freeplane.view.swing.map.link.AConnectorView;
import org.freeplane.view.swing.map.link.ConnectorView;
import org.freeplane.view.swing.map.link.EdgeLinkView;
import org.freeplane.view.swing.map.link.ILinkView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapView
extends JPanel
implements Printable,
Autoscroll,
IMapChangeListener,
IFreeplanePropertyListener {
    private MapViewLayout layoutType;
    private boolean showNotes;
    private PaintingMode paintingMode = null;
    private static final int margin = 20;
    static boolean printOnWhiteBackground;
    private static IFreeplanePropertyListener propertyChangeListener;
    public static final String RESOURCES_SELECTED_NODE_COLOR = "standardselectednodecolor";
    public static final String RESOURCES_SELECTED_NODE_RECTANGLE_COLOR = "standardselectednoderectanglecolor";
    private static final String PRESENTATION_DIMMER_TRANSPARENCY = "presentation_dimmer_transparency";
    private static final String PRESENTATION_MODE_ENABLED = "presentation_mode";
    private static final long serialVersionUID = 1L;
    static boolean standardDrawRectangleForSelection;
    static Color standardSelectColor;
    private static Stroke standardSelectionStroke;
    static Color standardSelectRectangleColor;
    private NodeView anchor;
    private Point anchorContentLocation;
    private Vector<ILinkView> arrowLinkViews;
    private Color background = null;
    private Rectangle boundingRectangle = null;
    private boolean disableMoveCursor = true;
    private int extraWidth;
    private FitMap fitMap = FitMap.USER_DEFINED;
    private boolean isPreparedForPrinting = false;
    private boolean isPrinting = false;
    private final ModeController modeController;
    private final MapModel model;
    private NodeView nodeToBeVisible = null;
    private NodeView rootView = null;
    private boolean selectedsValid = true;
    private final Selection selection = new Selection();
    private int siblingMaxLevel;
    private float zoom = 1.0f;
    private float anchorHorizontalPoint;
    private float anchorVerticalPoint;
    private NodeView nodeToBeCentered;
    private Font noteFont;
    private Font detailFont;
    private Color detailForeground;
    private Color detailBackground;
    private boolean slowScroll;
    private static boolean presentationModeEnabled;
    private static int transparency;

    public MapViewLayout getLayoutType() {
        return this.layoutType;
    }

    protected void setLayoutType(MapViewLayout layoutType) {
        this.layoutType = layoutType;
    }

    boolean showNotes() {
        return this.showNotes;
    }

    private void setShowNotes() {
        boolean showNotes = NoteController.getController(this.getModeController()).showNotesInMap(this.getModel());
        if (this.showNotes == showNotes) {
            return;
        }
        this.showNotes = showNotes;
        this.getRoot().updateAll();
    }

    public MapView(MapModel model, ModeController modeController) {
        this.model = model;
        this.modeController = modeController;
        String name = model.getTitle();
        this.setName(name);
        if (standardSelectColor == null) {
            String stdcolor = ResourceController.getResourceController().getProperty(RESOURCES_SELECTED_NODE_COLOR);
            standardSelectColor = ColorUtils.stringToColor(stdcolor);
            String stdtextcolor = ResourceController.getResourceController().getProperty(RESOURCES_SELECTED_NODE_RECTANGLE_COLOR);
            standardSelectRectangleColor = ColorUtils.stringToColor(stdtextcolor);
            String drawCircle = ResourceController.getResourceController().getProperty("standarddrawrectangleforselection");
            standardDrawRectangleForSelection = TreeXmlReader.xmlToBoolean(drawCircle);
            String printOnWhite = ResourceController.getResourceController().getProperty("printonwhitebackground");
            printOnWhiteBackground = TreeXmlReader.xmlToBoolean(printOnWhite);
            transparency = 255 - ResourceController.getResourceController().getIntProperty(PRESENTATION_DIMMER_TRANSPARENCY, 112);
            presentationModeEnabled = ResourceController.getResourceController().getBooleanProperty(PRESENTATION_MODE_ENABLED);
            MapView.createPropertyChangeListener();
        }
        this.setAutoscrolls(true);
        this.setLayout(new MindMapLayout());
        NoteController noteController = NoteController.getController(this.getModeController());
        this.showNotes = noteController != null && noteController.showNotesInMap(this.getModel());
        this.updateContentStyle();
        this.initRoot();
        this.setBackground(this.requiredBackground());
        MapStyleModel mapStyleModel = MapStyleModel.getExtension(model);
        this.zoom = mapStyleModel.getZoom();
        this.layoutType = mapStyleModel.getMapViewLayout();
        IUserInputListenerFactory userInputListenerFactory = this.getModeController().getUserInputListenerFactory();
        this.addMouseListener(userInputListenerFactory.getMapMouseListener());
        this.addMouseMotionListener(userInputListenerFactory.getMapMouseListener());
        this.addMouseWheelListener(userInputListenerFactory.getMapMouseWheelListener());
        this.setFocusTraversalKeys(0, this.emptyNodeViewSet());
        this.setFocusTraversalKeys(1, this.emptyNodeViewSet());
        this.setFocusTraversalKeys(2, this.emptyNodeViewSet());
        this.disableMoveCursor = ResourceController.getResourceController().getBooleanProperty("disable_cursor_move_paper");
        this.addHierarchyBoundsListener(new Resizer());
    }

    public void replaceSelection(NodeView[] views) {
        this.selection.replace(views);
        if (views.length > 0) {
            views[0].requestFocusInWindow();
        }
    }

    private Set<AWTKeyStroke> emptyNodeViewSet() {
        return Collections.emptySet();
    }

    private void anchorToSelected(NodeModel node, float horizontalPoint, float verticalPoint) {
        NodeView view = this.getNodeView(node);
        this.anchorToSelected(view, horizontalPoint, verticalPoint);
    }

    void anchorToSelected(NodeView view, float horizontalPoint, float verticalPoint) {
        if (view != null && view.getMainView() != null) {
            this.anchor = view;
            this.anchorHorizontalPoint = horizontalPoint;
            this.anchorVerticalPoint = verticalPoint;
            this.anchorContentLocation = this.getAnchorCenterPoint();
            if (this.nodeToBeVisible == null) {
                this.nodeToBeVisible = this.anchor;
                this.extraWidth = 0;
            }
        }
    }

    @Override
    public void autoscroll(Point cursorLocn) {
        Rectangle r = new Rectangle((int)cursorLocn.getX() - 20, (int)cursorLocn.getY() - 20, 41, 41);
        this.scrollRectToVisible(r);
    }

    public void centerNode(NodeView node, boolean slowScroll) {
        if (node != null) {
            this.slowScroll = slowScroll;
            this.nodeToBeVisible = null;
            if (!this.isShowing()) {
                this.centerNodeAfterMapIsDisplayed(node);
            } else {
                this.nodeToBeCentered = node;
                if (!this.isLayoutCompleted()) {
                    this.centerNodeLater();
                } else {
                    this.centerNodeNow(slowScroll);
                }
            }
        }
    }

    private void centerNodeLater() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MapView.this.centerNode(MapView.this.nodeToBeCentered, MapView.this.slowScroll);
            }
        });
    }

    private void centerNodeNow(boolean slowScroll) {
        JViewport viewPort = (JViewport)this.getParent();
        if (slowScroll) {
            viewPort.putClientProperty("slowScrolling", Boolean.TRUE);
        }
        Dimension d = viewPort.getExtentSize();
        JComponent content = this.nodeToBeCentered.getContent();
        Rectangle rect = new Rectangle(content.getWidth() / 2 - d.width / 2, content.getHeight() / 2 - d.height / 2, d.width, d.height);
        Point oldAnchorContentLocation = this.anchorContentLocation;
        this.anchorContentLocation = new Point();
        Point oldViewPosition = viewPort.getViewPosition();
        content.scrollRectToVisible(rect);
        Point newViewPosition = viewPort.getViewPosition();
        if (oldViewPosition.equals(newViewPosition)) {
            this.anchorContentLocation = oldAnchorContentLocation;
        }
        this.nodeToBeCentered = null;
        this.slowScroll = false;
    }

    private void centerNodeAfterMapIsDisplayed(NodeView node) {
        boolean isRetryEventListenerAlreadySet;
        boolean bl = isRetryEventListenerAlreadySet = null != this.nodeToBeCentered;
        if (!isRetryEventListenerAlreadySet) {
            HierarchyListener retryEventListener = new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent e) {
                    if (MapView.this.isShowing()) {
                        MapView.this.removeHierarchyListener(this);
                        if (MapView.this.nodeToBeCentered != null) {
                            MapView.this.centerNode(MapView.this.nodeToBeCentered, MapView.this.slowScroll);
                        }
                    }
                }
            };
            this.addHierarchyListener(retryEventListener);
        }
        this.nodeToBeCentered = node;
    }

    boolean isLayoutCompleted() {
        JViewport viewPort = (JViewport)this.getParent();
        Dimension visibleDimension = viewPort.getExtentSize();
        return visibleDimension.width > 0;
    }

    private static void createPropertyChangeListener() {
        propertyChangeListener = new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                Component mapView = Controller.getCurrentController().getMapViewManager().getMapViewComponent();
                if (!(mapView instanceof MapView)) {
                    return;
                }
                if (propertyName.equals(MapView.RESOURCES_SELECTED_NODE_COLOR)) {
                    standardSelectColor = ColorUtils.stringToColor(newValue);
                    ((MapView)mapView).repaintSelecteds();
                    return;
                }
                if (propertyName.equals(MapView.RESOURCES_SELECTED_NODE_RECTANGLE_COLOR)) {
                    standardSelectRectangleColor = ColorUtils.stringToColor(newValue);
                    ((MapView)mapView).repaintSelecteds();
                    return;
                }
                if (propertyName.equals("standarddrawrectangleforselection")) {
                    standardDrawRectangleForSelection = TreeXmlReader.xmlToBoolean(newValue);
                    ((MapView)mapView).repaintSelecteds();
                    return;
                }
                if (propertyName.equals("printonwhitebackground")) {
                    printOnWhiteBackground = TreeXmlReader.xmlToBoolean(newValue);
                    return;
                }
                if (propertyName.equals(MapView.PRESENTATION_DIMMER_TRANSPARENCY)) {
                    transparency = 255 - ResourceController.getResourceController().getIntProperty(MapView.PRESENTATION_DIMMER_TRANSPARENCY, 112);
                    ((MapView)mapView).repaint();
                    return;
                }
                if (propertyName.equals(MapView.PRESENTATION_MODE_ENABLED)) {
                    presentationModeEnabled = ResourceController.getResourceController().getBooleanProperty(MapView.PRESENTATION_MODE_ENABLED);
                    ((MapView)mapView).repaint();
                    return;
                }
            }
        };
        ResourceController.getResourceController().addPropertyChangeListener(propertyChangeListener);
    }

    public void deselect(NodeView newSelected) {
        if (this.selection.contains(newSelected) && this.selection.deselect(newSelected)) {
            newSelected.repaintSelected();
        }
    }

    public Object detectCollision(Point p) {
        ILinkView arrowView;
        int i;
        if (this.arrowLinkViews == null) {
            return null;
        }
        for (i = 0; i < this.arrowLinkViews.size(); ++i) {
            arrowView = this.arrowLinkViews.get(i);
            if (!arrowView.detectCollision(p, true)) continue;
            return arrowView.getModel();
        }
        for (i = 0; i < this.arrowLinkViews.size(); ++i) {
            arrowView = this.arrowLinkViews.get(i);
            if (!arrowView.detectCollision(p, false)) continue;
            return arrowView.getModel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endPrinting() {
        if (!this.isPreparedForPrinting) {
            return;
        }
        this.isPreparedForPrinting = false;
        this.isPrinting = false;
        if (this.zoom == 1.0f) {
            this.getRoot().updateAll();
            Object object = this.getTreeLock();
            synchronized (object) {
                this.validateTree();
            }
        }
        if (printOnWhiteBackground) {
            this.setBackground(this.background);
        }
    }

    private Point getAnchorCenterPoint() {
        MainView mainView = this.anchor.getMainView();
        Point anchorCenterPoint = new Point((int)((float)mainView.getWidth() * this.anchorHorizontalPoint), (int)((float)mainView.getHeight() * this.anchorVerticalPoint));
        JViewport parent = (JViewport)this.getParent();
        if (parent == null) {
            return new Point();
        }
        try {
            UITools.convertPointToAncestor((Component)mainView, anchorCenterPoint, parent);
        }
        catch (NullPointerException e) {
            return new Point();
        }
        Point viewPosition = parent.getViewPosition();
        anchorCenterPoint.x += viewPosition.x - parent.getWidth() / 2;
        anchorCenterPoint.y += viewPosition.y - parent.getHeight() / 2;
        return anchorCenterPoint;
    }

    @Override
    public Insets getAutoscrollInsets() {
        Container parent = this.getParent();
        if (parent == null) {
            return new Insets(0, 0, 0, 0);
        }
        Rectangle outer = this.getBounds();
        Rectangle inner = parent.getBounds();
        return new Insets(inner.y - outer.y + 20, inner.x - outer.x + 20, outer.height - inner.height - inner.y + outer.y + 20, outer.width - inner.width - inner.x + outer.x + 20);
    }

    public Rectangle getInnerBounds() {
        Rectangle innerBounds = this.rootView.getBounds();
        Rectangle maxBounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        for (int i = 0; i < this.arrowLinkViews.size(); ++i) {
            ILinkView arrowView = this.arrowLinkViews.get(i);
            arrowView.increaseBounds(innerBounds);
        }
        return innerBounds.intersection(maxBounds);
    }

    public IMapSelection getMapSelection() {
        return new MapSelection();
    }

    public ModeController getModeController() {
        return this.modeController;
    }

    public MapModel getModel() {
        return this.model;
    }

    public Point getNodeContentLocation(NodeView nodeView) {
        Point contentXY = new Point(0, 0);
        UITools.convertPointToAncestor((Component)nodeView.getContent(), contentXY, this);
        return contentXY;
    }

    private NodeView getNodeView(Object o) {
        if (!(o instanceof NodeModel)) {
            return null;
        }
        NodeView nodeView = this.getNodeView((NodeModel)o);
        return nodeView;
    }

    public NodeView getNodeView(NodeModel node) {
        if (node == null) {
            return null;
        }
        for (INodeView iNodeView : node.getViewers()) {
            NodeView candidateView;
            if (!(iNodeView instanceof NodeView) || (candidateView = (NodeView)iNodeView).getMap() != this) continue;
            return candidateView;
        }
        NodeView root = this.getRoot();
        if (root.getModel().equals(node)) {
            return root;
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.getParent().isValid()) {
            Dimension preferredLayoutSize = this.getLayout().preferredLayoutSize(this);
            return preferredLayoutSize;
        }
        return super.getPreferredSize();
    }

    public NodeView getRoot() {
        return this.rootView;
    }

    public NodeView getSelected() {
        if (!this.selectedsValid) {
            NodeView node = this.selection.selectedNode;
            if (node == null || !SwingUtilities.isDescendingFrom(node, this)) {
                this.validateSelecteds();
            } else {
                JComponent content = node.getContent();
                if (content == null || !content.isVisible()) {
                    this.validateSelecteds();
                }
            }
        }
        return this.selection.selectedNode;
    }

    public Set<NodeModel> getSelectedNodes() {
        this.validateSelecteds();
        return new AbstractSet<NodeModel>(){

            @Override
            public int size() {
                return MapView.this.selection.size();
            }

            @Override
            public boolean contains(Object o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.contains(nodeView);
            }

            @Override
            public boolean add(NodeModel o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.add(nodeView);
            }

            @Override
            public boolean remove(Object o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.deselect(nodeView);
            }

            @Override
            public Iterator<NodeModel> iterator() {
                return new Iterator<NodeModel>(){
                    final Iterator<NodeView> i;
                    {
                        this.i = MapView.this.selection.getSelectedSet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public NodeModel next() {
                        return this.i.next().getModel();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    public List<NodeModel> getOrderedSelectedNodes() {
        this.validateSelecteds();
        return new AbstractList<NodeModel>(){

            @Override
            public boolean add(NodeModel o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.add(nodeView);
            }

            @Override
            public boolean contains(Object o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.contains(nodeView);
            }

            @Override
            public boolean remove(Object o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.deselect(nodeView);
            }

            @Override
            public NodeModel get(int index) {
                return ((NodeView)MapView.this.selection.getSelectedList().get(index)).getModel();
            }

            @Override
            public int size() {
                return MapView.this.selection.size();
            }
        };
    }

    ArrayList<NodeModel> getSelectedNodesSortedByY(boolean differentSubtrees) {
        this.validateSelecteds();
        TreeMap<Integer, LinkedList<NodeModel>> sortedNodes = new TreeMap<Integer, LinkedList<NodeModel>>();
        block0: for (NodeView view : this.selection.getSelectedSet()) {
            LinkedList<NodeModel> nodeList;
            if (differentSubtrees) {
                for (Container parent = view.getParent(); parent != null; parent = parent.getParent()) {
                    if (this.selection.getSelectedSet().contains(parent)) continue block0;
                }
            }
            Point point = new Point();
            UITools.convertPointToAncestor((Component)view.getParent(), point, this);
            NodeModel node = view.getModel();
            if (node.getParentNode() != null) {
                point.y += node.getParentNode().getIndex(node);
            }
            if ((nodeList = (LinkedList<NodeModel>)sortedNodes.get(point.y)) == null) {
                nodeList = new LinkedList<NodeModel>();
                sortedNodes.put(point.y, nodeList);
            }
            nodeList.add(node);
        }
        ArrayList<NodeModel> selectedNodes = new ArrayList<NodeModel>();
        for (LinkedList nodeList : sortedNodes.values()) {
            for (NodeModel nodeModel : nodeList) {
                selectedNodes.add(nodeModel);
            }
        }
        return selectedNodes;
    }

    public Collection<NodeView> getSelection() {
        this.validateSelecteds();
        return this.selection.getSelection();
    }

    public int getSiblingMaxLevel() {
        return this.siblingMaxLevel;
    }

    public Dimension getViewportSize() {
        JViewport mapViewport = (JViewport)this.getParent();
        return mapViewport == null ? null : mapViewport.getSize();
    }

    private NodeView getVisibleLeft(NodeView oldSelected) {
        NodeView newSelected = oldSelected;
        NodeModel oldModel = oldSelected.getModel();
        if (oldModel.isRoot()) {
            newSelected = oldSelected.getPreferredVisibleChild(this.layoutType.equals((Object)MapViewLayout.OUTLINE), true);
        } else if (!oldSelected.isLeft()) {
            newSelected = oldSelected.getVisibleParentView();
        } else {
            if (this.getModeController().getMapController().isFolded(oldModel)) {
                this.getModeController().getMapController().setFolded(oldModel, false);
                return oldSelected;
            }
            for (newSelected = oldSelected.getPreferredVisibleChild(this.layoutType.equals((Object)MapViewLayout.OUTLINE), true); newSelected != null && !newSelected.isContentVisible(); newSelected = newSelected.getPreferredVisibleChild(this.layoutType.equals((Object)MapViewLayout.OUTLINE), true)) {
            }
            if (newSelected == null) {
                newSelected = this.getVisibleSummaryView(oldSelected);
            }
        }
        return newSelected;
    }

    private NodeView getVisibleSummaryView(NodeView node) {
        Component component;
        int currentSummaryLevel;
        if (node.isRoot()) {
            return null;
        }
        int level = currentSummaryLevel = SummaryNode.getSummaryLevel(node.getModel());
        int requiredSummaryLevel = level + 1;
        NodeView parent = node.getParentView();
        for (int i = 1 + this.getIndex(node); i < parent.getComponentCount() && (component = parent.getComponent(i)) instanceof NodeView; ++i) {
            NodeView next = (NodeView)component;
            if (next.isLeft() != node.isLeft()) continue;
            level = next.isSummary() ? ++level : 0;
            if (level == requiredSummaryLevel) {
                if (!next.getModel().isVisible()) break;
                return next;
            }
            if (level == currentSummaryLevel && SummaryNode.isFirstGroupNode(next.getModel())) break;
        }
        return this.getVisibleSummaryView(parent);
    }

    int getIndex(NodeView node) {
        NodeView parent = node.getParentView();
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            if (!parent.getComponent(i).equals(node)) continue;
            return i;
        }
        return -1;
    }

    private NodeView getVisibleRight(NodeView oldSelected) {
        NodeView newSelected = oldSelected;
        NodeModel oldModel = oldSelected.getModel();
        if (oldModel.isRoot()) {
            newSelected = oldSelected.getPreferredVisibleChild(this.layoutType.equals((Object)MapViewLayout.OUTLINE), false);
        } else if (oldSelected.isLeft()) {
            newSelected = oldSelected.getVisibleParentView();
        } else {
            if (this.getModeController().getMapController().isFolded(oldModel)) {
                this.getModeController().getMapController().setFolded(oldModel, false);
                return oldSelected;
            }
            for (newSelected = oldSelected.getPreferredVisibleChild(this.layoutType.equals((Object)MapViewLayout.OUTLINE), false); newSelected != null && !newSelected.isContentVisible(); newSelected = newSelected.getPreferredVisibleChild(this.layoutType.equals((Object)MapViewLayout.OUTLINE), false)) {
            }
            if (newSelected == null) {
                newSelected = this.getVisibleSummaryView(oldSelected);
            }
        }
        return newSelected;
    }

    public float getZoom() {
        return this.zoom;
    }

    public int getZoomed(int number) {
        return (int)Math.ceil((float)number * this.zoom);
    }

    private void initRoot() {
        this.anchorContentLocation = new Point();
        this.anchor = this.rootView = NodeViewFactory.getInstance().newNodeView(this.getModel().getRootNode(), this, this, 0);
    }

    public boolean isPrinting() {
        return this.isPrinting;
    }

    public boolean isSelected(NodeView n) {
        if (this.isPrinting || !this.selectedsValid && (this.selection.selectedNode == null || !SwingUtilities.isDescendingFrom(this.selection.selectedNode, this) || !this.selection.selectedNode.getContent().isVisible())) {
            return false;
        }
        return this.selection.contains(n);
    }

    void addSelected(NodeView newSelected, boolean scroll) {
        this.selection.add(newSelected);
        if (scroll) {
            this.scrollNodeToVisible(newSelected);
        }
    }

    @Override
    public void mapChanged(MapChangeEvent event) {
        Object property = event.getProperty();
        if (property.equals("standardbackgroundcolor")) {
            this.setBackground(this.requiredBackground());
            return;
        }
        if (property.equals("MAP_STYLES")) {
            this.updateContentStyle();
        }
        if (property.equals("MAP_STYLES") && event.getMap().equals(this.model) || property.equals("AttributeViewType") || property.equals(Filter.class) || property.equals("map_url")) {
            this.setBackground(this.requiredBackground());
            this.getRoot().updateAll();
            return;
        }
        if (property.equals("show_icon_for_attributes") || property.equals("show_note_icons")) {
            this.updateStateIconsRecursively(this.getRoot());
        }
        if (property.equals("show_notes_in_map")) {
            this.setShowNotes();
        }
    }

    private void updateStateIconsRecursively(NodeView node) {
        MainView mainView = node.getMainView();
        if (mainView == null) {
            return;
        }
        mainView.updateIcons(node);
        for (int i = 0; i < node.getComponentCount(); ++i) {
            Component component = node.getComponent(i);
            if (!(component instanceof NodeView)) continue;
            this.updateStateIconsRecursively((NodeView)component);
        }
    }

    private void updateContentStyle() {
        NodeStyleController style = Controller.getCurrentModeController().getExtension(NodeStyleController.class);
        MapModel map = this.getModel();
        this.noteFont = UITools.scale(style.getDefaultFont(map, MapStyleModel.NOTE_STYLE));
        MapStyleModel model = MapStyleModel.getExtension(map);
        NodeModel detailStyleNode = model.getStyleNodeSafe(MapStyleModel.DETAILS_STYLE);
        this.detailFont = UITools.scale(style.getFont(detailStyleNode));
        this.detailBackground = style.getBackgroundColor(detailStyleNode);
        this.detailForeground = style.getColor(detailStyleNode);
    }

    public boolean selectLeft(boolean continious) {
        NodeView selected = this.getSelected();
        NodeView newSelected = this.getVisibleLeft(selected);
        return this.selectRightOrLeft(newSelected, continious);
    }

    private boolean selectRightOrLeft(NodeView newSelected, boolean continious) {
        if (newSelected == null) {
            return false;
        }
        if (continious) {
            if (newSelected.isParentOf(this.getSelected())) {
                this.selectAsTheOnlyOneSelected(newSelected);
                this.addBranchToSelection(newSelected);
            } else {
                this.addBranchToSelection(this.getSelected());
            }
        } else {
            this.selectAsTheOnlyOneSelected(newSelected);
        }
        return true;
    }

    public boolean selectRight(boolean continious) {
        NodeView selected = this.getSelected();
        NodeView newSelected = this.getVisibleRight(selected);
        return this.selectRightOrLeft(newSelected, continious);
    }

    public boolean selectUp(boolean continious) {
        return this.selectSibling(continious, false, false);
    }

    private boolean selectSibling(boolean continious, boolean page, boolean down) {
        NodeView nextVisibleSibling;
        NodeView nextSelected = this.getSelected();
        do {
            nextVisibleSibling = this.getNextVisibleSibling(nextSelected, down);
            if (nextSelected != null && nextSelected != nextVisibleSibling) continue;
            return false;
        } while ((nextSelected = nextVisibleSibling).isSelected());
        if (page) {
            NodeView sibling = nextSelected;
            while ((sibling = this.getNextVisibleSibling(sibling, down)) != nextSelected && sibling.getParentView() == nextSelected.getParentView()) {
                nextSelected = sibling;
            }
        }
        if (continious) {
            this.selectAsTheOnlyOneSelected(this.getSelected());
            NodeView node = this.getSelected();
            do {
                node = this.getNextVisibleSibling(node, down);
                this.addSelected(node, false);
            } while (node != nextSelected);
            this.scrollNodeToVisible(nextSelected);
        } else {
            this.selectAsTheOnlyOneSelected(nextSelected);
        }
        return true;
    }

    public NodeView getNextVisibleSibling(NodeView node, boolean down) {
        return down ? node.getNextVisibleSibling() : node.getPreviousVisibleSibling();
    }

    public boolean selectDown(boolean continious) {
        return this.selectSibling(continious, false, true);
    }

    public boolean selectPageDown(boolean continious) {
        return this.selectSibling(continious, true, true);
    }

    public boolean selectPageUp(boolean continious) {
        return this.selectSibling(continious, true, false);
    }

    @Override
    public void onNodeDeleted(NodeModel parent, NodeModel child, int index) {
    }

    @Override
    public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
    }

    @Override
    public void onNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
    }

    @Override
    public void onPreNodeDelete(NodeModel oldParent, NodeModel selectedNode, int index) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        if (!this.isPrinting && this.isPreparedForPrinting) {
            this.isPreparedForPrinting = false;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MapView.this.endPrinting();
                    MapView.this.repaint();
                }
            });
            return;
        }
        if (this.isValid()) {
            this.anchorContentLocation = this.getAnchorCenterPoint();
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Controller.getCurrentController().getMapViewManager().setTextRenderingHint(g2);
            super.paint(g2);
        }
        finally {
            this.paintingMode = null;
            g2.dispose();
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        boolean paintLinksBehind = ResourceController.getResourceController().getBooleanProperty("paint_connectors_behind");
        PaintingMode[] paintModes = paintLinksBehind ? new PaintingMode[]{PaintingMode.CLOUDS, PaintingMode.LINKS, PaintingMode.NODES, PaintingMode.SELECTED_NODES} : new PaintingMode[]{PaintingMode.CLOUDS, PaintingMode.NODES, PaintingMode.SELECTED_NODES, PaintingMode.LINKS};
        Graphics2D g2 = (Graphics2D)g;
        this.paintChildren(g2, paintModes);
        if (presentationModeEnabled) {
            this.paintDimmer(g2, paintModes);
        }
        this.paintSelecteds(g2);
        this.highlightEditor(g2);
    }

    private void paintChildren(Graphics2D g2, PaintingMode[] paintModes) {
        PaintingMode[] arr$ = paintModes;
        int len$ = arr$.length;
        block3: for (int i$ = 0; i$ < len$; ++i$) {
            PaintingMode paintingMode;
            this.paintingMode = paintingMode = arr$[i$];
            switch (paintingMode) {
                case LINKS: {
                    this.paintLinks(g2);
                    continue block3;
                }
                default: {
                    super.paintChildren(g2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintDimmer(Graphics2D g2, PaintingMode[] paintModes) {
        Color color = g2.getColor();
        try {
            Color dimmer = new Color(0, 0, 0, transparency);
            g2.setColor(dimmer);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        finally {
            g2.setColor(color);
        }
        for (NodeView selected : this.getSelection()) {
            this.highlightSelected(g2, selected, paintModes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void highlightEditor(Graphics2D g2) {
        Component editor = this.getComponent(0);
        if (editor instanceof NodeView) {
            return;
        }
        Shape oldClip = g2.getClip();
        try {
            g2.setClip(editor.getX(), editor.getY(), editor.getWidth(), editor.getHeight());
            super.paintChildren(g2);
        }
        finally {
            g2.setClip(oldClip);
        }
    }

    protected PaintingMode getPaintingMode() {
        return this.paintingMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintLinks(Collection<LinkModel> links, Graphics2D graphics, HashSet<ConnectorModel> alreadyPaintedLinks) {
        Font font = graphics.getFont();
        try {
            for (LinkModel next : links) {
                NodeModel target;
                ConnectorModel ref;
                if (!(next instanceof ConnectorModel) || !alreadyPaintedLinks.add(ref = (ConnectorModel)next) || (target = ref.getTarget()) == null) continue;
                NodeModel source = ref.getSource();
                NodeView sourceView = this.getNodeView(source);
                NodeView targetView = this.getNodeView(target);
                AConnectorView arrowLink = sourceView != null && targetView != null && (ConnectorModel.Shape.EDGE_LIKE.equals((Object)ref.getShape()) || sourceView.getMap().getLayoutType() == MapViewLayout.OUTLINE) && source.isVisible() && target.isVisible() ? new EdgeLinkView(ref, this.getModeController(), sourceView, targetView) : new ConnectorView(ref, sourceView, targetView, this.getBackground());
                arrowLink.paint(graphics);
                this.arrowLinkViews.add(arrowLink);
            }
        }
        finally {
            graphics.setFont(font);
        }
    }

    private void paintLinks(Graphics2D graphics) {
        this.arrowLinkViews = new Vector();
        Object renderingHint = this.getModeController().getController().getMapViewManager().setEdgesRenderingHint(graphics);
        this.paintLinks(this.rootView, graphics, new HashSet<ConnectorModel>());
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
    }

    private void paintLinks(NodeView source, Graphics2D graphics, HashSet<ConnectorModel> alreadyPaintedLinks) {
        NodeModel node = source.getModel();
        Collection<LinkModel> outLinks = NodeLinks.getLinks(node);
        this.paintLinks(outLinks, graphics, alreadyPaintedLinks);
        Collection<LinkModel> inLinks = LinkController.getController(this.getModeController()).getLinksTo(node);
        this.paintLinks(inLinks, graphics, alreadyPaintedLinks);
        int nodeViewCount = source.getComponentCount();
        for (int i = 0; i < nodeViewCount; ++i) {
            Component component = source.getComponent(i);
            if (!(component instanceof NodeView)) continue;
            NodeView child = (NodeView)component;
            if (!this.isPrinting) {
                Rectangle bounds = SwingUtilities.convertRectangle(source, child.getBounds(), this);
                JViewport vp = (JViewport)this.getParent();
                Rectangle viewRect = vp.getViewRect();
                viewRect.x -= viewRect.width;
                viewRect.y -= viewRect.height;
                viewRect.width *= 3;
                viewRect.height *= 3;
                if (!viewRect.intersects(bounds)) continue;
            }
            this.paintLinks(child, graphics, alreadyPaintedLinks);
        }
    }

    private void paintSelecteds(Graphics2D g) {
        if (!standardDrawRectangleForSelection || this.isPrinting()) {
            return;
        }
        Color c = g.getColor();
        Stroke s = g.getStroke();
        g.setColor(standardSelectRectangleColor);
        Stroke standardSelectionStroke = this.getStandardSelectionStroke();
        g.setStroke(standardSelectionStroke);
        Object renderingHint = this.getModeController().getController().getMapViewManager().setEdgesRenderingHint(g);
        for (NodeView selected : this.getSelection()) {
            this.paintSelectionRectangle(g, selected);
        }
        g.setColor(c);
        g.setStroke(s);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
    }

    private RoundRectangle2D.Float getRoundRectangleAround(NodeView selected, int gap, int arcw) {
        JComponent content = selected.getContent();
        Point contentLocation = new Point();
        UITools.convertPointToAncestor((Component)content, contentLocation, this);
        RoundRectangle2D.Float roundRectClip = new RoundRectangle2D.Float(contentLocation.x - --gap, contentLocation.y - gap, content.getWidth() + 2 * gap, content.getHeight() + 2 * gap, arcw, arcw);
        return roundRectClip;
    }

    private void paintSelectionRectangle(Graphics2D g, NodeView selected) {
        if (selected.getMainView().isEdited()) {
            return;
        }
        RoundRectangle2D.Float roundRectClip = this.getRoundRectangleAround(selected, 4, 15);
        g.draw(roundRectClip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void highlightSelected(Graphics2D g, NodeView selected, PaintingMode[] paintedModes) {
        RoundRectangle2D.Float highlightClip = standardDrawRectangleForSelection ? this.getRoundRectangleAround(selected, 4, 15) : this.getRoundRectangleAround(selected, 4, 2);
        Shape oldClip = g.getClip();
        Rectangle oldClipBounds = g.getClipBounds();
        try {
            g.setClip(highlightClip);
            if (oldClipBounds != null) {
                g.clipRect(oldClipBounds.x, oldClipBounds.y, oldClipBounds.width, oldClipBounds.height);
            }
            Rectangle clipBounds = highlightClip.getBounds();
            Color color = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
            g.setColor(color);
            this.paintChildren(g, paintedModes);
        }
        finally {
            g.setClip(oldClip);
        }
    }

    Stroke getStandardSelectionStroke() {
        if (standardSelectionStroke == null) {
            standardSelectionStroke = new BasicStroke(2.0f);
        }
        Stroke standardSelectionStroke = MapView.standardSelectionStroke;
        return standardSelectionStroke;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preparePrinting() {
        this.isPrinting = true;
        if (!this.isPreparedForPrinting) {
            if (this.zoom == 1.0f) {
                this.getRoot().updateAll();
                Object object = this.getTreeLock();
                synchronized (object) {
                    this.validateTree();
                }
            }
            if (printOnWhiteBackground) {
                this.background = this.getBackground();
                this.setBackground(Color.WHITE);
            }
            this.boundingRectangle = this.getInnerBounds();
            this.fitMap = FitMap.valueOf();
            this.isPreparedForPrinting = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Graphics g) {
        try {
            this.preparePrinting();
            super.print(g);
        }
        finally {
            this.isPrinting = false;
        }
    }

    public void render(Graphics g1, Rectangle source, Rectangle target) {
        Graphics2D g = (Graphics2D)g1;
        AffineTransform old = g.getTransform();
        double scaleX = (0.0 + (double)target.width) / (double)source.width;
        double scaleY = (0.0 + (double)target.height) / (double)source.height;
        double zoom = scaleX < scaleY ? scaleX : scaleY;
        AffineTransform tr2 = new AffineTransform(old);
        tr2.translate(target.getWidth() / 2.0, target.getHeight() / 2.0);
        tr2.scale(zoom, zoom);
        tr2.translate(-source.getX() - source.getWidth() / 2.0, -source.getY() - source.getHeight() / 2.0);
        g.setTransform(tr2);
        Rectangle clipBounds = g1.getClipBounds();
        g1.clipRect(source.x, source.y, source.width, source.height);
        this.print(g1);
        g.setTransform(old);
        g1.setClip(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        double zoomFactor;
        double userZoomFactor = ResourceController.getResourceController().getDoubleProperty("user_zoom", 1.0);
        userZoomFactor = Math.max(0.0, userZoomFactor);
        userZoomFactor = Math.min(2.0, userZoomFactor);
        if (this.fitMap == FitMap.PAGE && pageIndex > 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics.create();
        this.preparePrinting();
        double imageableX = pageFormat.getImageableX();
        double imageableY = pageFormat.getImageableY();
        double imageableWidth = pageFormat.getImageableWidth();
        double imageableHeight = pageFormat.getImageableHeight();
        g2.clipRect((int)imageableX, (int)imageableY, (int)imageableWidth, (int)imageableHeight);
        double mapWidth = this.boundingRectangle.getWidth();
        double mapHeight = this.boundingRectangle.getHeight();
        if (this.fitMap == FitMap.PAGE) {
            double zoomFactorX = imageableWidth / mapWidth;
            double zoomFactorY = imageableHeight / mapHeight;
            zoomFactor = Math.min(zoomFactorX, zoomFactorY) * 0.99;
        } else {
            int nrPagesInHeight;
            zoomFactor = this.fitMap == FitMap.WIDTH ? imageableWidth / mapWidth * 0.99 : (this.fitMap == FitMap.HEIGHT ? imageableHeight / mapHeight * 0.99 : userZoomFactor / (double)UITools.FONT_SCALE_FACTOR);
            int nrPagesInWidth = (int)Math.ceil(zoomFactor * mapWidth / imageableWidth);
            if (pageIndex >= nrPagesInWidth * (nrPagesInHeight = (int)Math.ceil(zoomFactor * mapHeight / imageableHeight))) {
                return 1;
            }
            int yPageCoord = (int)Math.floor(pageIndex / nrPagesInWidth);
            int xPageCoord = pageIndex - yPageCoord * nrPagesInWidth;
            g2.translate(-imageableWidth * (double)xPageCoord, -imageableHeight * (double)yPageCoord);
        }
        g2.translate(imageableX, imageableY);
        g2.scale(zoomFactor, zoomFactor);
        double mapX = this.boundingRectangle.getX();
        double mapY = this.boundingRectangle.getY();
        g2.translate(-mapX, -mapY);
        this.print(g2);
        g2.dispose();
        return 0;
    }

    private void repaintSelecteds() {
        for (NodeView selected : this.getSelection()) {
            selected.repaintSelected();
        }
    }

    private Color requiredBackground() {
        MapStyle mapStyle = this.getModeController().getExtension(MapStyle.class);
        Color mapBackground = mapStyle.getBackground(this.model);
        return mapBackground;
    }

    void revalidateSelecteds() {
        this.selectedsValid = false;
    }

    public void scrollBy(int x, int y) {
        JViewport mapViewport = (JViewport)this.getParent();
        if (mapViewport != null) {
            Point currentPoint = mapViewport.getViewPosition();
            currentPoint.translate(x, y);
            if (currentPoint.getX() < 0.0) {
                currentPoint.setLocation(0.0, currentPoint.getY());
            }
            if (currentPoint.getY() < 0.0) {
                currentPoint.setLocation(currentPoint.getX(), 0.0);
            }
            double maxX = this.getSize().getWidth() - mapViewport.getExtentSize().getWidth();
            double maxY = this.getSize().getHeight() - mapViewport.getExtentSize().getHeight();
            if (currentPoint.getX() > maxX) {
                currentPoint.setLocation(maxX, currentPoint.getY());
            }
            if (currentPoint.getY() > maxY) {
                currentPoint.setLocation(currentPoint.getX(), maxY);
            }
            mapViewport.setViewPosition(currentPoint);
        }
    }

    public void scrollNodeToVisible(NodeView node) {
        this.scrollNodeToVisible(node, 0);
    }

    public void scrollNodeToVisible(NodeView node, int extraWidth) {
        if (this.nodeToBeCentered != null) {
            if (node != this.nodeToBeCentered) {
                this.centerNode(node, false);
            }
            return;
        }
        if (!this.isValid()) {
            this.nodeToBeVisible = node;
            this.extraWidth = extraWidth;
            return;
        }
        int HORIZ_SPACE = 10;
        int HORIZ_SPACE2 = 20;
        int VERT_SPACE = 5;
        int VERT_SPACE2 = 10;
        JComponent nodeContent = node.getContent();
        int width = nodeContent.getWidth();
        if (extraWidth < 0) {
            nodeContent.scrollRectToVisible(new Rectangle(-10 + extraWidth, -5, (width -= extraWidth) + 20, nodeContent.getHeight() + 10));
        } else {
            nodeContent.scrollRectToVisible(new Rectangle(-10, -5, (width += extraWidth) + 20, nodeContent.getHeight() + 10));
        }
    }

    public void selectAsTheOnlyOneSelected(NodeView newSelected) {
        if (!newSelected.getModel().isVisible()) {
            throw new AssertionError((Object)"select invisible node");
        }
        if (ResourceController.getResourceController().getBooleanProperty("center_selected_node")) {
            this.centerNode(newSelected, true);
        } else {
            this.scrollNodeToVisible(newSelected);
        }
        this.selectAsTheOnlyOneSelected(newSelected, true);
        this.setSiblingMaxLevel(newSelected.getModel().getNodeLevel(false));
    }

    public void selectAsTheOnlyOneSelected(NodeView newSelected, boolean requestFocus) {
        if (requestFocus) {
            newSelected.requestFocusInWindow();
        }
        this.scrollNodeToVisible(newSelected);
        if (this.selection.size() == 1 && this.getSelected().equals(newSelected)) {
            return;
        }
        NodeView[] oldSelecteds = this.selection.toArray();
        this.selection.select(newSelected);
        if (newSelected.getModel().getParentNode() != null) {
            ((NodeView)newSelected.getParent()).setPreferredChild(newSelected);
        }
        newSelected.repaintSelected();
        for (NodeView oldSelected : oldSelecteds) {
            if (oldSelected == null) continue;
            oldSelected.repaintSelected();
        }
    }

    private void addBranchToSelection(NodeView newlySelectedNodeView) {
        if (newlySelectedNodeView.isContentVisible()) {
            this.addSelected(newlySelectedNodeView, false);
        }
        for (NodeView target : newlySelectedNodeView.getChildrenViews()) {
            this.addBranchToSelection(target);
        }
    }

    void selectContinuous(NodeView newSelected) {
        if (newSelected.isRoot()) {
            this.selection.add(newSelected);
            this.scrollNodeToVisible(newSelected);
            return;
        }
        NodeView parentView = newSelected.getParentView();
        boolean isLeft = newSelected.isLeft();
        NodeModel parent = parentView.getModel();
        int newIndex = parent.getIndex(newSelected.getModel());
        int indexGapAbove = Integer.MAX_VALUE;
        int indexGapBelow = Integer.MIN_VALUE;
        LinkedList<NodeView> childrenViews = parentView.getChildrenViews();
        for (NodeView sibling : childrenViews) {
            if (newSelected == sibling || sibling.isLeft() != isLeft || !sibling.isSelected()) continue;
            int index2 = parent.getIndex(sibling.getModel());
            int indexGap = newIndex - index2;
            if (indexGap > 0) {
                if (indexGap >= indexGapAbove) continue;
                indexGapAbove = indexGap;
                continue;
            }
            if (indexGapAbove != Integer.MAX_VALUE || indexGap <= indexGapBelow) continue;
            indexGapBelow = indexGap;
        }
        if (indexGapAbove == Integer.MAX_VALUE && indexGapBelow == Integer.MIN_VALUE) {
            this.selection.add(newSelected);
            this.scrollNodeToVisible(newSelected);
            return;
        }
        NodeView lastSelected = newSelected;
        for (NodeView sibling : childrenViews) {
            int index2;
            int indexGap;
            if (sibling.isLeft() != isLeft || ((indexGap = newIndex - (index2 = parent.getIndex(sibling.getModel()))) < 0 || indexGapAbove >= Integer.MAX_VALUE || indexGap >= indexGapAbove) && (indexGap > 0 || indexGapAbove != Integer.MAX_VALUE || indexGapBelow <= Integer.MIN_VALUE || indexGap <= indexGapBelow)) continue;
            this.selection.add(sibling);
            lastSelected = sibling;
        }
        this.scrollNodeToVisible(lastSelected);
    }

    public void setMoveCursor(boolean isHand) {
        int requiredCursor;
        int n = requiredCursor = isHand && !this.disableMoveCursor ? 13 : 0;
        if (this.getCursor().getType() != requiredCursor) {
            this.setCursor(requiredCursor != 0 ? new Cursor(requiredCursor) : null);
        }
    }

    void setSiblingMaxLevel(int level) {
        this.siblingMaxLevel = level;
    }

    private void setViewPositionAfterValidate() {
        int scrollMode;
        if (this.nodeToBeCentered != null) {
            this.centerNode(this.nodeToBeCentered, this.slowScroll);
            return;
        }
        if (this.anchorContentLocation.getX() == 0.0 && this.anchorContentLocation.getY() == 0.0) {
            return;
        }
        JViewport vp = (JViewport)this.getParent();
        Point viewPosition = vp.getViewPosition();
        Point oldAnchorContentLocation = this.anchorContentLocation;
        Point newAnchorContentLocation = this.getAnchorCenterPoint();
        if (this.anchor != this.getRoot()) {
            this.anchor = this.getRoot();
            this.anchorContentLocation = this.getAnchorCenterPoint();
        } else {
            this.anchorContentLocation = newAnchorContentLocation;
        }
        int deltaX = newAnchorContentLocation.x - oldAnchorContentLocation.x;
        int deltaY = newAnchorContentLocation.y - oldAnchorContentLocation.y;
        if (deltaX != 0 || deltaY != 0) {
            viewPosition.x += deltaX;
            viewPosition.y += deltaY;
            scrollMode = vp.getScrollMode();
            vp.setScrollMode(0);
            vp.setViewPosition(viewPosition);
            vp.setScrollMode(scrollMode);
        } else {
            this.repaintVisible();
        }
        if (this.nodeToBeVisible != null) {
            scrollMode = vp.getScrollMode();
            vp.setScrollMode(0);
            this.scrollNodeToVisible(this.nodeToBeVisible, this.extraWidth);
            vp.setScrollMode(scrollMode);
            this.nodeToBeVisible = null;
        }
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
        this.anchorToSelected(this.getSelected(), 0.5f, 0.5f);
        this.getRoot().updateAll();
        this.revalidate();
    }

    private void toggleSelected(NodeView nodeView) {
        if (this.isSelected(nodeView)) {
            if (this.selection.size() > 1) {
                this.selection.deselect(nodeView);
            }
        } else {
            this.selection.add(nodeView);
            this.scrollNodeToVisible(nodeView);
        }
    }

    private void validateSelecteds() {
        if (this.selectedsValid) {
            return;
        }
        this.selectedsValid = true;
        NodeView selectedView = this.getSelected();
        if (selectedView == null) {
            NodeView root = this.getRoot();
            this.selectAsTheOnlyOneSelected(root);
            this.centerNode(root, false);
            return;
        }
        NodeModel selectedNode = selectedView.getModel();
        ArrayList<NodeView> selectedNodes = new ArrayList<NodeView>(this.getSelection().size());
        for (NodeView nodeView : this.getSelection()) {
            if (nodeView == null) continue;
            selectedNodes.add(nodeView);
        }
        this.selection.clear();
        for (NodeView nodeView : selectedNodes) {
            if (!nodeView.isContentVisible()) continue;
            this.selection.add(nodeView);
        }
        if (this.getSelected() != null) {
            return;
        }
        for (NodeModel node = selectedNode.getParentNode(); node != null; node = node.getParentNode()) {
            NodeView newNodeView = this.getNodeView(node);
            if (newNodeView == null || !newNodeView.isContentVisible()) continue;
            this.selectAsTheOnlyOneSelected(newNodeView);
            return;
        }
        this.selectAsTheOnlyOneSelected(this.getRoot());
    }

    @Override
    protected void validateTree() {
        this.validateSelecteds();
        this.getRoot().validateTree();
        super.validateTree();
        this.setViewPositionAfterValidate();
    }

    @Override
    public void onPreNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
    }

    public void repaintVisible() {
        JViewport vp = (JViewport)this.getParent();
        this.repaint(vp.getViewRect());
    }

    @Override
    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (propertyName.equals("highlight_formulas")) {
            UITools.repaintAll(this.getRoot());
        }
    }

    public void selectVisibleAncestorOrSelf(NodeView preferred) {
        while (!preferred.getModel().isVisible()) {
            preferred = preferred.getParentView();
        }
        this.selectAsTheOnlyOneSelected(preferred);
    }

    public Font getDefaultNoteFont() {
        return this.noteFont;
    }

    public Font getDetailFont() {
        return this.detailFont;
    }

    public Color getDetailForeground() {
        return this.detailForeground;
    }

    public Color getDetailBackground() {
        return this.detailBackground;
    }

    private boolean isSelected() {
        return Controller.getCurrentController().getMapViewManager().getMapViewComponent() == this;
    }

    void selectIfSelectionIsEmpty(NodeView nodeView) {
        if (this.selection.selectedNode == null) {
            this.selectAsTheOnlyOneSelected(nodeView);
        }
    }

    private boolean isAncorPositionSet() {
        return this.anchorContentLocation.getX() != 0.0 || this.anchorContentLocation.getY() != 0.0;
    }

    public static MapView getMapView(Component component) {
        if (component instanceof MapView) {
            return (MapView)component;
        }
        return (MapView)SwingUtilities.getAncestorOfClass(MapView.class, component);
    }

    public void select() {
        this.getModeController().getController().getMapViewManager().changeToMapView(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Selection {
        private final Set<NodeView> selectedSet = new LinkedHashSet<NodeView>();
        private final List<NodeView> selectedList = new ArrayList<NodeView>();
        private NodeView selectedNode = null;

        private void select(NodeView node) {
            this.clear();
            this.selectedSet.add(node);
            this.selectedList.add(node);
            this.selectedNode = node;
            this.addSelectionForHooks(node);
            node.repaintSelected();
        }

        private boolean add(NodeView node) {
            if (this.selectedNode == null) {
                this.select(node);
                return true;
            }
            if (this.selectedSet.add(node)) {
                this.selectedList.add(node);
                node.repaintSelected();
                return true;
            }
            return false;
        }

        private void addSelectionForHooks(NodeView node) {
            if (!MapView.this.isSelected()) {
                return;
            }
            ModeController modeController = MapView.this.getModeController();
            MapController mapController = modeController.getMapController();
            NodeModel model = node.getModel();
            mapController.onSelect(model);
        }

        private void clear() {
            if (this.selectedNode != null) {
                this.removeSelectionForHooks(this.selectedNode);
                this.selectedNode = null;
                this.selectedSet.clear();
                this.selectedList.clear();
            }
        }

        private boolean contains(NodeView node) {
            return this.selectedSet.contains(node);
        }

        public Set<NodeView> getSelection() {
            return Collections.unmodifiableSet(this.selectedSet);
        }

        private boolean deselect(NodeView node) {
            boolean selectedChanged;
            boolean bl = selectedChanged = this.selectedNode != null && this.selectedNode.equals(node);
            if (selectedChanged) {
                this.removeSelectionForHooks(node);
            }
            if (this.selectedSet.remove(node)) {
                int last = this.selectedList.size() - 1;
                if (this.selectedList.get(last).equals(node)) {
                    this.selectedList.remove(last);
                } else {
                    this.selectedList.remove(node);
                }
                node.repaintSelected();
                if (selectedChanged) {
                    if (this.size() > 0) {
                        this.selectedNode = this.selectedSet.iterator().next();
                        this.addSelectionForHooks(this.selectedNode);
                    } else {
                        this.selectedNode = null;
                    }
                }
                return true;
            }
            return false;
        }

        private void removeSelectionForHooks(NodeView node) {
            if (node.getModel() == null || !MapView.this.isSelected()) {
                return;
            }
            MapView.this.getModeController().getMapController().onDeselect(node.getModel());
        }

        private int size() {
            return this.selectedSet.size();
        }

        private void replace(NodeView[] newSelection) {
            boolean selectedChanges;
            if (newSelection.length == 0) {
                return;
            }
            boolean bl = selectedChanges = !newSelection[0].equals(this.selectedNode);
            if (selectedChanges) {
                if (this.selectedNode != null) {
                    this.removeSelectionForHooks(this.selectedNode);
                }
                this.selectedNode = newSelection[0];
            }
            for (NodeView view : newSelection) {
                if (this.selectedSet.contains(view)) continue;
                view.repaintSelected();
            }
            NodeView[] oldSelection = this.selectedSet.toArray(new NodeView[this.selectedSet.size()]);
            this.selectedSet.clear();
            this.selectedList.clear();
            for (NodeView view : newSelection) {
                if (!this.selectedSet.add(view)) continue;
                this.selectedList.add(view);
            }
            if (selectedChanges) {
                this.addSelectionForHooks(this.selectedNode);
            }
            for (NodeView view : oldSelection) {
                if (this.selectedSet.contains(view)) continue;
                view.repaintSelected();
            }
        }

        public NodeView[] toArray() {
            return this.selectedList.toArray(new NodeView[this.selectedList.size()]);
        }

        private List<NodeView> getSelectedList() {
            return this.selectedList;
        }

        private Set<NodeView> getSelectedSet() {
            return this.selectedSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapSelection
    implements IMapSelection {
        private MapSelection() {
        }

        @Override
        public void centerNode(NodeModel node) {
            NodeView nodeView = MapView.this.getNodeView(node);
            if (nodeView != null) {
                MapView.this.centerNode(nodeView, false);
            }
        }

        @Override
        public NodeModel getSelected() {
            NodeView selected = MapView.this.getSelected();
            return selected.getModel();
        }

        @Override
        public Set<NodeModel> getSelection() {
            return MapView.this.getSelectedNodes();
        }

        @Override
        public List<NodeModel> getOrderedSelection() {
            return MapView.this.getOrderedSelectedNodes();
        }

        @Override
        public List<NodeModel> getSortedSelection(boolean differentSubtrees) {
            return MapView.this.getSelectedNodesSortedByY(differentSubtrees);
        }

        @Override
        public boolean isSelected(NodeModel node) {
            NodeView nodeView = MapView.this.getNodeView(node);
            return nodeView != null && MapView.this.isSelected(nodeView);
        }

        @Override
        public void keepNodePosition(NodeModel node, float horizontalPoint, float verticalPoint) {
            MapView.this.anchorToSelected(node, horizontalPoint, verticalPoint);
        }

        @Override
        public void makeTheSelected(NodeModel node) {
            NodeView nodeView = MapView.this.getNodeView(node);
            if (nodeView != null) {
                MapView.this.addSelected(nodeView, false);
            }
        }

        @Override
        public void scrollNodeToVisible(NodeModel node) {
            MapView.this.scrollNodeToVisible(MapView.this.getNodeView(node));
        }

        @Override
        public void selectAsTheOnlyOneSelected(NodeModel node) {
            NodeView nodeView = MapView.this.getNodeView(node);
            if (nodeView != null) {
                MapView.this.selectAsTheOnlyOneSelected(nodeView);
            }
        }

        @Override
        public void selectBranch(NodeModel node, boolean extend) {
            if (!extend) {
                this.selectAsTheOnlyOneSelected(node);
            }
            MapView.this.addBranchToSelection(MapView.this.getNodeView(node));
        }

        @Override
        public void selectContinuous(NodeModel node) {
            MapView.this.selectContinuous(MapView.this.getNodeView(node));
        }

        @Override
        public void selectRoot() {
            NodeModel rootNode = MapView.this.getModel().getRootNode();
            this.selectAsTheOnlyOneSelected(rootNode);
            this.centerNode(rootNode);
        }

        @Override
        public void setSiblingMaxLevel(int nodeLevel) {
            MapView.this.setSiblingMaxLevel(nodeLevel);
        }

        @Override
        public int size() {
            return this.getSelection().size();
        }

        @Override
        public void toggleSelected(NodeModel node) {
            MapView.this.toggleSelected(MapView.this.getNodeView(node));
        }

        @Override
        public void replaceSelection(NodeModel[] nodes) {
            if (nodes.length == 0) {
                return;
            }
            NodeView[] views = new NodeView[nodes.length];
            int i = 0;
            for (NodeModel node : nodes) {
                views[i++] = MapView.this.getNodeView(node);
            }
            MapView.this.replaceSelection(views);
        }
    }

    private class Resizer
    extends HierarchyBoundsAdapter {
        private Resizer() {
        }

        public void ancestorResized(HierarchyEvent e) {
            if (!MapView.this.isAncorPositionSet()) {
                return;
            }
            if (MapView.this.nodeToBeVisible == null) {
                MapView.this.nodeToBeVisible = MapView.this.getSelected();
                MapView.this.extraWidth = 0;
            }
            MapView.this.setViewPositionAfterValidate();
        }
    }
}

