/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.MultipleImage;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.HideChildSubtree;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.text.HighlightedTransformedObject;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.FoldingMark;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MouseArea;
import org.freeplane.view.swing.map.NodeTooltip;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.PaintingMode;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.map.ZoomableLabelUI;

public abstract class MainView
extends ZoomableLabel {
    private static final int FOLDING_CIRCLE_WIDTH = 16;
    private static final String USE_COMMON_OUT_POINT_FOR_ROOT_NODE_STRING = "use_common_out_point_for_root_node";
    public static boolean USE_COMMON_OUT_POINT_FOR_ROOT_NODE = ResourceController.getResourceController().getBooleanProperty("use_common_out_point_for_root_node");
    static Dimension maximumSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    static Dimension minimumSize = new Dimension(0, 0);
    private static final long serialVersionUID = 1L;
    protected int isDraggedOver = 0;
    private boolean isShortened;
    private TextModificationState textModified = TextModificationState.NONE;
    private MouseArea mouseArea = MouseArea.OUT;
    private static final int DRAG_OVAL_WIDTH = 10;

    boolean isShortened() {
        return this.isShortened;
    }

    MainView() {
        this.setAlignmentX(0.5f);
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
        this.setHorizontalTextPosition(11);
        this.setVerticalTextPosition(1);
    }

    protected void convertPointFromMap(Point p) {
        UITools.convertPointFromAncestor(this.getMap(), p, this);
    }

    protected void convertPointToMap(Point p) {
        UITools.convertPointToAncestor((Component)this, p, this.getMap());
    }

    public boolean dropAsSibling(double xCoord) {
        if (this.dropLeft(xCoord)) {
            return !this.isInVerticalRegion(xCoord, 0.6666666666666666);
        }
        return this.isInVerticalRegion(xCoord, 0.3333333333333333);
    }

    public boolean dropLeft(double xCoord) {
        return this.getNodeView().isLeft();
    }

    public int getDeltaX() {
        NodeView nodeView = this.getNodeView();
        NodeModel model = nodeView.getModel();
        if (nodeView.getMap().getModeController().getMapController().isFolded(model) && nodeView.isLeft()) {
            return this.getZoomedFoldingSymbolHalfWidth() * 3;
        }
        return 0;
    }

    public int getDeltaY() {
        return 0;
    }

    public int getDraggedOver() {
        return this.isDraggedOver;
    }

    public abstract Point getLeftPoint();

    protected int getMainViewHeightWithFoldingMark() {
        return this.getHeight();
    }

    protected int getMainViewWidthWithFoldingMark() {
        int width = this.getWidth();
        NodeView nodeView = this.getNodeView();
        NodeModel model = nodeView.getModel();
        if (nodeView.getMap().getModeController().getMapController().isFolded(model)) {
            width += this.getZoomedFoldingSymbolHalfWidth() * 3;
        }
        return width;
    }

    public Dimension getMaximumSize() {
        return maximumSize;
    }

    public Dimension getMinimumSize() {
        return minimumSize;
    }

    public abstract Point getRightPoint();

    public abstract String getShape();

    int getZoomedFoldingSymbolHalfWidth() {
        return this.getNodeView().getZoomedFoldingSymbolHalfWidth();
    }

    public boolean isInFollowLinkRegion(double xCoord) {
        NodeView nodeView = this.getNodeView();
        NodeModel model = nodeView.getModel();
        if (NodeLinks.getValidLink(model) == null) {
            return false;
        }
        Rectangle iconR = ((ZoomableLabelUI)this.getUI()).getIconR(this);
        return xCoord >= (double)iconR.x && xCoord < (double)(iconR.x + iconR.width);
    }

    public boolean isInVerticalRegion(double xCoord, double p) {
        return xCoord < (double)this.getSize().width * p;
    }

    public final void paint(Graphics g) {
        PaintingMode paintingMode = this.getMap().getPaintingMode();
        if (!paintingMode.equals((Object)PaintingMode.SELECTED_NODES) && !paintingMode.equals((Object)PaintingMode.NODES)) {
            return;
        }
        NodeView nodeView = this.getNodeView();
        boolean selected = nodeView.isSelected();
        if (paintingMode.equals((Object)PaintingMode.SELECTED_NODES) == selected) {
            super.paint(g);
        }
    }

    protected void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public void paintDragOver(Graphics2D graphics) {
        if (this.isDraggedOver == 1) {
            this.paintDragOverSon(graphics);
        }
        if (this.isDraggedOver == 2) {
            this.paintDragOverSibling(graphics);
        }
    }

    private void paintDragOverSibling(Graphics2D graphics) {
        graphics.setPaint(new GradientPaint(0.0f, this.getHeight() * 3 / 5, this.getMap().getBackground(), 0.0f, this.getHeight() / 5, NodeView.dragColor));
        graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    private void paintDragOverSon(Graphics2D graphics) {
        if (this.getNodeView().isLeft()) {
            graphics.setPaint(new GradientPaint(this.getWidth() * 3 / 4, 0.0f, this.getMap().getBackground(), this.getWidth() / 4, 0.0f, NodeView.dragColor));
            graphics.fillRect(0, 0, this.getWidth() * 3 / 4, this.getHeight() - 1);
        } else {
            graphics.setPaint(new GradientPaint(this.getWidth() / 4, 0.0f, this.getMap().getBackground(), this.getWidth() * 3 / 4, 0.0f, NodeView.dragColor));
            graphics.fillRect(this.getWidth() / 4, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    public FoldingMark foldingMarkType(MapController mapController, NodeModel node) {
        if (mapController.isFolded(node) && (node.isVisible() || node.getFilterInfo().isAncestor())) {
            return FoldingMark.ITSELF_FOLDED;
        }
        for (NodeModel child : mapController.childrenUnfolded(node)) {
            if (!child.isVisible() || !child.containsExtension(HideChildSubtree.class)) continue;
            return FoldingMark.ITSELF_FOLDED;
        }
        for (NodeModel child : mapController.childrenUnfolded(node)) {
            if (child.isVisible() || FoldingMark.UNFOLDED.equals(this.foldingMarkType(mapController, child))) continue;
            return FoldingMark.UNVISIBLE_CHILDREN_FOLDED;
        }
        return FoldingMark.UNFOLDED;
    }

    void paintDecoration(NodeView nodeView, Graphics2D g) {
        this.drawModificationRect(g);
        this.paintDragRectangle(g);
        this.paintFoldingMark(nodeView, g);
        if (this.isShortened()) {
            int size = this.getZoomedFoldingSymbolHalfWidth();
            int width = size * 7 / 3;
            int x = nodeView.isLeft() ? this.getWidth() : 0 - width;
            int height = size * 5 / 3;
            int y = (this.getHeight() - height) / 2;
            FoldingMark.SHORTENED.draw(g, nodeView, new Rectangle(x, y, width, height));
        }
    }

    protected void paintFoldingMark(NodeView nodeView, Graphics2D g) {
        if (!this.hasChildren()) {
            return;
        }
        MapView map = this.getMap();
        MapController mapController = map.getModeController().getMapController();
        NodeModel node = nodeView.getModel();
        FoldingMark markType = this.foldingMarkType(mapController, node);
        Point mousePosition = null;
        try {
            mousePosition = this.getMousePosition();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (mousePosition != null && !map.isPrinting()) {
            Point p;
            int width = Math.max(16, this.getZoomedFoldingSymbolHalfWidth() * 2);
            Point point = p = this.getNodeView().isLeft() ? this.getLeftPoint() : this.getRightPoint();
            p.y = p.y + width / 2 > this.getHeight() ? this.getHeight() - width : (p.y -= width / 2);
            if (nodeView.isLeft()) {
                p.x -= width;
            }
            FoldingMark foldingCircle = markType.equals(FoldingMark.UNFOLDED) ? (mapController.hasHiddenChildren(node) ? FoldingMark.FOLDING_CIRCLE_HIDDEN_CHILD : FoldingMark.FOLDING_CIRCLE_UNFOLDED) : FoldingMark.FOLDING_CIRCLE_FOLDED;
            foldingCircle.draw(g, nodeView, new Rectangle(p.x, p.y, width, width));
        } else {
            Point p;
            int halfWidth = this.getZoomedFoldingSymbolHalfWidth();
            Point point = p = this.getNodeView().isLeft() ? this.getLeftPoint() : this.getRightPoint();
            p.x = p.x <= 0 ? (p.x -= halfWidth) : (p.x += halfWidth);
            markType.draw(g, nodeView, new Rectangle(p.x - halfWidth, p.y - halfWidth, halfWidth * 2, halfWidth * 2));
        }
    }

    private void paintDragRectangle(Graphics g) {
        if (!MouseArea.MOTION.equals((Object)this.mouseArea)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Object renderingHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        MapView parent = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, this);
        parent.getModeController().getController().getMapViewManager().setEdgesRenderingHint(g2);
        Color color = g2.getColor();
        NodeView movedView = this.getNodeView();
        Rectangle r = this.getDragRectangle();
        if (movedView.isFree()) {
            g2.setColor(Color.BLUE);
            g.fillOval(r.x, r.y, r.width - 1, r.height - 1);
        } else if (LocationModel.getModel(movedView.getModel()).getHGap() <= 0) {
            g2.setColor(Color.RED);
            g.fillOval(r.x, r.y, r.width - 1, r.height - 1);
        }
        g2.setColor(Color.BLACK);
        g.drawOval(r.x, r.y, r.width - 1, r.height - 1);
        g2.setColor(color);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
    }

    public Rectangle getDragRectangle() {
        int size = this.getDraggingWidth();
        Rectangle r = this.getNodeView().isLeft() ? new Rectangle(this.getWidth(), -size, size, this.getHeight() + size * 2) : new Rectangle(-size, -size, size, this.getHeight() + size * 2);
        return r;
    }

    private void drawModificationRect(Graphics g) {
        Color color = g.getColor();
        if (TextModificationState.HIGHLIGHT.equals((Object)this.textModified)) {
            boolean markTransformedText = TextController.isMarkTransformedTextSet();
            if (!markTransformedText) {
                return;
            }
            g.setColor(Color.GREEN);
        } else if (TextModificationState.FAILURE.equals((Object)this.textModified)) {
            g.setColor(Color.RED);
        } else {
            return;
        }
        g.drawRect(-1, -1, this.getWidth() + 2, this.getHeight() + 2);
        g.setColor(color);
    }

    public void paintBackgound(Graphics2D g) {
        Color color;
        if (this.getNodeView().useSelectionColors()) {
            color = this.getNodeView().getSelectedColor();
            this.paintBackground(g, color);
        } else {
            color = this.getNodeView().getTextBackground();
        }
        this.paintBackground(g, color);
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (super.processKeyBinding(ks, e, condition, pressed)) {
            return true;
        }
        MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, this);
        FreeplaneMenuBar freeplaneMenuBar = mapView.getModeController().getController().getViewController().getFreeplaneMenuBar();
        return !freeplaneMenuBar.isVisible() && freeplaneMenuBar.processKeyBinding(ks, e, 2, pressed);
    }

    public void setDraggedOver(int draggedOver) {
        this.isDraggedOver = draggedOver;
    }

    public void setDraggedOver(Point p) {
        this.setDraggedOver(this.dropAsSibling(p.getX()) ? 2 : 1);
    }

    public void updateFont(NodeView node) {
        Font font = NodeStyleController.getController(node.getMap().getModeController()).getFont(node.getModel());
        this.setFont(UITools.scale(font));
    }

    void updateIcons(NodeView node) {
        MultipleImage iconImages = new MultipleImage();
        NodeModel model = node.getModel();
        for (UIIcon icon : IconController.getController().getStateIcons(model)) {
            iconImages.addImage(icon.getIcon());
        }
        ModeController modeController = this.getNodeView().getMap().getModeController();
        Collection<MindIcon> icons = IconController.getController(modeController).getIcons(model);
        for (MindIcon myIcon : icons) {
            iconImages.addImage(myIcon.getIcon());
        }
        this.addOwnIcons(iconImages, model);
        this.setIcon(iconImages.getImageCount() > 0 ? iconImages : null);
    }

    private void addOwnIcons(MultipleImage iconImages, NodeModel model) {
        URI link = NodeLinks.getLink(model);
        Icon icon = LinkController.getLinkIcon(link, model);
        if (icon != null) {
            iconImages.addImage(icon);
        }
    }

    void updateTextColor(NodeView node) {
        Color color = NodeStyleController.getController(node.getMap().getModeController()).getColor(node.getModel());
        this.setForeground(color);
    }

    public boolean isEdited() {
        return this.getComponentCount() == 1 && this.getComponent(0) instanceof JTextComponent;
    }

    public void updateText(NodeModel nodeModel) {
        String text;
        Object userObject;
        NodeView nodeView = this.getNodeView();
        if (nodeView == null) {
            return;
        }
        ModeController modeController = nodeView.getMap().getModeController();
        TextController textController = TextController.getController(modeController);
        this.isShortened = textController.isMinimized(nodeModel);
        Object content = userObject = nodeModel.getUserObject();
        try {
            if (this.isShortened && content instanceof String) {
                content = HtmlUtils.htmlToPlain((String)content);
            }
            Object transformedContent = textController.getTransformedObject(content, nodeModel, userObject);
            if (nodeView.isSelected()) {
                nodeView.getMap().getModeController().getController().getViewController().addObjectTypeInfo(transformedContent);
            }
            Icon icon = textController.getIcon(transformedContent, nodeModel, content);
            this.putClientProperty("TextRenderingIcon", icon);
            text = transformedContent.toString();
            this.textModified = transformedContent instanceof HighlightedTransformedObject ? TextModificationState.HIGHLIGHT : TextModificationState.NONE;
        }
        catch (Throwable e) {
            LogUtils.warn(e.getMessage(), e);
            text = TextUtils.format("MainView.errorUpdateText", String.valueOf(content), e.getLocalizedMessage());
            this.textModified = TextModificationState.FAILURE;
        }
        if (this.isShortened) {
            text = this.shortenText(text);
        }
        text = this.convertTextToHtmlLink(text, nodeModel);
        this.updateText(text);
    }

    private String convertTextToHtmlLink(String text, NodeModel node) {
        URI link = NodeLinks.getLink(node);
        if (link == null || "menuitem".equals(link.getScheme()) || !LinkController.getController().formatNodeAsHyperlink(node)) {
            return text;
        }
        if (HtmlUtils.isHtmlNode(text)) {
            text = HtmlUtils.htmlToPlain(text);
        }
        StringBuilder sb = new StringBuilder("<html><body><a href=\"");
        sb.append(link.toString());
        sb.append("\">");
        String xmlEscapedText = HtmlUtils.toHTMLEscapedText(text);
        sb.append(xmlEscapedText);
        sb.append("</a></body></html>");
        return sb.toString();
    }

    private String shortenText(String longText) {
        String text = HtmlUtils.isHtmlNode(longText) ? HtmlUtils.htmlToPlain(longText).trim() : longText;
        int length = text.length();
        int eolPosition = text.indexOf(10);
        int maxShortenedNodeWidth = ResourceController.getResourceController().getIntProperty("max_shortened_text_length");
        if (eolPosition == -1 || eolPosition >= length || eolPosition >= maxShortenedNodeWidth) {
            if (length <= maxShortenedNodeWidth) {
                return text;
            }
            length = maxShortenedNodeWidth;
        } else {
            length = eolPosition;
        }
        text = text.substring(0, length);
        return text;
    }

    public JToolTip createToolTip() {
        NodeTooltip tip = new NodeTooltip();
        tip.setComponent(this);
        URL url = this.getMap().getModel().getURL();
        if (url != null) {
            tip.setBase(url);
        } else {
            try {
                tip.setBase(new URL("file: "));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return tip;
    }

    public void setBorder(Border border) {
    }

    public ConnectorLocation getConnectorLocation(Point relativeLocation) {
        if (relativeLocation.x > this.getWidth()) {
            return ConnectorLocation.RIGHT;
        }
        if (relativeLocation.x < 0) {
            return ConnectorLocation.LEFT;
        }
        if (relativeLocation.y > this.getHeight()) {
            return ConnectorLocation.BOTTOM;
        }
        if (relativeLocation.y < 0) {
            return ConnectorLocation.TOP;
        }
        return ConnectorLocation.CENTER;
    }

    public Point getConnectorPoint(Point relativeLocation) {
        if (relativeLocation.x > this.getWidth()) {
            return this.getRightPoint();
        }
        if (relativeLocation.x < 0) {
            return this.getLeftPoint();
        }
        if (relativeLocation.y > this.getHeight()) {
            Point bottomPoint = this.getBottomPoint();
            bottomPoint.y = this.getNodeView().getContent().getHeight();
            return bottomPoint;
        }
        if (relativeLocation.y < 0) {
            return this.getTopPoint();
        }
        return this.getCenterPoint();
    }

    private Point getCenterPoint() {
        return new Point(this.getWidth() / 2, this.getHeight() / 2);
    }

    public Point getTopPoint() {
        return new Point(this.getWidth() / 2, 0);
    }

    public Point getBottomPoint() {
        return new Point(this.getWidth() / 2, this.getHeight());
    }

    public String getToolTipText() {
        String toolTipText = super.getToolTipText();
        if (toolTipText != null) {
            return toolTipText;
        }
        return this.createToolTipText();
    }

    private String createToolTipText() {
        NodeView nodeView = this.getNodeView();
        if (nodeView == null) {
            return "";
        }
        ModeController modeController = nodeView.getMap().getModeController();
        NodeModel node = nodeView.getModel();
        return modeController.createToolTip(node, this);
    }

    public String getToolTipText(MouseEvent event) {
        String toolTipText = super.getToolTipText(event);
        if (toolTipText != null) {
            return toolTipText;
        }
        return this.createToolTipText();
    }

    public boolean contains(int x, int y) {
        Point p = new Point(x, y);
        return this.isInFoldingRegion(p) || this.isInDragRegion(p) || super.contains(x, y);
    }

    public boolean isInDragRegion(Point p) {
        if (p.y >= 0 && p.y < this.getHeight()) {
            NodeView nodeView = this.getNodeView();
            if (MapViewLayout.OUTLINE.equals((Object)nodeView.getMap().getLayoutType())) {
                return false;
            }
            int draggingWidth = this.getDraggingWidth();
            if (nodeView.isLeft()) {
                int width = this.getWidth();
                return p.x >= width && p.x < width + draggingWidth;
            }
            return p.x >= -draggingWidth && p.x < 0;
        }
        return false;
    }

    public boolean isInFoldingRegion(Point p) {
        if (this.hasChildren() && p.y >= 0 && p.y < this.getHeight()) {
            boolean isLeft = this.getNodeView().isLeft();
            int width = Math.max(16, this.getZoomedFoldingSymbolHalfWidth() * 2);
            if (isLeft) {
                boolean maxX = false;
                return p.x >= -width && p.x < 0;
            }
            int minX = this.getWidth();
            return p.x >= minX && p.x < this.getWidth() + width;
        }
        return false;
    }

    private boolean hasChildren() {
        return this.getNodeView().getModel().hasChildren();
    }

    public MouseArea getMouseArea() {
        return this.mouseArea;
    }

    public MouseArea whichMouseArea(Point point) {
        int x = point.x;
        if (this.isInDragRegion(point)) {
            return MouseArea.MOTION;
        }
        if (this.isInFoldingRegion(point)) {
            return MouseArea.FOLDING;
        }
        if (this.isInFollowLinkRegion(x)) {
            return MouseArea.LINK;
        }
        return MouseArea.DEFAULT;
    }

    public void setMouseArea(MouseArea mouseArea) {
        if (mouseArea.equals((Object)this.mouseArea)) {
            return;
        }
        boolean repaintDraggingRectangle = this.isVisible() && (mouseArea.equals((Object)MouseArea.MOTION) || this.mouseArea.equals((Object)MouseArea.MOTION));
        boolean repaintFoldingRectangle = this.isVisible() && (mouseArea.equals((Object)MouseArea.OUT) || mouseArea.equals((Object)MouseArea.FOLDING) || this.mouseArea.equals((Object)MouseArea.OUT) || this.mouseArea.equals((Object)MouseArea.FOLDING));
        this.mouseArea = mouseArea;
        if (repaintDraggingRectangle) {
            this.paintDraggingRectangleImmediately();
        }
        if (repaintFoldingRectangle) {
            this.paintFoldingRectangleImmediately();
        }
    }

    private void paintFoldingRectangleImmediately() {
        int y;
        int height;
        int zoomedFoldingSymbolHalfWidth = this.getZoomedFoldingSymbolHalfWidth();
        int width = Math.max(16, zoomedFoldingSymbolHalfWidth * 2);
        NodeView nodeView = this.getNodeView();
        int x = nodeView.isLeft() ? -width : this.getWidth();
        if (16 >= this.getHeight()) {
            height = 16;
            y = this.getHeight() - 16;
        } else {
            height = this.getHeight();
            y = 0;
        }
        Rectangle foldingRectangle = new Rectangle(x - 4, y - 4, width + 8, (height += zoomedFoldingSymbolHalfWidth) + 8);
        MapView map = nodeView.getMap();
        UITools.convertRectangleToAncestor(this, foldingRectangle, map);
        map.paintImmediately(foldingRectangle);
    }

    private void paintDraggingRectangleImmediately() {
        Rectangle dragRectangle = this.getDragRectangle();
        this.paintDecorationImmediately(dragRectangle);
    }

    private void paintDecorationImmediately(Rectangle rectangle) {
        MapView map = this.getMap();
        UITools.convertRectangleToAncestor(this, rectangle, map);
        map.paintImmediately(rectangle);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.setMouseArea(MouseArea.DEFAULT);
        }
    }

    private int getDraggingWidth() {
        return this.getNodeView().getZoomed(10);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectorLocation {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        CENTER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TextModificationState {
        NONE,
        HIGHLIGHT,
        FAILURE;

    }
}

