/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ZoomableLabel;

class ContentPaneLayout
implements LayoutManager {
    ContentPaneLayout() {
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        int componentCount = parent.getComponentCount();
        int width = parent.getWidth();
        NodeView view = (NodeView)parent.getParent();
        MapView map = view.getMap();
        NodeStyleController ncs = NodeStyleController.getController(map.getModeController());
        int maxWidth = ncs.getMaxWidth(view.getModel());
        int y = 0;
        for (int i = 0; i < componentCount; ++i) {
            Component component = parent.getComponent(i);
            if (component.isVisible()) {
                component.validate();
                Dimension preferredCompSize = width == 0 ? new Dimension() : (component instanceof ZoomableLabel ? ((ZoomableLabel)component).getPreferredSize(maxWidth) : component.getPreferredSize());
                if (component instanceof MainView) {
                    component.setBounds(0, y, width, preferredCompSize.height);
                } else if (width > preferredCompSize.width) {
                    int x = (int)(component.getAlignmentX() * (float)(width - preferredCompSize.width));
                    component.setBounds(x, y, preferredCompSize.width, preferredCompSize.height);
                } else {
                    component.setBounds(0, y, width, preferredCompSize.height);
                }
                y += preferredCompSize.height;
                continue;
            }
            component.setBounds(0, y, 0, 0);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        NodeView view = (NodeView)parent.getParent();
        MapView map = view.getMap();
        NodeStyleController ncs = NodeStyleController.getController(map.getModeController());
        int width = ncs.getMaxWidth(view.getModel());
        Dimension prefSize = new Dimension(0, 0);
        int componentCount = parent.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component component = parent.getComponent(i);
            if (!component.isVisible()) continue;
            component.validate();
            Dimension preferredCompSize = component instanceof ZoomableLabel ? ((ZoomableLabel)component).getPreferredSize(width) : component.getPreferredSize();
            prefSize.height += preferredCompSize.height;
            prefSize.width = Math.max(prefSize.width, preferredCompSize.width);
        }
        return prefSize;
    }

    public void removeLayoutComponent(Component comp) {
    }
}

