/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;

class BubbleMainView
extends MainView {
    static final Stroke DEF_STROKE = new BasicStroke();
    private static final long serialVersionUID = 1L;
    private static Insets insets = new Insets(3, 3, 3, 3);

    BubbleMainView() {
    }

    public Point getLeftPoint() {
        Point in = new Point(0, this.getHeight() / 2);
        return in;
    }

    public Point getRightPoint() {
        Point in = this.getLeftPoint();
        in.x = this.getWidth() - 1;
        return in;
    }

    public String getShape() {
        return "bubble";
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        NodeView nodeView = this.getNodeView();
        NodeModel model = nodeView.getModel();
        if (model == null) {
            return;
        }
        ModeController modeController = this.getNodeView().getMap().getModeController();
        Object renderingHint = modeController.getController().getMapViewManager().setEdgesRenderingHint(g);
        this.paintBackgound(g);
        this.paintDragOver(g);
        Color edgeColor = nodeView.getEdgeColor();
        g.setColor(edgeColor);
        g.setStroke(DEF_STROKE);
        g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 10, 10);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
        super.paintComponent(g);
    }

    protected void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 10, 10);
    }

    public Insets getInsets() {
        return insets;
    }

    public Insets getInsets(Insets insets) {
        return BubbleMainView.insets;
    }
}

