/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.SwingUtilities;
import org.freeplane.view.swing.map.MapView;

public class ViewerLayoutManager
implements LayoutManager {
    private float zoom;

    public ViewerLayoutManager(float zoom) {
        this.zoom = zoom;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        if (!parent.isPreferredSizeSet()) {
            throw new IllegalStateException("preferred size not set for " + parent);
        }
        Dimension preferredSize = parent.getPreferredSize();
        MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, parent);
        if (mapView == null) {
            return;
        }
        float newZoom = mapView.getZoom();
        if (this.zoom != newZoom) {
            float ratio = newZoom / this.zoom;
            preferredSize.width = (int)Math.rint((float)preferredSize.width * ratio);
            preferredSize.height = (int)Math.rint((float)preferredSize.height * ratio);
            parent.setPreferredSize(preferredSize);
            this.zoom = newZoom;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return parent.getPreferredSize();
    }

    public void removeLayoutComponent(Component comp) {
    }
}

