/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.Component;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import javax.swing.SwingUtilities;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.clipboard.MindMapNodesSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.features.filepreview.ViewerController;
import org.freeplane.view.swing.map.NodeView;

public class MExternalImageDropListener
implements DropTargetListener {
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    public void drop(DropTargetDropEvent ev) {
        try {
            int dropAction = ev.getDropAction();
            if (dropAction == 2 && ev.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor)) {
                try {
                    ev.acceptDrop(ev.getDropAction());
                    List transferData = (List)ev.getTransferable().getTransferData(MindMapNodesSelection.fileListFlavor);
                    if (transferData.size() != 1) {
                        return;
                    }
                    Component target = ev.getDropTargetContext().getComponent();
                    NodeView nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, target);
                    File file = (File)transferData.get(0);
                    ViewerController vc = Controller.getCurrentController().getModeController().getExtension(ViewerController.class);
                    NodeModel node = nodeView.getModel();
                    vc.paste(file.toURI(), node, node.isLeft());
                }
                catch (Exception e) {
                    LogUtils.warn(e);
                }
            }
        }
        catch (Exception e) {
            LogUtils.severe("Drop exception:", e);
            ev.dropComplete(false);
            return;
        }
        ev.dropComplete(true);
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private boolean isDragAcceptable(DropTargetDragEvent ev) {
        if (ev.getDropAction() == 2 && ev.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor)) {
            try {
                List transferData = (List)ev.getTransferable().getTransferData(MindMapNodesSelection.fileListFlavor);
                if (transferData.size() != 1) {
                    return false;
                }
                File file = (File)transferData.get(0);
                return file.canRead();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

