/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.freeplane.core.ui.components.BitmapImagePreview;
import org.freeplane.core.ui.components.BitmapViewerComponent;
import org.freeplane.core.util.LogUtils;
import org.freeplane.view.swing.features.filepreview.ViewerController;

public class ImagePreview
extends BitmapImagePreview {
    private static final long serialVersionUID = 1L;

    public ImagePreview(JFileChooser fc) {
        super(fc);
    }

    protected void updateView(File file) {
        JComponent viewer;
        ViewerController.FactoryFileFilter filter = (ViewerController.FactoryFileFilter)this.fc.getFileFilter();
        Dimension size = this.getSize();
        size.width -= 4;
        size.height -= 4;
        try {
            viewer = filter.getFactory().createViewer(file.getAbsoluteFile().toURI(), size);
        }
        catch (MalformedURLException e) {
            LogUtils.warn(e);
            return;
        }
        catch (IOException e) {
            LogUtils.warn(e);
            return;
        }
        if (viewer == null) {
            return;
        }
        viewer.setLocation(2, 2);
        if (viewer instanceof BitmapViewerComponent) {
            ((BitmapViewerComponent)viewer).setHint(2);
        }
        this.add(viewer);
        viewer.revalidate();
        viewer.repaint();
    }
}

