/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.swing.JComponent;
import org.freeplane.core.ui.components.BitmapViewerComponent;
import org.freeplane.core.util.TextUtils;
import org.freeplane.view.swing.features.filepreview.ExternalResource;
import org.freeplane.view.swing.features.filepreview.IViewerFactory;
import org.freeplane.view.swing.features.filepreview.ViewerLayoutManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitmapViewerFactory
implements IViewerFactory {
    @Override
    public boolean accept(URI uri) {
        Iterator<ImageReader> readers = this.getImageReaders(uri);
        return readers.hasNext();
    }

    private Iterator<ImageReader> getImageReaders(URI uri) {
        String path = uri.getRawPath();
        int suffixPos = path.lastIndexOf(46) + 1;
        if (suffixPos == 0) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        String suffix = path.substring(suffixPos);
        Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(suffix);
        return readers;
    }

    @Override
    public JComponent createViewer(ExternalResource resource, URI uri, int maximumWidth) throws MalformedURLException, IOException {
        BitmapViewerComponent bitmapViewerComponent = new BitmapViewerComponent(uri);
        Dimension originalSize = bitmapViewerComponent.getOriginalSize();
        float zoom = resource.getZoom();
        if (zoom == -1.0f) {
            zoom = resource.setZoom(originalSize.width, maximumWidth);
        }
        originalSize.width = (int)((float)originalSize.width * zoom);
        originalSize.height = (int)((float)originalSize.height * zoom);
        this.setFinalViewerSize(bitmapViewerComponent, originalSize);
        bitmapViewerComponent.setSize(originalSize);
        bitmapViewerComponent.setLayout(new ViewerLayoutManager(1.0f));
        return bitmapViewerComponent;
    }

    @Override
    public JComponent createViewer(URI uri, Dimension preferredSize) throws MalformedURLException, IOException {
        BitmapViewerComponent bitmapViewerComponent = new BitmapViewerComponent(uri);
        this.setFinalViewerSize(bitmapViewerComponent, preferredSize);
        bitmapViewerComponent.setSize(preferredSize);
        return bitmapViewerComponent;
    }

    @Override
    public String getDescription() {
        return TextUtils.getText("bitmaps");
    }

    @Override
    public Dimension getOriginalSize(JComponent viewer) {
        return ((BitmapViewerComponent)viewer).getOriginalSize();
    }

    @Override
    public void setFinalViewerSize(JComponent viewer, Dimension size) {
        viewer.setPreferredSize(size);
        ((BitmapViewerComponent)viewer).setScaleEnabled(true);
    }

    @Override
    public void setDraftViewerSize(JComponent viewer, Dimension size) {
        viewer.setPreferredSize(size);
        ((BitmapViewerComponent)viewer).setScaleEnabled(false);
    }
}

