/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.SysUtils;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.INodeView;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.ui.INodeViewVisitor;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NodeHookDescriptor(hookName="accessories/plugins/BlinkingNodeHook.properties", onceForMap=false)
public class BlinkingNodeHook
extends PersistentNodeHook {
    static Vector<Color> colors = new Vector();

    @Override
    protected IExtension createExtension(NodeModel node, XMLElement element) {
        return new TimerColorChanger(node);
    }

    protected Class<TimerColorChanger> getExtensionClass() {
        return TimerColorChanger.class;
    }

    @Override
    public void remove(NodeModel node, IExtension extension) {
        TimerColorChanger timer = (TimerColorChanger)extension;
        timer.getTimer().cancel();
        MapController mapController = Controller.getCurrentModeController().getMapController();
        mapController.removeMapChangeListener(timer);
        mapController.removeMapLifeCycleListener(timer);
        super.remove(node, extension);
    }

    protected class TimerColorChanger
    extends TimerTask
    implements IExtension,
    IMapChangeListener,
    IMapLifeCycleListener {
        private final NodeModel node;
        private final Timer timer;

        TimerColorChanger(NodeModel node) {
            this.node = node;
            MapController mapController = Controller.getCurrentModeController().getMapController();
            mapController.addMapChangeListener(this);
            mapController.addMapLifeCycleListener(this);
            this.timer = SysUtils.createTimer(this.getClass().getSimpleName());
            this.timer.schedule((TimerTask)this, 500L, 500L);
            colors.clear();
            colors.add(Color.BLUE);
            colors.add(Color.RED);
            colors.add(Color.MAGENTA);
            colors.add(Color.CYAN);
        }

        public NodeModel getNode() {
            return this.node;
        }

        public Timer getTimer() {
            return this.timer;
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (TimerColorChanger.this.getNode() == null || Controller.getCurrentModeController().isBlocked()) {
                        return;
                    }
                    TimerColorChanger.this.getNode().acceptViewVisitor(new INodeViewVisitor(){

                        public void visit(INodeView nodeView) {
                            if (!(nodeView instanceof NodeView)) {
                                return;
                            }
                            MainView container = ((NodeView)nodeView).getMainView();
                            if (container == null || !container.isVisible()) {
                                return;
                            }
                            Color col = container.getForeground();
                            int index = -1;
                            if (col != null && colors.contains(col)) {
                                index = colors.indexOf(col);
                            }
                            if (++index >= colors.size()) {
                                index = 0;
                            }
                            ((Component)container).setForeground(colors.get(index));
                        }
                    });
                }
            });
        }

        public void mapChanged(MapChangeEvent event) {
        }

        public void onNodeDeleted(NodeModel parent, NodeModel child, int index) {
            if (Controller.getCurrentModeController().isUndoAction() || !this.node.equals(child) && !this.node.isDescendantOf(child)) {
                return;
            }
            IActor actor = new IActor(){

                public void act() {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            BlinkingNodeHook.this.remove(TimerColorChanger.this.node, TimerColorChanger.this.node.getExtension(TimerColorChanger.class));
                        }
                    });
                }

                public String getDescription() {
                    return "BlinkingNodeHook.timer";
                }

                public void undo() {
                    TimerColorChanger.this.node.addExtension(new TimerColorChanger(TimerColorChanger.this.node));
                }
            };
            Controller.getCurrentModeController().execute(actor, this.node.getMap());
        }

        public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
        }

        public void onNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
        }

        public void onPreNodeDelete(NodeModel oldParent, NodeModel selectedNode, int index) {
        }

        public void onPreNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
        }

        public void onCreate(MapModel map) {
        }

        public void onRemove(MapModel map) {
            if (this.node.getMap().equals(map)) {
                this.timer.cancel();
            }
        }
    }
}

