/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.n3.nanoxml;

import java.io.PrintStream;
import java.io.PrintWriter;

public class XMLException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Exception encapsulatedException;
    private final int lineNr;
    private final String msg;
    private String systemID;

    private static String buildMessage(String systemID, int lineNr, Exception e, String msg, boolean reportParams) {
        String str = msg;
        if (reportParams) {
            if (systemID != null) {
                str = str + ", SystemID='" + systemID + "'";
            }
            if (lineNr >= 0) {
                str = str + ", Line=" + lineNr;
            }
            if (e != null) {
                str = str + ", Exception: " + e;
            }
        }
        return str;
    }

    public XMLException(Exception e) {
        this(null, -1, e, "Nested Exception", false);
    }

    public XMLException(String msg) {
        this(null, -1, null, msg, false);
    }

    public XMLException(String systemID, int lineNr, Exception e) {
        this(systemID, lineNr, e, "Nested Exception", true);
    }

    public XMLException(String systemID, int lineNr, Exception e, String msg, boolean reportParams) {
        super(XMLException.buildMessage(systemID, lineNr, e, msg, reportParams));
        this.systemID = systemID;
        this.lineNr = lineNr;
        this.encapsulatedException = e;
        this.msg = XMLException.buildMessage(systemID, lineNr, e, msg, reportParams);
    }

    public XMLException(String systemID, int lineNr, String msg) {
        this(systemID, lineNr, null, msg, true);
    }

    protected void finalize() throws Throwable {
        this.systemID = null;
        this.encapsulatedException = null;
        super.finalize();
    }

    public Exception getException() {
        return this.encapsulatedException;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.encapsulatedException != null) {
            System.err.println("*** Nested Exception:");
            this.encapsulatedException.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        if (this.encapsulatedException != null) {
            stream.println("*** Nested Exception:");
            this.encapsulatedException.printStackTrace(stream);
        }
    }

    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        if (this.encapsulatedException != null) {
            writer.println("*** Nested Exception:");
            this.encapsulatedException.printStackTrace(writer);
        }
    }

    public String toString() {
        return this.msg;
    }
}

