/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.n3.nanoxml;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.freeplane.n3.nanoxml.XMLAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLElement
implements Serializable {
    public static final int NO_LINE = -1;
    private static final long serialVersionUID = 1L;
    private Vector<XMLAttribute> attributes = new Vector();
    private Vector<XMLElement> children = new Vector(8);
    private String content;
    private String fullName;
    private final int lineNr;
    private String name;
    private String namespace;
    private XMLElement parent;
    private String systemID;

    public static XMLElement createElement(String fullName, String namespace, String systemID, int lineNr) {
        return new XMLElement(fullName, namespace, systemID, lineNr);
    }

    public XMLElement() {
        this(null, null, null, -1);
    }

    public XMLElement(String fullName) {
        this(fullName, null, null, -1);
    }

    public XMLElement(String fullName, String namespace) {
        this(fullName, namespace, null, -1);
    }

    public XMLElement(String fullName, String systemID, int lineNr) {
        this(fullName, null, systemID, lineNr);
    }

    public XMLElement(String fullName, String namespace, String systemID, int lineNr) {
        int index;
        this.fullName = fullName;
        this.name = namespace == null ? fullName : ((index = fullName.indexOf(58)) >= 0 ? fullName.substring(index + 1) : fullName);
        this.namespace = namespace;
        this.content = null;
        this.lineNr = lineNr;
        this.systemID = systemID;
        this.parent = null;
    }

    public void addChild(XMLElement child) {
        XMLElement lastChild;
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (child.getName() == null && !this.children.isEmpty() && (lastChild = this.children.lastElement()).getName() == null) {
            lastChild.setContent(lastChild.getContent() + child.getContent());
            return;
        }
        child.parent = this;
        this.children.addElement(child);
    }

    public XMLElement createElement(String fullName) {
        return new XMLElement(fullName);
    }

    public XMLElement createElement(String fullName, String namespace) {
        return new XMLElement(fullName, namespace);
    }

    public XMLElement createElement(String fullName, String systemID, int lineNr) {
        return new XMLElement(fullName, systemID, lineNr);
    }

    public XMLElement createPCDataElement() {
        return new XMLElement();
    }

    public Enumeration<String> enumerateAttributeNames() {
        Vector<String> result = new Vector<String>();
        Enumeration<XMLAttribute> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            result.addElement(enumeration.nextElement().getFullName());
        }
        return result.elements();
    }

    public Enumeration<XMLElement> enumerateChildren() {
        return this.children.elements();
    }

    public boolean equals(Object rawElement) {
        try {
            return this.equalsXMLElement((XMLElement)rawElement);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean equalsXMLElement(XMLElement elt) {
        if (!this.name.equals(elt.getName())) {
            return false;
        }
        if (this.attributes.size() != elt.getAttributeCount()) {
            return false;
        }
        Enumeration<XMLAttribute> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute attr = enumeration.nextElement();
            if (!elt.hasAttribute(attr.getName(), attr.getNamespace())) {
                return false;
            }
            String value = elt.getAttribute(attr.getName(), attr.getNamespace(), null);
            if (!attr.getValue().equals(value)) {
                return false;
            }
            String type = elt.getAttributeType(attr.getName(), attr.getNamespace());
            if (attr.getType().equals(type)) continue;
            return false;
        }
        if (this.children.size() != elt.getChildrenCount()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            XMLElement child2;
            XMLElement child1 = this.getChildAtIndex(i);
            if (child1.equalsXMLElement(child2 = elt.getChildAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        this.attributes.clear();
        this.attributes = null;
        this.children = null;
        this.fullName = null;
        this.name = null;
        this.namespace = null;
        this.content = null;
        this.systemID = null;
        this.parent = null;
        super.finalize();
    }

    private XMLAttribute findAttribute(String fullName) {
        if (fullName == null) {
            throw new IllegalArgumentException("fullName must not be null");
        }
        Enumeration<XMLAttribute> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute attr = enumeration.nextElement();
            if (!attr.getFullName().equals(fullName)) continue;
            return attr;
        }
        return null;
    }

    private XMLAttribute findAttribute(String name, String namespace) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Enumeration<XMLAttribute> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute attr = enumeration.nextElement();
            boolean found = attr.getName().equals(name);
            found = namespace == null ? (found &= attr.getNamespace() == null) : (found &= namespace.equals(attr.getNamespace()));
            if (!found) continue;
            return attr;
        }
        return null;
    }

    @Deprecated
    public String getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public int getAttribute(String name, int defaultValue) {
        String value = this.getAttribute(name, Integer.toString(defaultValue));
        return Integer.parseInt(value);
    }

    public String getAttribute(String name, String defaultValue) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getValue();
    }

    public int getAttribute(String name, String namespace, int defaultValue) {
        String value = this.getAttribute(name, namespace, Integer.toString(defaultValue));
        return Integer.parseInt(value);
    }

    public String getAttribute(String name, String namespace, String defaultValue) {
        XMLAttribute attr = this.findAttribute(name, namespace);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getValue();
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String getAttributeNamespace(String name) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            return null;
        }
        return attr.getNamespace();
    }

    public Properties getAttributes() {
        Properties result = new Properties();
        Enumeration<XMLAttribute> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute attr = enumeration.nextElement();
            result.put(attr.getFullName(), attr.getValue());
        }
        return result;
    }

    public Properties getAttributesInNamespace(String namespace) {
        Properties result = new Properties();
        Enumeration<XMLAttribute> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute attr = enumeration.nextElement();
            if (namespace == null) {
                if (attr.getNamespace() != null) continue;
                result.put(attr.getName(), attr.getValue());
                continue;
            }
            if (!namespace.equals(attr.getNamespace())) continue;
            result.put(attr.getName(), attr.getValue());
        }
        return result;
    }

    public String getAttributeType(String name) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            return null;
        }
        return attr.getType();
    }

    public String getAttributeType(String name, String namespace) {
        XMLAttribute attr = this.findAttribute(name, namespace);
        if (attr == null) {
            return null;
        }
        return attr.getType();
    }

    public XMLElement getChildAtIndex(int index) throws ArrayIndexOutOfBoundsException {
        return this.children.elementAt(index);
    }

    public Vector<XMLElement> getChildren() {
        return this.children;
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public Vector<XMLElement> getChildrenNamed(String name) {
        Vector<XMLElement> result = new Vector<XMLElement>(this.children.size());
        Enumeration<XMLElement> enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            XMLElement child = enumeration.nextElement();
            String childName = child.getFullName();
            if (childName == null || !childName.equals(name)) continue;
            result.addElement(child);
        }
        return result;
    }

    public Vector<XMLElement> getChildrenNamed(String name, String namespace) {
        Vector<XMLElement> result = new Vector<XMLElement>(this.children.size());
        Enumeration<XMLElement> enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            XMLElement child = enumeration.nextElement();
            String str = child.getName();
            boolean found = str != null && str.equals(name);
            str = child.getNamespace();
            found = str == null ? (found &= name == null) : (found &= str.equals(namespace));
            if (!found) continue;
            result.addElement(child);
        }
        return result;
    }

    public String getContent() {
        return this.content;
    }

    public XMLElement getFirstChildNamed(String name) {
        Enumeration<XMLElement> enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            XMLElement child = enumeration.nextElement();
            String childName = child.getFullName();
            if (childName == null || !childName.equals(name)) continue;
            return child;
        }
        return null;
    }

    public XMLElement getFirstChildNamed(String name, String namespace) {
        Enumeration<XMLElement> enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            XMLElement child = enumeration.nextElement();
            String str = child.getName();
            boolean found = str != null && str.equals(name);
            str = child.getNamespace();
            found = str == null ? (found &= name == null) : (found &= str.equals(namespace));
            if (!found) continue;
            return child;
        }
        return null;
    }

    public String getFullName() {
        return this.fullName;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public XMLElement getParent() {
        return this.parent;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public boolean hasAttribute(String name) {
        return this.findAttribute(name) != null;
    }

    public boolean hasAttribute(String name, String namespace) {
        return this.findAttribute(name, namespace) != null;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void insertChild(XMLElement child, int index) {
        XMLElement lastChild;
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (child.getName() == null && !this.children.isEmpty() && (lastChild = this.children.lastElement()).getName() == null) {
            lastChild.setContent(lastChild.getContent() + child.getContent());
            return;
        }
        child.parent = this;
        this.children.insertElementAt(child, index);
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            XMLAttribute attr = this.attributes.elementAt(i);
            if (!attr.getFullName().equals(name)) continue;
            this.attributes.removeElementAt(i);
            return;
        }
    }

    public void removeAttribute(String name, String namespace) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            XMLAttribute attr = this.attributes.elementAt(i);
            boolean found = attr.getName().equals(name);
            found = namespace == null ? (found &= attr.getNamespace() == null) : (found &= attr.getNamespace().equals(namespace));
            if (!found) continue;
            this.attributes.removeElementAt(i);
            return;
        }
    }

    public void removeChild(XMLElement child) {
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        this.children.removeElement(child);
    }

    public void removeChildAtIndex(int index) {
        this.children.removeElementAt(index);
    }

    public void setAttribute(String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            attr = new XMLAttribute(name, name, null, value, "CDATA");
            this.attributes.addElement(attr);
        } else {
            attr.setValue(value);
        }
    }

    public void setAttribute(String fullName, String namespace, String value) {
        if (fullName == null) {
            throw new IllegalArgumentException("fullName must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        int index = fullName.indexOf(58);
        String name = fullName.substring(index + 1);
        XMLAttribute attr = this.findAttribute(name, namespace);
        if (attr == null) {
            attr = new XMLAttribute(fullName, name, namespace, value, "CDATA");
            this.attributes.addElement(attr);
        } else {
            attr.setValue(value);
        }
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.name = name;
        this.fullName = name;
        this.namespace = null;
    }

    public void setName(String fullName, String namespace) {
        if (fullName == null) {
            throw new IllegalArgumentException("fullName must not be null");
        }
        int index = fullName.indexOf(58);
        this.name = namespace == null || index < 0 ? fullName : fullName.substring(index + 1);
        this.fullName = fullName;
        this.namespace = namespace;
    }
}

