/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.n3.nanoxml;

import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import org.freeplane.n3.nanoxml.IXMLBuilder;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLParseException;

class StdXMLBuilder
implements IXMLBuilder {
    private XMLElement prototype;
    private XMLElement root = null;
    private Stack<XMLElement> stack = null;

    public StdXMLBuilder() {
        this(new XMLElement());
    }

    public StdXMLBuilder(XMLElement prototype) {
        this.prototype = prototype;
    }

    public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
        XMLElement top;
        String fullName = key;
        if (nsPrefix != null) {
            fullName = nsPrefix + ':' + key;
        }
        if ((top = this.stack.peek()).hasAttribute(fullName)) {
            throw new XMLParseException(top.getSystemID(), top.getLineNr(), "Duplicate attribute: " + key);
        }
        if (nsPrefix != null) {
            top.setAttribute(fullName, nsURI, value);
        } else {
            top.setAttribute(fullName, value);
        }
    }

    public void addPCData(Reader reader, String systemID, int lineNr) throws XMLParseException {
        int bufSize = 2048;
        int sizeRead = 0;
        StringBuilder str = new StringBuilder(bufSize);
        char[] buf = new char[bufSize];
        while (true) {
            int size;
            if (sizeRead >= bufSize) {
                str.ensureCapacity(bufSize *= 2);
            }
            try {
                size = reader.read(buf);
            }
            catch (IOException e) {
                if (!(e.getCause() instanceof XMLParseException)) break;
                throw (XMLParseException)e.getCause();
            }
            if (size < 0) break;
            str.append(buf, 0, size);
            sizeRead += size;
        }
        XMLElement elt = this.prototype.createElement(null, systemID, lineNr);
        elt.setContent(str.toString());
        if (!this.stack.empty()) {
            XMLElement top = this.stack.peek();
            top.addChild(elt);
        }
    }

    public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) {
    }

    public void endElement(String name, String nsPrefix, String nsURI) {
        XMLElement child;
        XMLElement elt = this.stack.pop();
        if (elt.getChildrenCount() == 1 && (child = elt.getChildAtIndex(0)).getName() == null) {
            elt.setContent(child.getContent());
            elt.removeChildAtIndex(0);
        }
    }

    protected void finalize() throws Throwable {
        this.prototype = null;
        this.root = null;
        this.stack.clear();
        this.stack = null;
        super.finalize();
    }

    public Object getResult() {
        return this.root;
    }

    public void newProcessingInstruction(String target, Reader reader) {
    }

    public void startBuilding(String systemID, int lineNr) {
        this.stack = new Stack();
        this.root = null;
    }

    public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
        String fullName = name;
        if (nsPrefix != null) {
            fullName = nsPrefix + ':' + name;
        }
        XMLElement elt = new XMLElement(fullName, nsURI, systemID, lineNr);
        if (this.stack.empty()) {
            this.root = elt;
        } else {
            XMLElement top = this.stack.peek();
            top.addChild(elt);
        }
        this.stack.push(elt);
    }
}

