/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.headlessmode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.RenderedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollPane;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadlessMapViewController
implements IMapViewManager {
    private final Map<String, MapModel> maps = new HashMap<String, MapModel>();
    Collection<IMapSelectionListener> mapSelectionListeners = new ArrayList<IMapSelectionListener>();
    private MapModel currentMap = null;
    private String currentKey = null;

    @Override
    public void addMapSelectionListener(IMapSelectionListener pListener) {
        this.mapSelectionListeners.add(pListener);
    }

    @Override
    public void addMapViewChangeListener(IMapViewChangeListener pListener) {
    }

    @Override
    public boolean changeToMapView(Component newMapView) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public boolean changeToMapView(String mapViewDisplayName) {
        if (mapViewDisplayName != null && this.maps.containsKey(mapViewDisplayName)) {
            MapModel nextMap = this.maps.get(mapViewDisplayName);
            MapModel oldMap = this.currentMap;
            for (IMapSelectionListener mapSelectionListener : this.mapSelectionListeners) {
                mapSelectionListener.beforeMapChange(oldMap, nextMap);
            }
            this.currentKey = mapViewDisplayName;
            this.currentMap = nextMap;
            for (IMapSelectionListener mapSelectionListener : this.mapSelectionListeners) {
                mapSelectionListener.afterMapChange(oldMap, nextMap);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean changeToMode(String modeName) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public String checkIfFileIsAlreadyOpened(URL urlToCheck) throws MalformedURLException {
        String key = urlToCheck.toString();
        if (this.maps.containsKey(key)) {
            return key;
        }
        return null;
    }

    @Override
    public boolean close(boolean withoutSave) {
        if (this.currentMap == null) {
            return false;
        }
        this.maps.remove(this.currentKey);
        this.currentKey = null;
        this.currentMap = null;
        return true;
    }

    @Override
    public String createHtmlMap() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public RenderedImage createImage(int dpi) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Color getBackgroundColor(NodeModel node) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Component getComponent(NodeModel node) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Font getFont(NodeModel node) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public List<String> getMapKeys() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Map<String, MapModel> getMaps() {
        return this.maps;
    }

    @Override
    public IMapSelection getMapSelection() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Component getMapViewComponent() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public List<? extends Component> getMapViewVector() {
        return Collections.emptyList();
    }

    @Override
    public ModeController getModeController(Component newMap) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public MapModel getModel() {
        return this.currentMap;
    }

    @Override
    public MapModel getModel(Component mapView) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Component getSelectedComponent() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Color getTextColor(NodeModel node) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public float getZoom() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void newMapView(MapModel map, ModeController modeController) {
        String key = map.getURL().toString();
        if (key.equals(this.currentKey)) {
            this.close(true);
        }
        this.maps.put(key, map);
        this.changeToMapView(key);
    }

    @Override
    public void nextMapView() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void previousMapView() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void removeMapSelectionListener(IMapSelectionListener pListener) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void removeMapViewChangeListener(IMapViewChangeListener pListener) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void scrollNodeToVisible(NodeModel node) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void setZoom(float zoom) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public boolean tryToChangeToMapView(String mapView) {
        return this.changeToMapView(mapView);
    }

    @Override
    public boolean tryToChangeToMapView(URL url) throws MalformedURLException {
        if (url == null) {
            return false;
        }
        return this.tryToChangeToMapView(url.toString());
    }

    @Override
    public void updateMapViewName() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public boolean isLeftTreeSupported(Component mapViewComponent) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Map<String, MapModel> getMaps(String modename) {
        return this.maps;
    }

    @Override
    public List<Component> getViews(MapModel map) {
        return Collections.emptyList();
    }

    public JScrollPane getScrollPane() {
        throw new RuntimeException("Method not implemented");
    }

    public Container getViewport() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void updateMenus(MenuBuilder menuBuilder) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void obtainFocusForSelected() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void setTitle() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Object setEdgesRenderingHint(Graphics2D g) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void setTextRenderingHint(Graphics2D g) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public boolean closeAllMaps() {
        this.maps.clear();
        this.currentKey = null;
        this.currentMap = null;
        return true;
    }

    @Override
    public boolean close(Component mapViewComponent, boolean force) {
        throw new RuntimeException("Method not implemented");
    }
}

