/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.applet;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.html.parser.ParserDelegator;
import org.freeplane.core.ui.ShowSelectionAsRectangleAction;
import org.freeplane.features.attribute.ModelessAttributeController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.NextNodeAction;
import org.freeplane.features.filter.NextPresentationItemAction;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.help.HelpController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.MapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.browsemode.BModeController;
import org.freeplane.features.print.PrintController;
import org.freeplane.features.styles.LogicalStyleFilterController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.text.TextController;
import org.freeplane.features.time.TimeController;
import org.freeplane.features.ui.FrameController;
import org.freeplane.main.applet.AppletResourceController;
import org.freeplane.main.applet.AppletViewController;
import org.freeplane.main.browsemode.BModeControllerFactory;
import org.freeplane.view.swing.features.nodehistory.NodeHistory;
import org.freeplane.view.swing.map.MapViewController;
import org.freeplane.view.swing.map.ViewLayoutTypeAction;

public class FreeplaneApplet
extends JApplet {
    private AppletResourceController appletResourceController;
    private static final long serialVersionUID = 1L;
    private AppletViewController appletViewController;
    private Controller controller;
    static final Lock appletLock = new ReentrantLock();

    public void destroy() {
    }

    public void init() {
        try {
            appletLock.lock();
            this.appletResourceController = new AppletResourceController(this);
            if (this.appletResourceController == null) {
                this.appletResourceController = new AppletResourceController(this);
            }
            new ParserDelegator(){
                {
                    1.setDefaultDTD();
                }
            };
            this.updateLookAndFeel();
            this.createRootPane();
            this.controller = new Controller(this.appletResourceController);
            this.appletResourceController.init();
            Controller.setCurrentController(this.controller);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            MapViewController mapViewController = new MapViewController(this.controller);
            this.appletViewController = new AppletViewController(this, this.controller, mapViewController);
            this.controller.addAction(new ViewLayoutTypeAction(MapViewLayout.OUTLINE));
            FilterController.install();
            PrintController.install();
            HelpController.install();
            NodeHistory.install(this.controller);
            FormatController.install(new FormatController());
            ModelessAttributeController.install();
            TextController.install();
            MapController.install();
            TimeController.install();
            LinkController.install();
            IconController.install();
            FilterController.getCurrentFilterController().getConditionFactory().addConditionController(7, new LogicalStyleFilterController());
            BModeController browseController = BModeControllerFactory.createModeController();
            Set<String> emptySet = Collections.emptySet();
            FilterController.getController(this.controller).loadDefaultConditions();
            browseController.updateMenus("/xml/appletMenu.xml", emptySet);
            this.controller.addAction(new ShowSelectionAsRectangleAction());
            this.controller.addAction(new NextNodeAction(MapController.Direction.FORWARD));
            this.controller.addAction(new NextNodeAction(MapController.Direction.BACK));
            this.controller.addAction(new NextPresentationItemAction());
            this.controller.selectMode(browseController);
            this.appletResourceController.setPropertyByParameter(this, "browsemode_initial_map");
            this.appletViewController.init(this.controller);
            GlassPane glassPane = new GlassPane();
            this.setGlassPane(glassPane);
            glassPane.setVisible(true);
            this.controller.getViewController().setMenubarVisible(false);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            appletLock.unlock();
        }
    }

    public void start() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FreeplaneApplet.this.appletViewController.start();
            }
        });
    }

    public void stop() {
        super.stop();
    }

    private void updateLookAndFeel() {
        String lookAndFeel = "";
        this.appletResourceController.setPropertyByParameter(this, "lookandfeel");
        lookAndFeel = this.appletResourceController.getProperty("lookandfeel");
        FrameController.setLookAndFeel(lookAndFeel);
    }

    public Component findComponentAt(int x, int y) {
        Component c = super.findComponentAt(x, y);
        if (c == null) {
            return null;
        }
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (this.controller != Controller.getCurrentController() && currentEvent instanceof MouseEvent && currentEvent.getID() == 503 && appletLock.tryLock()) {
            Controller.setCurrentController(this.controller);
            appletLock.unlock();
        }
        return c;
    }

    public void setWaitingCursor(boolean waiting) {
        Component glassPane = this.getRootPane().getGlassPane();
        if (waiting) {
            glassPane.setCursor(Cursor.getPredefinedCursor(3));
            glassPane.setVisible(true);
        } else {
            glassPane.setCursor(Cursor.getPredefinedCursor(0));
            glassPane.setVisible(false);
        }
    }

    private class GlassPane
    extends JComponent {
        public GlassPane() {
            this.addMouseListener(new MouseAdapter(){});
        }

        protected void processMouseEvent(MouseEvent e) {
            if (e.getID() == 505) {
                return;
            }
            Controller currentController = Controller.getCurrentController();
            if (FreeplaneApplet.this.controller != currentController) {
                if (!appletLock.tryLock()) {
                    return;
                }
                Controller.setCurrentController(FreeplaneApplet.this.controller);
                appletLock.unlock();
                JOptionPane.getFrameForComponent(this).getMostRecentFocusOwner().requestFocus();
                if (currentController != null) {
                    currentController.getViewController().getRootPaneContainer().getGlassPane().setVisible(true);
                }
            }
            this.setVisible(false);
        }
    }
}

