/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.applet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.FrameController;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.main.applet.FreeplaneApplet;
import org.freeplane.view.swing.map.MapViewScrollPane;

class AppletViewController
extends FrameController
implements IMapViewChangeListener {
    private final FreeplaneApplet applet;
    private JComponent mComponentInSplitPane;
    private JComponent mapContentBox;
    private JScrollPane scrollPane;

    public AppletViewController(FreeplaneApplet applet, Controller controller, IMapViewManager mapViewController) {
        super(controller, mapViewController, "");
        this.applet = applet;
        mapViewController.addMapViewChangeListener(this);
    }

    public RootPaneContainer getRootPaneContainer() {
        return this.applet;
    }

    public FreeplaneMenuBar getFreeplaneMenuBar() {
        return (FreeplaneMenuBar)this.applet.getJMenuBar();
    }

    public FreeplaneVersion getFreeplaneVersion() {
        return FreeplaneVersion.getVersion();
    }

    public JFrame getJFrame() {
        throw new IllegalArgumentException("The applet has no frames");
    }

    public void init(Controller controller) {
        this.mapContentBox = new JPanel(new BorderLayout());
        this.scrollPane = new MapViewScrollPane();
        this.mapContentBox.add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.mapContentBox, "Center");
        super.init(controller);
        SwingUtilities.updateComponentTreeUI(this.applet);
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                    }
                });
            }
            catch (InterruptedException e) {
                LogUtils.severe(e);
            }
            catch (InvocationTargetException e) {
                LogUtils.severe(e);
            }
        }
        this.getController().selectMode("Browse");
        String initialMapName = ResourceController.getResourceController().getProperty("browsemode_initial_map");
        if (initialMapName != null && initialMapName.startsWith(".")) {
            String locationUrl = this.applet.getParameter("location_href");
            try {
                URI uri = new URI(locationUrl).resolve(new URI(null, null, initialMapName, null));
                URL documentBase = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
                initialMapName = documentBase.toString();
            }
            catch (Exception e) {
                UITools.errorMessage(TextUtils.format("map_load_error", initialMapName));
                System.err.println(e);
                return;
            }
        }
        if (initialMapName != "") {
            try {
                URL mapUrl = new URL(initialMapName);
                this.getController().getModeController().getMapController().newMap(mapUrl);
            }
            catch (Exception e) {
                LogUtils.severe(e);
            }
        }
    }

    public void insertComponentIntoSplitPane(JComponent pMindMapComponent) {
        if (this.mComponentInSplitPane == pMindMapComponent) {
            return;
        }
        this.removeSplitPane();
        this.mComponentInSplitPane = pMindMapComponent;
        this.mapContentBox.add((Component)pMindMapComponent, "South");
        this.mapContentBox.revalidate();
    }

    public boolean isApplet() {
        return true;
    }

    public void openDocument(URI location) {
        try {
            String scheme = location.getScheme();
            String host = location.getHost();
            String path = location.isOpaque() ? location.getSchemeSpecificPart() : location.getPath();
            int port = location.getPort();
            String query = location.getQuery();
            String fragment = location.getFragment();
            StringBuilder file = new StringBuilder(path);
            if (query != null) {
                file.append('?');
                file.append(query);
            }
            if (fragment != null) {
                file.append('#');
                file.append(fragment);
            }
            URL url = new URL(scheme, host, port, file.toString());
            this.openDocument(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void openDocument(URL doc) {
        this.applet.getAppletContext().showDocument(doc, "_blank");
    }

    public void removeSplitPane() {
        if (this.mComponentInSplitPane != null) {
            this.mapContentBox.remove(this.mComponentInSplitPane);
            this.mapContentBox.revalidate();
            this.mComponentInSplitPane = null;
        }
    }

    protected void setFreeplaneMenuBar(FreeplaneMenuBar menuBar) {
        this.applet.setJMenuBar(menuBar);
    }

    public void setTitle(String frameTitle) {
    }

    public void setWaitingCursor(boolean waiting) {
        this.applet.setWaitingCursor(waiting);
    }

    public void start() {
        try {
            IMapSelection selection = this.getController().getSelection();
            if (selection != null) {
                selection.selectRoot();
            } else {
                System.err.println("View is null.");
            }
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
    }

    public void afterViewChange(Component oldView, Component newView) {
        if (this.scrollPane != null) {
            this.scrollPane.setViewportView(newView);
        }
    }

    public void afterViewClose(Component oldView) {
    }

    public void afterViewCreated(Component mapView) {
    }

    public void beforeViewChange(Component oldView, Component newView) {
    }
}

