/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.addons;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.main.addons.AddOnInstaller;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddOnsController {
    private static final String ADDONS_DIR = "addons";
    private static AddOnsController addOnsController;
    private List<AddOnProperties> installedAddOns = new ArrayList<AddOnProperties>();
    private boolean autoInstall;
    public static final String LATEST_VERSION_FILE = "version.properties";

    public AddOnsController() {
        this.createAddOnsDirIfNecessary();
        this.registerPlugins();
        this.autoInstall = true;
    }

    private void createAddOnsDirIfNecessary() {
        File addOnsDir = this.getAddOnsDir();
        if (addOnsDir != null && !addOnsDir.exists()) {
            LogUtils.info("creating user add-ons directory " + addOnsDir);
            addOnsDir.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPlugins() {
        File addOnsDir = this.getAddOnsDir();
        if (addOnsDir == null) {
            return;
        }
        File[] addonXmlFiles = addOnsDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".plugin.xml");
            }
        });
        IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
        for (File file : addonXmlFiles) {
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
                StdXMLReader reader = new StdXMLReader(inputStream);
                parser.setReader(reader);
                this.registerInstalledAddOn(new AddOnProperties(AddOnProperties.AddOnType.PLUGIN, (XMLElement)parser.parse()));
            }
            catch (Exception e) {
                try {
                    LogUtils.warn("error parsing " + file, e);
                }
                catch (Throwable throwable) {
                    FileUtils.silentlyClose(inputStream);
                    throw throwable;
                }
                FileUtils.silentlyClose(inputStream);
                continue;
            }
            FileUtils.silentlyClose(inputStream);
        }
    }

    public static AddOnsController getController() {
        if (addOnsController == null) {
            addOnsController = new AddOnsController();
        }
        return addOnsController;
    }

    public List<AddOnProperties> getInstalledAddOns() {
        return Collections.unmodifiableList(this.installedAddOns);
    }

    public void registerInstalledAddOn(AddOnProperties addOn) {
        ModeController modeController;
        this.installedAddOns.add(addOn);
        ResourceController resourceController = ResourceController.getResourceController();
        if (addOn.getDefaultProperties() != null) {
            resourceController.addDefaults(addOn.getDefaultProperties());
        }
        if (addOn.getPreferencesXml() != null && (modeController = Controller.getCurrentModeController()) instanceof MModeController) {
            ((MModeController)modeController).getOptionPanelBuilder().load(new StringReader(addOn.getPreferencesXml()));
        }
        if (addOn.getTranslations() != null) {
            AddOnsController.registerAddOnResources(addOn, resourceController);
        }
    }

    public static void registerAddOnResources(AddOnProperties addOn, ResourceController resourceController) {
        HashSet<String> languages = new HashSet<String>();
        languages.add(resourceController.getLanguageCode());
        languages.add(resourceController.getDefaultLanguageCode());
        for (String language : languages) {
            Map<String, String> resources = addOn.getTranslations().get(language);
            if (resources == null) continue;
            for (Map.Entry<String, String> entry : resources.entrySet()) {
                if (entry.getValue().indexOf(92) == -1) continue;
                entry.setValue(StringEscapeUtils.unescapeJava((String)entry.getValue()));
            }
            resourceController.addLanguageResources(language, AddOnsController.addOptionPanelPrefix(resources, addOn.getName()));
            resourceController.addLanguageResources(language, resources);
        }
    }

    private static Map<String, String> addOptionPanelPrefix(Map<String, String> resources, String addOnName) {
        HashMap<String, String> result = new HashMap<String, String>(resources.size());
        for (Map.Entry<String, String> entry : resources.entrySet()) {
            result.put("OptionPanel." + entry.getKey(), entry.getValue());
        }
        String nameKey = "addons." + addOnName;
        result.put("OptionPanel.separator." + nameKey, resources.get(nameKey));
        return result;
    }

    public File getAddOnsDir() {
        String userDir = ResourceController.getResourceController().getFreeplaneUserDirectory();
        return userDir == null ? null : new File(userDir, ADDONS_DIR);
    }

    public void save(AddOnProperties addOn) throws IOException {
        File addOnsDir = this.getAddOnsDir();
        if (addOnsDir != null) {
            File file = addOn.getAddOnPropertiesFile();
            if (file == null) {
                file = new File(addOnsDir, addOn.getName() + "." + addOn.getAddOnType().name().toLowerCase() + ".xml");
            }
            FileUtils.dumpStringToFile(addOn.toXmlString(), file, "UTF-8");
        }
    }

    public void deinstall(AddOnProperties addOn) {
        LogUtils.info("deinstalling " + addOn);
        for (String[] rule : addOn.getDeinstallationRules()) {
            if (!rule[0].equals("delete")) continue;
            File file = new File(this.expandVariables(rule));
            if (!file.exists()) {
                LogUtils.warn("file " + this.expandVariables(rule) + " should be deleted but does not exist");
                continue;
            }
            if (file.delete()) {
                LogUtils.info("deleted " + this.expandVariables(rule));
                continue;
            }
            LogUtils.warn("could not delete file " + this.expandVariables(rule));
        }
        this.installedAddOns.remove(addOn);
    }

    private String expandVariables(String[] rule) {
        return rule[1].replace("${installationbase}", ResourceController.getResourceController().getFreeplaneUserDirectory());
    }

    public boolean installIfAppropriate(URL url) {
        if (!this.autoInstall) {
            return false;
        }
        if (url.getFile().endsWith(".addon.mm")) {
            AddOnInstaller installer = Controller.getCurrentModeController().getExtension(AddOnInstaller.class);
            if (installer == null) {
                LogUtils.warn("no AddOnInstaller registered. Cannot install " + url);
                return false;
            }
            UITools.backOtherWindows();
            int selection = UITools.showConfirmDialog(null, TextUtils.format("newmap.install.addon.question", new File(url.getFile()).getName()), TextUtils.getText("newmap.install.addon.title"), 0, -1);
            if (selection == 0) {
                installer.install(url);
                return true;
            }
        }
        return false;
    }

    public void setAutoInstallEnabled(boolean autoInstall) {
        this.autoInstall = autoInstall;
    }

    public boolean isAutoInstallEnabled() {
        return this.autoInstall;
    }

    public AddOnProperties getInstalledAddOn(String name) {
        for (AddOnProperties addOn : this.installedAddOns) {
            if (!addOn.getName().equals(name)) continue;
            return addOn;
        }
        return null;
    }
}

