/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.url.FreeplaneUriConverter;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.n3.nanoxml.XMLParseException;

public class UrlManager
implements IExtension {
    public static final String SMB_SCHEME = "smb";
    public static final String FREEPLANE_SCHEME = "freeplane";
    public static final String FILE_SCHEME = "file";
    public static final String FREEPLANE_FILE_EXTENSION_WITHOUT_DOT = "mm";
    public static final String FREEPLANE_FILE_EXTENSION = ".mm";
    public static final String FREEPLANE_ADD_ON_FILE_EXTENSION = ".addon.mm";
    private static File lastCurrentDir = null;
    public static final String MAP_URL = "map_url";

    public static UrlManager getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return modeController.getExtension(UrlManager.class);
    }

    public static void install(UrlManager urlManager) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(UrlManager.class, urlManager);
        urlManager.init();
    }

    protected void init() {
        this.createActions();
    }

    private void createActions() {
    }

    public JFileChooser getFileChooser(FileFilter filter, boolean useDirectorySelector) {
        return this.getFileChooser(filter, useDirectorySelector, false);
    }

    public JFileChooser getFileChooser(FileFilter filter, boolean useDirectorySelector, boolean showHiddenFiles) {
        File parentFile = this.getMapsParentFile(Controller.getCurrentController().getMap());
        if (parentFile != null && this.getLastCurrentDir() == null) {
            this.setLastCurrentDir(parentFile);
        }
        JFileChooser chooser = new JFileChooser(){

            protected JDialog createDialog(Component parent) throws HeadlessException {
                final JDialog dialog = super.createDialog(parent);
                JComponent selector = UrlManager.this.createDirectorySelector(this);
                InputMap in = dialog.getRootPane().getInputMap(2);
                in.put(KeyStroke.getKeyStroke(27, 0), "escape");
                ActionMap aMap = dialog.getRootPane().getActionMap();
                aMap.put("escape", new AbstractAction(){

                    public void actionPerformed(ActionEvent e) {
                        dialog.dispose();
                    }
                });
                if (selector != null) {
                    dialog.getContentPane().add((Component)selector, "North");
                    dialog.pack();
                }
                return dialog;
            }
        };
        if (this.getLastCurrentDir() != null) {
            chooser.setCurrentDirectory(this.getLastCurrentDir());
        }
        if (showHiddenFiles) {
            chooser.setFileHidingEnabled(false);
        }
        if (filter != null) {
            chooser.addChoosableFileFilter(filter);
            chooser.setFileFilter(filter);
        }
        return chooser;
    }

    protected JComponent createDirectorySelector(JFileChooser chooser) {
        return null;
    }

    public File getLastCurrentDir() {
        return lastCurrentDir;
    }

    protected File getMapsParentFile(MapModel map) {
        if (map != null && map.getFile() != null && map.getFile().getParentFile() != null) {
            return map.getFile().getParentFile();
        }
        return null;
    }

    public void handleLoadingException(Exception ex) {
        String exceptionType = ex.getClass().getName();
        if (exceptionType.equals(XMLParseException.class.getName())) {
            int showDetail = JOptionPane.showConfirmDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent(), TextUtils.getText("map_corrupted"), "Freeplane", 0, 0);
            if (showDetail == 0) {
                UITools.errorMessage(ex);
            }
        } else if (exceptionType.equals(FileNotFoundException.class.getName())) {
            UITools.errorMessage(ex.getMessage());
        } else {
            if (exceptionType.equals("org.freeplane.features.url.mindmapmode.SkipException")) {
                return;
            }
            LogUtils.severe(ex);
            UITools.errorMessage(ex);
        }
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public boolean loadCatchExceptions(URL url, MapModel map) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public InputStreamReader load(URL url, MapModel map) throws IOException, XMLException {
        this.setURL(map, url);
        InputStreamReader urlStreamReader = new InputStreamReader(url.openStream());
        ModeController modeController = Controller.getCurrentModeController();
        modeController.getMapController().getMapReader().createNodeTreeFromXml(map, (Reader)urlStreamReader, MapWriter.Mode.FILE);
        return urlStreamReader;
    }

    @Deprecated
    public boolean loadImpl(URL url, MapModel map) {
        return this.loadCatchExceptions(url, map);
    }

    @Deprecated
    public void loadURL(URI uri) {
        String uriString = uri.toString();
        if (uriString.startsWith("#")) {
            String target = uri.getFragment();
            try {
                ModeController modeController = Controller.getCurrentModeController();
                MapController mapController = modeController.getMapController();
                NodeModel node = mapController.getNodeFromID(target);
                if (node != null) {
                    mapController.select(node);
                }
            }
            catch (Exception e) {
                LogUtils.warn("link " + target + " not found", e);
                UITools.errorMessage(TextUtils.format("link_not_found", target));
            }
            return;
        }
        try {
            String extension = FileUtils.getExtension(uri.getRawPath());
            if (!uri.isAbsolute()) {
                URI absoluteUri = this.getAbsoluteUri(uri);
                if (absoluteUri == null) {
                    MapModel map = Controller.getCurrentController().getMap();
                    if (map.getURL() == null) {
                        UITools.errorMessage(TextUtils.getText("map_not_saved"));
                    } else {
                        UITools.errorMessage(TextUtils.format("link_not_found", String.valueOf(uri)));
                    }
                    return;
                }
                uri = absoluteUri;
            }
            if (!Arrays.asList(FILE_SCHEME, SMB_SCHEME, FREEPLANE_SCHEME).contains(uri.getScheme())) {
                try {
                    uri = uri.toURL().openConnection().getURL().toURI().normalize();
                }
                catch (Exception e) {
                    LogUtils.warn("link " + uri + " not found", e);
                    UITools.errorMessage(TextUtils.format("link_not_found", uri.toString()));
                }
            }
            try {
                if (extension != null && extension.equals(FREEPLANE_FILE_EXTENSION_WITHOUT_DOT)) {
                    FreeplaneUriConverter freeplaneUriConverter = new FreeplaneUriConverter();
                    URL url = freeplaneUriConverter.freeplaneUrl(uri);
                    ModeController modeController = Controller.getCurrentModeController();
                    modeController.getMapController().newMap(url);
                    String ref = uri.getFragment();
                    if (ref != null) {
                        ModeController newModeController = Controller.getCurrentModeController();
                        MapController newMapController = newModeController.getMapController();
                        newMapController.select(newMapController.getNodeFromID(ref));
                    }
                    return;
                }
                Controller.getCurrentController().getViewController().openDocument(uri);
            }
            catch (Exception e) {
                LogUtils.warn("link " + uri + " not found", e);
                UITools.errorMessage(TextUtils.format("link_not_found", uri.toString()));
            }
            return;
        }
        catch (MalformedURLException ex) {
            LogUtils.warn("URL " + uriString + " not found", ex);
            UITools.errorMessage(TextUtils.format("link_not_found", uriString));
            return;
        }
    }

    private URI getAbsoluteUri(URI uri) throws MalformedURLException {
        if (uri.isAbsolute()) {
            return uri;
        }
        MapModel map = Controller.getCurrentController().getMap();
        return this.getAbsoluteUri(map, uri);
    }

    public URI getAbsoluteUri(MapModel map, URI uri) throws MalformedURLException {
        URI resolvedURI;
        try {
            resolvedURI = uri.toURL().openConnection().getURL().toURI();
        }
        catch (IOException ex) {
            LogUtils.severe(ex);
            return null;
        }
        catch (URISyntaxException ex) {
            LogUtils.severe(ex);
            return null;
        }
        catch (IllegalArgumentException ex) {
            resolvedURI = uri;
        }
        if (resolvedURI.isAbsolute()) {
            return resolvedURI;
        }
        String path = resolvedURI.getPath();
        try {
            URL context = map.getURL();
            if (context == null) {
                return null;
            }
            URL url = new URL(context, path);
            return new URI(url.getProtocol(), url.getHost(), url.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            LogUtils.severe(e);
            return null;
        }
    }

    public File getAbsoluteFile(MapModel map, URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            URLConnection urlConnection = Compat.isWindowsOS() && uri.getScheme() != null && uri.getScheme().length() == 1 ? new File(uri.toString()).toURI().toURL().openConnection() : (uri.getScheme() == null && !uri.getPath().startsWith(File.separator) ? (map != null ? new File(uri.toString()).toURI().toURL().openConnection() : UrlManager.getController().getAbsoluteUri(map, uri).toURL().openConnection()) : uri.toURL().openConnection());
            if (urlConnection == null) {
                return null;
            }
            URI absoluteUri = urlConnection.getURL().toURI().normalize();
            if (FILE_SCHEME.equalsIgnoreCase(absoluteUri.getScheme())) {
                return new File(absoluteUri);
            }
        }
        catch (URISyntaxException e) {
            LogUtils.warn(e);
        }
        catch (IOException e) {
            LogUtils.warn(e);
        }
        catch (Exception e) {
            LogUtils.warn(e);
        }
        return null;
    }

    public URL getAbsoluteUrl(MapModel map, URI uri) throws MalformedURLException {
        String fragment;
        String path = uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getPath();
        StringBuilder sb = new StringBuilder(path);
        String query = uri.getQuery();
        if (query != null) {
            sb.append('?');
            sb.append(query);
        }
        if ((fragment = uri.getFragment()) != null) {
            sb.append('#');
            sb.append(fragment);
        }
        if (!uri.isAbsolute() || uri.isOpaque() || uri.getScheme().length() > 0) {
            URL mapUrl = map.getURL();
            String scheme = uri.getScheme();
            if (scheme == null || mapUrl.getProtocol().equals(scheme)) {
                URL url = new URL(mapUrl, sb.toString());
                return url;
            }
        }
        URL url = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), sb.toString());
        return url;
    }

    public URL getAbsoluteUrl(URI base, URI uri) throws MalformedURLException {
        String fragment;
        String path = uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getPath();
        StringBuilder sb = new StringBuilder(path);
        String query = uri.getQuery();
        if (query != null) {
            sb.append('?');
            sb.append(query);
        }
        if ((fragment = uri.getFragment()) != null) {
            sb.append('#');
            sb.append(fragment);
        }
        if (!uri.isAbsolute() || uri.isOpaque() || uri.getScheme().length() > 0) {
            URL baseUrl = base.toURL();
            String scheme = uri.getScheme();
            if (scheme == null || baseUrl.getProtocol().equals(scheme)) {
                URL url = new URL(baseUrl, sb.toString());
                return url;
            }
        }
        URL url = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), sb.toString());
        return url;
    }

    public void setLastCurrentDir(File lastCurrentDir) {
        UrlManager.lastCurrentDir = lastCurrentDir;
    }

    protected void setURL(MapModel map, URL url) {
        map.setURL(url);
    }

    public File defaultTemplateFile() {
        return null;
    }
}

