/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class CleaningInputStream
extends InputStream {
    private static final int MAX_PUSHED_BACK = 4;
    private final PushbackInputStream in;
    private int pushedBack = 0;
    private boolean isUtf8 = false;

    public CleaningInputStream(InputStream pIn) {
        this.in = new PushbackInputStream(pIn, 4);
        try {
            byte[] bytes = new byte[3];
            int i = 0;
            int b = this.in.read();
            bytes[i++] = (byte)b;
            if (b == 239) {
                b = this.in.read();
                bytes[i++] = (byte)b;
                if (b == 187) {
                    b = this.in.read();
                    bytes[i++] = (byte)b;
                    if (b == 191) {
                        this.isUtf8 = true;
                        return;
                    }
                }
            }
            this.in.unread(bytes, 0, i);
            this.pushedBack = i;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isUtf8() {
        return this.isUtf8;
    }

    public int read() throws IOException {
        byte b = (byte)this.in.read();
        if (this.pushedBack > 0) {
            --this.pushedBack;
            return b;
        }
        if (b == 38) {
            byte[] bytes = new byte[4];
            int i = 0;
            bytes[i++] = b = (byte)this.in.read();
            if (b == 35) {
                bytes[i++] = b = (byte)this.in.read();
                if (b == 120 || b >= 48 || b <= 51) {
                    bytes[i++] = (byte)this.in.read();
                    bytes[i++] = (byte)this.in.read();
                }
            }
            if (this.isValidInput(i, bytes)) {
                this.pushedBack = i;
                this.in.unread(bytes, 0, i);
                return 38;
            }
            return 32;
        }
        return b;
    }

    private boolean isValidInput(int i, byte[] bytes) {
        if (i != 4 || bytes[i - 1] != 59) {
            return true;
        }
        int c = bytes[1] == 120 ? Character.digit(bytes[2], 16) : Character.digit(bytes[1], 10) * 10 + Character.digit(bytes[2], 10);
        return c >= 32 || c == 9 || c == 13 || c == 10;
    }
}

