/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.ui;

import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.FrameController;

@SelectableAction(checkOnPopup=true)
public class ToggleToolbarAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final String toolbarName;

    public ToggleToolbarAction(String actionName, String toolbarName) {
        super(actionName);
        this.toolbarName = toolbarName;
    }

    public void actionPerformed(ActionEvent event) {
        ResourceController resourceController = ResourceController.getResourceController();
        JComponent toolBar = this.getToolbar();
        String propertyName = Controller.getCurrentController().getViewController().completeVisiblePropertyKey(toolBar);
        boolean wasVisible = resourceController.getBooleanProperty(propertyName);
        boolean visible = !wasVisible;
        resourceController.setProperty(propertyName, visible);
        this.setVisible(toolBar, visible);
    }

    protected void setVisible(JComponent toolBar, boolean visible) {
        toolBar.setVisible(visible);
        ((JComponent)toolBar.getParent()).revalidate();
    }

    private JComponent getToolbar() {
        JComponent toolBar = Controller.getCurrentModeController().getUserInputListenerFactory().getToolBar(this.toolbarName);
        return toolBar;
    }

    public void setSelected() {
        boolean isVisible = this.isVisible();
        this.setSelected(isVisible);
    }

    public boolean isVisible() {
        JComponent toolBar = this.getToolbar();
        boolean isVisible = ((FrameController)Controller.getCurrentController().getViewController()).isToolbarVisible(toolBar);
        return isVisible;
    }

    public void afterMapChange(Object newMap) {
    }
}

