/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalFileChooserUI;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.FixedBasicComboBoxEditor;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.ContainerComboBoxEditor;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.format.FormattedObject;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.StyleNamedObject;
import org.freeplane.features.time.TimeComboBoxEditor;
import org.freeplane.features.ui.CloseAction;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ToggleFullScreenAction;
import org.freeplane.features.ui.ToggleMenubarAction;
import org.freeplane.features.ui.ToggleScrollbarsAction;
import org.freeplane.features.ui.ToggleToolbarAction;
import org.freeplane.features.ui.ViewController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FrameController
implements ViewController {
    private final JLabel status;
    private final Map<String, Component> statusInfos;
    private final JPanel statusPanel;
    private final JComponent[] toolbarPanel;
    private Rectangle frameSize;
    private int winState;
    private final String propertyKeyPrefix;
    public static Icon textIcon;
    public static Icon numberIcon;
    public static Icon dateIcon;
    public static Icon dateTimeIcon;
    public static Icon linkIcon;
    public static Icon localLinkIcon;

    @Override
    public Rectangle getFrameSize() {
        return this.frameSize;
    }

    @Override
    public void setFrameSize(Rectangle frameSize) {
        this.frameSize = frameSize;
    }

    public FrameController(Controller controller, IMapViewManager mapViewManager, String propertyKeyPrefix) {
        ResourceController resourceController = ResourceController.getResourceController();
        if (textIcon == null) {
            textIcon = new ImageIcon(resourceController.getResource("/images/text.png"));
            numberIcon = new ImageIcon(resourceController.getResource("/images/number.png"));
            dateIcon = new ImageIcon(resourceController.getResource("/images/calendar_red.png"));
            dateTimeIcon = new ImageIcon(resourceController.getResource("/images/calendar_clock_red.png"));
            linkIcon = new ImageIcon(resourceController.getResource("/images/" + resourceController.getProperty("link_icon")));
            localLinkIcon = new ImageIcon(resourceController.getResource("/images/" + resourceController.getProperty("link_local_icon")));
        }
        this.propertyKeyPrefix = propertyKeyPrefix;
        this.statusPanel = new JPanel(new FlowLayout(0, 3, 0));
        this.statusPanel.putClientProperty("VISIBLE_PROPERTY_KEY", "status_visible");
        this.status = new JLabel();
        this.status.setBorder(BorderFactory.createEtchedBorder());
        this.statusPanel.add(this.status);
        this.statusInfos = new HashMap<String, Component>();
        this.statusInfos.put("standard", this.status);
        controller.setViewController(this);
        controller.addAction(new ToggleFullScreenAction(this));
        controller.addAction(new CloseAction());
        controller.addAction(new ToggleMenubarAction(this));
        controller.addAction(new ToggleScrollbarsAction(this));
        controller.addAction(new ToggleToolbarAction("ToggleToolbarAction", "/main_toolbar"));
        controller.addAction(new ToggleToolbarAction("ToggleStatusAction", "/status"));
        this.toolbarPanel = new JComponent[4];
        this.toolbarPanel[0] = new HorizontalToolbarPanel(new FlowLayout(0, 0, 0));
        this.toolbarPanel[3] = Box.createHorizontalBox();
        this.toolbarPanel[1] = Box.createHorizontalBox();
        this.toolbarPanel[2] = Box.createVerticalBox();
    }

    @Override
    public void changeNoteWindowLocation() {
    }

    @Override
    public void err(String msg) {
        this.status.setText(msg);
    }

    @Override
    public abstract RootPaneContainer getRootPaneContainer();

    @Override
    public Container getContentPane() {
        return this.getRootPaneContainer().getContentPane();
    }

    protected Controller getController() {
        return Controller.getCurrentController();
    }

    @Override
    public Frame getFrame() {
        return JOptionPane.getFrameForComponent(this.getContentPane());
    }

    @Override
    public abstract FreeplaneMenuBar getFreeplaneMenuBar();

    @Override
    public abstract JFrame getJFrame();

    @Override
    public JComponent getStatusBar() {
        return this.statusPanel;
    }

    @Override
    public void init(Controller controller) {
        this.getContentPane().add((Component)this.toolbarPanel[0], "North");
        this.getContentPane().add((Component)this.toolbarPanel[1], "West");
        this.getContentPane().add((Component)this.toolbarPanel[2], "East");
        this.getContentPane().add((Component)this.toolbarPanel[3], "South");
        this.status.setText("");
        this.getRootPaneContainer().getRootPane().putClientProperty(Controller.class, controller);
        Frame frame = this.getFrame();
        frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Frame frame = (Frame)e.getComponent();
                if (frame.getExtendedState() != 0 || FrameController.this.isFullScreenEnabled()) {
                    return;
                }
                FrameController.this.frameSize = frame.getBounds();
            }

            public void componentMoved(ComponentEvent e) {
                this.componentResized(e);
            }
        });
    }

    @Override
    public abstract void insertComponentIntoSplitPane(JComponent var1);

    @Override
    public abstract boolean isApplet();

    @Override
    public boolean isMenubarVisible() {
        return this.isComponentVisible("menubar");
    }

    @Override
    public boolean areScrollbarsVisible() {
        return this.isComponentVisible("scrollbars");
    }

    private boolean isComponentVisible(String component) {
        String property = this.isFullScreenEnabled() ? component + "Visible.fullscreen" : component + "Visible";
        boolean booleanProperty = ResourceController.getResourceController().getBooleanProperty(this.getPropertyKeyPrefix() + property);
        return booleanProperty;
    }

    @Override
    public abstract void openDocument(URI var1) throws IOException;

    @Override
    public abstract void openDocument(URL var1) throws Exception;

    @Override
    public void out(String msg) {
        this.status.setText(msg);
    }

    @Override
    public void addStatusInfo(String key, String info) {
        this.addStatusInfo(key, info, null, null);
    }

    @Override
    public void addStatusInfo(String key, Icon icon) {
        this.addStatusInfo(key, null, icon, null);
    }

    @Override
    public void addStatusInfo(String key, String info, Icon icon) {
        this.addStatusInfo(key, info, icon, null);
    }

    @Override
    public void addStatusInfo(String key, String info, Icon icon, String tooltip) {
        JLabel label = (JLabel)this.statusInfos.get(key);
        if (label == null) {
            label = new JLabel(info);
            label.setBorder(BorderFactory.createEtchedBorder());
            this.statusInfos.put(key, label);
            this.statusPanel.add((Component)label, this.statusPanel.getComponentCount() - 1);
        } else {
            label.setText(info);
            label.revalidate();
            label.repaint();
        }
        label.setIcon(icon);
        label.setToolTipText(tooltip);
        label.setVisible(info != null || icon != null);
    }

    @Override
    public void addStatusComponent(String key, Component component) {
        Component oldComponent = this.statusInfos.put(key, component);
        if (oldComponent == null) {
            this.statusPanel.add(component, this.statusPanel.getComponentCount() - 1);
        } else {
            int index = UITools.getComponentIndex(component);
            this.statusPanel.remove(index);
            this.statusPanel.add(component, index);
        }
    }

    @Override
    public void removeStatus(String key) {
        Component oldComponent = this.statusInfos.remove(key);
        if (oldComponent == null) {
            return;
        }
        this.statusPanel.remove(oldComponent);
    }

    @Override
    public abstract void removeSplitPane();

    @Override
    public void saveProperties() {
    }

    @Override
    public void selectMode(ModeController oldModeController, ModeController newModeController) {
        int j;
        if (oldModeController == newModeController) {
            return;
        }
        if (oldModeController != null) {
            IUserInputListenerFactory userInputListenerFactory = oldModeController.getUserInputListenerFactory();
            for (j = 0; j < 4; ++j) {
                Iterable<JComponent> modeToolBars = userInputListenerFactory.getToolBars(j);
                if (modeToolBars == null) continue;
                for (Component component : modeToolBars) {
                    this.toolbarPanel[j].remove(component);
                }
                this.toolbarPanel[j].revalidate();
            }
        }
        IUserInputListenerFactory newUserInputListenerFactory = newModeController.getUserInputListenerFactory();
        for (j = 0; j < 4; ++j) {
            Iterable<JComponent> newToolBars = newUserInputListenerFactory.getToolBars(j);
            if (newToolBars == null) continue;
            int i = 0;
            for (JComponent toolBar : newToolBars) {
                toolBar.setVisible(this.isToolbarVisible(toolBar));
                this.toolbarPanel[j].add((Component)toolBar, i++);
            }
            this.toolbarPanel[j].revalidate();
            this.toolbarPanel[j].repaint();
        }
        this.setFreeplaneMenuBar(newUserInputListenerFactory.getMenuBar());
        this.setUIComponentsVisible(newModeController.getController().getMapViewManager());
    }

    private void setUIComponentsVisible(IMapViewManager iMapViewManager) {
        this.getFreeplaneMenuBar().setVisible(this.isMenubarVisible());
    }

    protected abstract void setFreeplaneMenuBar(FreeplaneMenuBar var1);

    @Override
    public void setMenubarVisible(boolean visible) {
        FreeplaneMenuBar freeplaneMenuBar = this.getFreeplaneMenuBar();
        this.setComponentVisibleProperty("menubar", visible);
        freeplaneMenuBar.setVisible(visible);
    }

    @Override
    public void setScrollbarsVisible(boolean visible) {
        this.setComponentVisibleProperty("scrollbars", visible);
    }

    private void setComponentVisibleProperty(String componentName, boolean visible) {
        String property = this.isFullScreenEnabled() ? componentName + "Visible.fullscreen" : componentName + "Visible";
        ResourceController.getResourceController().setProperty(this.getPropertyKeyPrefix() + property, visible);
    }

    @Override
    public abstract void setTitle(String var1);

    @Override
    public abstract void setWaitingCursor(boolean var1);

    @Override
    public void viewNumberChanged(int number) {
    }

    void setFullScreen(boolean fullScreen) {
        Frame frame = this.getFrame();
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (fullScreen == this.isFullScreenEnabled()) {
            return;
        }
        Controller controller = this.getController();
        ResourceController.getResourceController().firePropertyChanged("fullscreen_enabled", Boolean.toString(!fullScreen), Boolean.toString(fullScreen));
        Collection<Window> visibleFrames = this.collectVisibleFrames(frame);
        if (fullScreen) {
            this.winState = frame.getExtendedState();
            frame.dispose();
            frame.setExtendedState(6);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setBounds(0, 0, screenSize.width, screenSize.height);
            frame.setUndecorated(true);
            frame.setResizable(false);
            this.setUIComponentsVisible(controller.getMapViewManager());
            for (int j = 0; j < 4; ++j) {
                Iterable<JComponent> toolBars = controller.getModeController().getUserInputListenerFactory().getToolBars(j);
                for (JComponent toolBar : toolBars) {
                    toolBar.setVisible(this.isToolbarVisible(toolBar));
                }
            }
            this.showWindows(visibleFrames);
        } else {
            frame.dispose();
            frame.setUndecorated(false);
            frame.setResizable(true);
            frame.setBounds(this.frameSize);
            frame.setExtendedState(this.winState);
            this.setUIComponentsVisible(controller.getMapViewManager());
            for (int j = 0; j < 4; ++j) {
                Iterable<JComponent> toolBars = controller.getModeController().getUserInputListenerFactory().getToolBars(j);
                for (JComponent toolBar : toolBars) {
                    toolBar.setVisible(this.isToolbarVisible(toolBar));
                }
            }
            this.showWindows(visibleFrames);
        }
        if (focusOwner != null) {
            focusOwner.requestFocus();
        }
    }

    private Collection<Window> collectVisibleFrames(Window window) {
        if (!window.isVisible()) {
            return Collections.emptyList();
        }
        Window[] ownedWindows = window.getOwnedWindows();
        ArrayList<Window> visibleWindows = new ArrayList<Window>(ownedWindows.length + 1);
        visibleWindows.add(window);
        for (Window child : ownedWindows) {
            visibleWindows.addAll(this.collectVisibleFrames(child));
        }
        return visibleWindows;
    }

    protected void showWindows(Iterable<Window> windows) {
        for (Window child : windows) {
            child.setVisible(true);
        }
    }

    boolean isToolbarVisible(JComponent toolBar) {
        String completeKeyString = this.completeVisiblePropertyKey(toolBar);
        if (completeKeyString == null) {
            return true;
        }
        return !"false".equals(ResourceController.getResourceController().getProperty(completeKeyString, "true"));
    }

    @Override
    public String completeVisiblePropertyKey(JComponent toolBar) {
        Object key = toolBar.getClientProperty("VISIBLE_PROPERTY_KEY");
        if (key == null) {
            return null;
        }
        String keyString = key.toString();
        String completeKeyString = this.isFullScreenEnabled() ? keyString + ".fullscreen" : keyString;
        return this.getPropertyKeyPrefix() + completeKeyString;
    }

    @Override
    public boolean isFullScreenEnabled() {
        return !this.getFrame().isResizable();
    }

    protected String getPropertyKeyPrefix() {
        return this.propertyKeyPrefix;
    }

    public static void setLookAndFeel(String lookAndFeel) {
        try {
            if (lookAndFeel.equals("default")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.LookAndFeelInfo[] lafInfos = UIManager.getInstalledLookAndFeels();
                boolean setLnF = false;
                for (UIManager.LookAndFeelInfo lafInfo : lafInfos) {
                    if (lafInfo.getName().equalsIgnoreCase(lookAndFeel)) {
                        UIManager.setLookAndFeel(lafInfo.getClassName());
                        Controller.getCurrentController().getResourceController().setProperty("lookandfeel", lafInfo.getClassName());
                        setLnF = true;
                        break;
                    }
                    if (!lafInfo.getClassName().equals(lookAndFeel)) continue;
                    UIManager.setLookAndFeel(lafInfo.getClassName());
                    setLnF = true;
                    break;
                }
                if (!setLnF) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    Controller.getCurrentController().getResourceController().setProperty("lookandfeel", "default");
                }
            }
        }
        catch (Exception ex) {
            LogUtils.warn("Error while setting Look&Feel" + lookAndFeel);
        }
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        try {
            new JFileChooser();
        }
        catch (Throwable t) {
            try {
                UIManager.getLookAndFeelDefaults().put("FileChooserUI", MetalFileChooserUI.class.getName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void addObjectTypeInfo(Object value) {
        if (value instanceof FormattedObject) {
            value = ((FormattedObject)value).getObject();
        }
        if (value instanceof String || value instanceof StyleNamedObject) {
            this.addStatusInfo("ObjectType", null, textIcon);
        } else if (value instanceof FormattedDate) {
            FormattedDate fd = (FormattedDate)value;
            if (fd.containsTime()) {
                this.addStatusInfo("ObjectType", null, dateTimeIcon);
            } else {
                this.addStatusInfo("ObjectType", null, dateIcon);
            }
        } else if (value instanceof Number) {
            this.addStatusInfo("ObjectType", null, numberIcon);
        } else if (value instanceof URI) {
            this.addStatusInfo("ObjectType", null, linkIcon);
        } else {
            this.addStatusInfo("ObjectType", null, null);
        }
    }

    public static ComboBoxEditor getTextDateTimeEditor() {
        ContainerComboBoxEditor editor = new ContainerComboBoxEditor();
        NamedObject keyText = new NamedObject("text", "1Ab");
        FixedBasicComboBoxEditor textEditor = new FixedBasicComboBoxEditor(){
            private Object oldItem;

            public void setItem(Object object) {
                this.oldItem = object;
                if (object instanceof FormattedDate) {
                    super.setItem("");
                } else {
                    super.setItem(object);
                }
            }

            public Object getItem() {
                Object item = super.getItem();
                Object oldItem = this.oldItem;
                this.oldItem = null;
                if (item != null && oldItem != null && item.toString().equals(oldItem.toString())) {
                    return oldItem;
                }
                if (ResourceController.getResourceController().getBooleanProperty("parse_data") && item instanceof String) {
                    Object scannedObject = ScannerController.getController().parse((String)item);
                    return scannedObject;
                }
                return item;
            }
        };
        editor.put(keyText, textEditor);
        NamedObject keyDate = new NamedObject("date", "");
        keyDate.setIcon(dateIcon);
        TimeComboBoxEditor dateComboBoxEditor = new TimeComboBoxEditor(false){

            public void setItem(Object object) {
                if (object instanceof FormattedDate && !((FormattedDate)object).containsTime()) {
                    super.setItem(object);
                } else {
                    super.setItem(null);
                }
            }
        };
        dateComboBoxEditor.setItem();
        editor.put(keyDate, dateComboBoxEditor);
        NamedObject keyDateTime = new NamedObject("date_time", "");
        keyDateTime.setIcon(dateTimeIcon);
        TimeComboBoxEditor dateTimeComboBoxEditor = new TimeComboBoxEditor(true){

            public void setItem(Object object) {
                if (object instanceof FormattedDate && ((FormattedDate)object).containsTime()) {
                    super.setItem(object);
                } else {
                    super.setItem(null);
                }
            }
        };
        dateTimeComboBoxEditor.setItem();
        editor.put(keyDateTime, dateTimeComboBoxEditor);
        return editor;
    }

    @Override
    public boolean quit() {
        return this.getController().getMapViewManager().closeAllMaps();
    }

    @Override
    public boolean isDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    @Override
    public void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    @Override
    public void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(runnable);
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    private final class HorizontalToolbarPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private HorizontalToolbarPanel(LayoutManager layout) {
            super(layout);
        }

        public void validateTree() {
            if (!this.isValid()) {
                super.validateTree();
                this.resizeToolbarPane();
            }
        }

        private void resizeToolbarPane() {
            Dimension preferredSize;
            int lastComponent;
            if (this.getWidth() == 0) {
                return;
            }
            for (lastComponent = this.getComponentCount() - 1; lastComponent >= 0 && !this.getComponent(lastComponent).isVisible(); --lastComponent) {
            }
            Dimension oldPreferredSize = this.getPreferredSize();
            if (lastComponent >= 0) {
                Component component = this.getComponent(lastComponent);
                preferredSize = new Dimension(this.getWidth(), component.getY() + component.getHeight());
            } else {
                preferredSize = new Dimension(0, 0);
            }
            if (oldPreferredSize.height != preferredSize.height) {
                this.setPreferredSize(preferredSize);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        HorizontalToolbarPanel.this.getParent().invalidate();
                        ((JComponent)FrameController.this.getContentPane()).revalidate();
                    }
                });
            }
        }
    }
}

