/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.time;

import java.util.Date;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.time.TimeComboBoxEditor;
import org.freeplane.features.time.TimeCondition;
import org.freeplane.features.time.TimeConditionCreatedAfter;
import org.freeplane.features.time.TimeConditionCreatedBefore;
import org.freeplane.features.time.TimeConditionModifiedAfter;
import org.freeplane.features.time.TimeConditionModifiedBefore;
import org.freeplane.n3.nanoxml.XMLElement;

public class TimeConditionController
implements IElementaryConditionController {
    static final String FILTER_TIME = "filter_time";
    private final ComboBoxEditor editor = new TimeComboBoxEditor(true);
    private final ComboBoxModel values = new DefaultComboBoxModel();

    public boolean canEditValues(Object property, NamedObject simpleCond) {
        return true;
    }

    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof NamedObject)) {
            return false;
        }
        NamedObject namedObject = (NamedObject)selectedItem;
        return namedObject.objectEquals(FILTER_TIME);
    }

    public boolean canSelectValues(Object property, NamedObject simpleCond) {
        return true;
    }

    public ASelectableCondition createCondition(Object selectedItem, NamedObject simpleCond, Object value, boolean matchCase, boolean matchApproximately) {
        return TimeCondition.create(simpleCond, (FormattedDate)value);
    }

    public ComboBoxModel getConditionsForProperty(Object property) {
        return new DefaultComboBoxModel<Object>(this.getTimeConditionNames());
    }

    public ListModel getFilteredProperties() {
        DefaultListModel<NamedObject> list = new DefaultListModel<NamedObject>();
        list.addElement(TextUtils.createTranslatedString(FILTER_TIME));
        return list;
    }

    public Object[] getTimeConditionNames() {
        return new NamedObject[]{TextUtils.createTranslatedString("filter_modified_after"), TextUtils.createTranslatedString("filter_modified_before"), TextUtils.createTranslatedString("filter_created_after"), TextUtils.createTranslatedString("filter_created_before")};
    }

    public ComboBoxEditor getValueEditor(Object selectedProperty, NamedObject selectedCondition) {
        return this.editor;
    }

    public ComboBoxModel getValuesForProperty(Object selectedItem, NamedObject simpleCond) {
        this.values.setSelectedItem(FormattedDate.createDefaultFormattedDate(new Date().getTime(), "datetime"));
        return this.values;
    }

    public boolean isCaseDependent(Object property, NamedObject simpleCond) {
        return false;
    }

    public boolean supportsApproximateMatching(Object property, NamedObject simpleCond) {
        return false;
    }

    public ASelectableCondition loadCondition(XMLElement element) {
        try {
            if (element.getName().equalsIgnoreCase("time_condition_created_before")) {
                String dateString = element.getAttribute("DATE", null);
                FormattedDate date = FormattedDate.createDefaultFormattedDate(Long.parseLong(dateString), "datetime");
                return new TimeConditionCreatedBefore(date);
            }
            if (element.getName().equalsIgnoreCase("time_condition_created_after")) {
                String dateString = element.getAttribute("DATE", null);
                FormattedDate date = FormattedDate.createDefaultFormattedDate(Long.parseLong(dateString), "datetime");
                return new TimeConditionCreatedAfter(date);
            }
            if (element.getName().equalsIgnoreCase("time_condition_modified_before")) {
                String dateString = element.getAttribute("DATE", null);
                FormattedDate date = FormattedDate.createDefaultFormattedDate(Long.parseLong(dateString), "datetime");
                return new TimeConditionModifiedBefore(date);
            }
            if (element.getName().equalsIgnoreCase("time_condition_modified_after")) {
                String dateString = element.getAttribute("DATE", null);
                FormattedDate date = FormattedDate.createDefaultFormattedDate(Long.parseLong(dateString), "datetime");
                return new TimeConditionModifiedAfter(date);
            }
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
        return null;
    }

    public ListCellRenderer getValueRenderer(Object selectedProperty, NamedObject selectedCondition) {
        return null;
    }
}

