/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.time;

import java.awt.Component;
import java.text.MessageFormat;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.n3.nanoxml.XMLElement;

@NodeHookDescriptor(hookName="accessories/plugins/CreationModificationPlugin.properties")
public class CreationModificationPlugin
extends PersistentNodeHook
implements IExtension {
    private static final Integer CREATION_TOOLTIP = 14;
    private String tooltipFormat = null;

    public CreationModificationPlugin() {
        Controller.getCurrentModeController().addToolTipProvider(CREATION_TOOLTIP, new ITooltipProvider(){

            public String getTooltip(ModeController modeController, NodeModel node, Component view) {
                if (!CreationModificationPlugin.this.isActive(node)) {
                    return null;
                }
                Object[] messageArguments = new Object[]{node.getHistoryInformation().getCreatedAt(), node.getHistoryInformation().getLastModifiedAt()};
                if (CreationModificationPlugin.this.tooltipFormat == null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>");
                    sb.append(TextUtils.getText("plugins/TimeList.xml_Created"));
                    sb.append(":  {0,date} {0,time}<br>");
                    sb.append(TextUtils.getText("plugins/TimeList.xml_Modified"));
                    sb.append(": {1,date} {1,time}</html>");
                    CreationModificationPlugin.this.tooltipFormat = sb.toString();
                }
                MessageFormat formatter = new MessageFormat(CreationModificationPlugin.this.tooltipFormat);
                String message = formatter.format(messageArguments);
                return message;
            }
        });
    }

    protected IExtension createExtension(NodeModel node, XMLElement element) {
        return this;
    }
}

