/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.DetailTextModel;
import org.freeplane.features.text.TextController;

class ToggleDetailsAction
extends AMultipleNodeAction {
    private static final long serialVersionUID = 1L;
    private boolean foundDetails;
    private boolean isHidden;

    public ToggleDetailsAction() {
        super("ToggleDetailsAction");
    }

    public void actionPerformed(ActionEvent e) {
        this.checkDetailsEnabled();
        if (!this.foundDetails) {
            return;
        }
        this.isHidden = !this.isHidden;
        IMapSelection selection = Controller.getCurrentController().getSelection();
        selection.keepNodePosition(selection.getSelected(), 0.5f, 0.5f);
        super.actionPerformed(e);
    }

    protected void actionPerformed(ActionEvent e, NodeModel node) {
        DetailTextModel detailText = DetailTextModel.getDetailText(node);
        if (detailText == null) {
            return;
        }
        TextController controller = TextController.getController();
        controller.setDetailsHidden(node, this.isHidden);
    }

    private void checkDetailsEnabled() {
        this.foundDetails = false;
        this.isHidden = false;
        Collection<NodeModel> nodes = Controller.getCurrentModeController().getMapController().getSelectedNodes();
        for (NodeModel node : nodes) {
            DetailTextModel detailText = DetailTextModel.getDetailText(node);
            if (detailText == null) continue;
            this.foundDetails = true;
            this.isHidden = detailText.isHidden();
            break;
        }
    }
}

