/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.text.DetailTextModel;
import org.freeplane.features.text.FormatContentTransformer;
import org.freeplane.features.text.HighlightedTransformedObject;
import org.freeplane.features.text.IContentTransformer;
import org.freeplane.features.text.NodeTextBuilder;
import org.freeplane.features.text.NodeTextConditionController;
import org.freeplane.features.text.SetShortenerStateAction;
import org.freeplane.features.text.ShortenedTextModel;
import org.freeplane.features.text.ToggleDetailsAction;
import org.freeplane.features.text.TransformationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextController
implements IExtension {
    public static final String FILTER_NODE = "filter_node";
    public static final String FILTER_ANYTEXT = "filter_any_text";
    public static final String FILTER_NOTE = "filter_note";
    public static final String FILTER_PARENT = "filter_parent";
    public static final String FILTER_DETAILS = "filter_details";
    private static final Integer NODE_TOOLTIP = 1;
    private static final Integer DETAILS_TOOLTIP = 2;
    private final List<IContentTransformer> textTransformers = new LinkedList<IContentTransformer>();
    protected final ModeController modeController;
    public static final String MARK_TRANSFORMED_TEXT = "highlight_formulas";

    public static boolean isMarkTransformedTextSet() {
        return Controller.getCurrentController().getResourceController().getBooleanProperty(MARK_TRANSFORMED_TEXT);
    }

    public static TextController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return TextController.getController(modeController);
    }

    public static TextController getController(ModeController modeController) {
        return modeController.getExtension(TextController.class);
    }

    public static void install() {
        FilterController.getCurrentFilterController().getConditionFactory().addConditionController(0, new NodeTextConditionController());
    }

    public static void install(TextController textController) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(TextController.class, textController);
    }

    public TextController(ModeController modeController) {
        this.modeController = modeController;
        MapController mapController = modeController.getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        NodeTextBuilder textBuilder = new NodeTextBuilder();
        textBuilder.registerBy(readManager, writeManager);
        writeManager.addExtensionElementWriter(DetailTextModel.class, textBuilder);
        writeManager.addExtensionAttributeWriter(ShortenedTextModel.class, textBuilder);
        modeController.addAction(new ToggleDetailsAction());
        modeController.addAction(new SetShortenerStateAction());
        this.addTextTransformer(new FormatContentTransformer(this, 50));
        this.registerDetailsTooltip();
        this.registerNodeTextTooltip();
    }

    public void addTextTransformer(IContentTransformer textTransformer) {
        this.textTransformers.add(textTransformer);
        Collections.sort(this.textTransformers);
    }

    public List<IContentTransformer> getTextTransformers() {
        return this.textTransformers;
    }

    public void removeTextTransformer(IContentTransformer textTransformer) {
        this.textTransformers.remove(textTransformer);
    }

    public String getText(NodeModel nodeModel) {
        return nodeModel.getText();
    }

    public Object getTransformedObject(Object object, NodeModel nodeModel, Object extension) throws TransformationException {
        String string;
        if (object instanceof String && ResourceController.getResourceController().getBooleanProperty("parse_data") && (string = (String)object).length() > 0 && string.charAt(0) == '\'') {
            if (this.isTextFormattingDisabled(nodeModel)) {
                return string;
            }
            return string.substring(1);
        }
        boolean markTransformation = false;
        for (IContentTransformer textTransformer : this.getTextTransformers()) {
            try {
                Object in = object;
                object = textTransformer.transformContent(this, in, nodeModel, extension);
                markTransformation = markTransformation || textTransformer.markTransformation() && !in.equals(object);
            }
            catch (RuntimeException e) {
                throw new TransformationException(e);
            }
        }
        if (markTransformation) {
            return new HighlightedTransformedObject(object);
        }
        return object;
    }

    public Icon getIcon(Object object, NodeModel nodeModel, Object extension) {
        if (object instanceof HighlightedTransformedObject) {
            return this.getIcon(((HighlightedTransformedObject)object).getObject(), nodeModel, extension);
        }
        for (IContentTransformer textTransformer : this.getTextTransformers()) {
            Icon icon = textTransformer.getIcon(this, object, nodeModel, extension);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    public boolean isTextFormattingDisabled(NodeModel nodeModel) {
        return "NO_FORMAT".equals(this.getNodeFormat(nodeModel));
    }

    public Object getTransformedObjectNoThrow(Object data, NodeModel node, Object extension) {
        try {
            return this.getTransformedObject(data, node, extension);
        }
        catch (Throwable e) {
            LogUtils.warn(e.getMessage(), e);
            return TextUtils.format("MainView.errorUpdateText", data, e.getLocalizedMessage());
        }
    }

    public Object getTransformedObject(NodeModel node) throws TransformationException {
        Object userObject = node.getUserObject();
        return this.getTransformedObject(userObject, node, userObject);
    }

    public Object getTransformedObjectNoThrow(NodeModel node) {
        Object userObject = node.getUserObject();
        return this.getTransformedObjectNoThrow(userObject, node, userObject);
    }

    public String getTransformedText(Object text, NodeModel nodeModel, Object extension) throws TransformationException {
        text = this.getTransformedObject(text, nodeModel, extension);
        return text.toString();
    }

    public String getTransformedTextNoThrow(Object text, NodeModel nodeModel, Object extension) {
        text = this.getTransformedObjectNoThrow(text, nodeModel, extension);
        return text.toString();
    }

    public boolean isMinimized(NodeModel node) {
        ShortenedTextModel shortened = ShortenedTextModel.getShortenedTextModel(node);
        return shortened != null;
    }

    public String getPlainTextContent(NodeModel nodeModel) {
        String text = this.getTransformedTextNoThrow(nodeModel);
        return HtmlUtils.htmlToPlain(text);
    }

    public String getTransformedTextNoThrow(NodeModel nodeModel) {
        Object userObject = nodeModel.getUserObject();
        Object input = userObject instanceof String && HtmlUtils.isHtmlNode((String)userObject) ? HtmlUtils.htmlToPlain((String)userObject) : userObject;
        String text = this.getTransformedTextNoThrow(input, nodeModel, userObject);
        return text;
    }

    public String getShortText(NodeModel nodeModel) {
        String adaptedText = this.getPlainTextContent(nodeModel);
        if (adaptedText.length() > 40) {
            adaptedText = adaptedText.substring(0, 40) + " ...";
        }
        return adaptedText;
    }

    public void setDetailsHidden(NodeModel node, boolean isHidden) {
        DetailTextModel details = DetailTextModel.createDetailText(node);
        if (isHidden == details.isHidden()) {
            return;
        }
        details.setHidden(isHidden);
        node.addExtension(details);
        Controller.getCurrentModeController().getMapController().nodeChanged(node, "DETAILS_HIDDEN", !isHidden, isHidden);
    }

    private void registerDetailsTooltip() {
        this.modeController.addToolTipProvider(DETAILS_TOOLTIP, new ITooltipProvider(){

            public String getTooltip(ModeController modeController, NodeModel node, Component view) {
                DetailTextModel detailText = DetailTextModel.getDetailText(node);
                if (detailText == null || !detailText.isHidden() && !ShortenedTextModel.isShortened(node)) {
                    return null;
                }
                NodeStyleController style = modeController.getExtension(NodeStyleController.class);
                MapStyleModel model = MapStyleModel.getExtension(node.getMap());
                NodeModel detailStyleNode = model.getStyleNodeSafe(MapStyleModel.DETAILS_STYLE);
                Font detailFont = style.getFont(detailStyleNode);
                Color detailBackground = style.getBackgroundColor(detailStyleNode);
                Color detailForeground = style.getColor(detailStyleNode);
                StringBuilder rule = new StringBuilder();
                rule.append("font-family: " + detailFont.getFamily() + ";");
                rule.append("font-size: " + detailFont.getSize() + "pt;");
                if (detailFont.isItalic()) {
                    rule.append("font-style: italic; ");
                }
                if (detailFont.isBold()) {
                    rule.append("font-weight: bold; ");
                }
                rule.append("color: ").append(ColorUtils.colorToString(detailForeground)).append(";");
                rule.append("background-color: ").append(ColorUtils.colorToString(detailBackground)).append(";");
                String noteText = detailText.getHtml();
                String tooltipText = noteText.replaceFirst("<body>", "<body><div style=\"" + rule + "\">").replaceFirst("</body>", "</div></body>");
                return tooltipText;
            }
        });
    }

    private void registerNodeTextTooltip() {
        this.modeController.addToolTipProvider(NODE_TOOLTIP, new ITooltipProvider(){

            public String getTooltip(ModeController modeController, NodeModel node, Component view) {
                String text;
                if (!ShortenedTextModel.isShortened(node)) {
                    return null;
                }
                NodeStyleController style = modeController.getExtension(NodeStyleController.class);
                Font font = style.getFont(node);
                StringBuilder rule = new StringBuilder();
                rule.append("font-family: " + font.getFamily() + ";");
                rule.append("font-size: " + font.getSize() + "pt;");
                rule.append("margin-top:0;");
                if (font.isItalic()) {
                    rule.append("font-style: italic; ");
                }
                if (font.isBold()) {
                    rule.append("font-weight: bold; ");
                }
                Color nodeTextColor = view.getForeground();
                rule.append("color: ").append(ColorUtils.colorToString(nodeTextColor)).append(";");
                Object data = node.getUserObject();
                try {
                    text = TextController.this.getTransformedText(data, node, data);
                }
                catch (Exception e) {
                    text = TextUtils.format("MainView.errorUpdateText", data, e.getLocalizedMessage());
                    rule.append("color:red;");
                }
                if (!HtmlUtils.isHtmlNode(text)) {
                    text = HtmlUtils.plainToHTML(text);
                }
                String tooltipText = text.replaceFirst("<body>", "<body><div style=\"" + rule + "\">").replaceFirst("</body>", "</div></body>");
                return tooltipText;
            }
        });
    }

    public void setIsMinimized(NodeModel node, boolean shortened) {
        boolean oldState;
        boolean bl = oldState = ShortenedTextModel.getShortenedTextModel(node) != null;
        if (oldState == shortened) {
            return;
        }
        if (shortened) {
            ShortenedTextModel.createShortenedTextModel(node);
        } else {
            node.removeExtension(ShortenedTextModel.class);
        }
        Controller.getCurrentModeController().getMapController().nodeChanged(node, "SHORTENER", oldState, shortened);
    }

    public void toggleShortened(NodeModel node) {
        this.setIsMinimized(node, !this.isMinimized(node));
    }

    public String getNodeFormat(NodeModel node) {
        Collection<IStyle> collection = LogicalStyleController.getController(this.modeController).getStyles(node);
        MapStyleModel model = MapStyleModel.getExtension(node.getMap());
        for (IStyle styleKey : collection) {
            String format;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (format = NodeStyleModel.getNodeFormat(styleNode)) == null) continue;
            return format;
        }
        return this.parseData() ? "STANDARD_FORMAT" : "NO_FORMAT";
    }

    public boolean parseData() {
        return false;
    }

    public boolean getNodeNumbering(NodeModel node) {
        Collection<IStyle> collection = LogicalStyleController.getController(this.modeController).getStyles(node);
        MapStyleModel model = MapStyleModel.getExtension(node.getMap());
        for (IStyle styleKey : collection) {
            Boolean numbering;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (numbering = NodeStyleModel.getNodeNumbering(styleNode)) == null) continue;
            return numbering;
        }
        return false;
    }

    public ModeController getModeController() {
        return this.modeController;
    }
}

